/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.converter;

import com.greatmancode.com.zaxxer.libs.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.libs.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.LogInfo;
import com.greatmancode.craftconomy3.currency.Currency;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class H2ToMySQLConverter {
    private Map<Integer, Account> accountList = new HashMap<Integer, Account>();
    private Map<String, Currency> currencyList = new HashMap<String, Currency>();
    private List<Config> configList = new ArrayList<Config>();
    private List<Exchange> exchangeList = new ArrayList<Exchange>();
    private List<WorldGroup> worldGroupList = new ArrayList<WorldGroup>();
    private HikariDataSource db;
    private String prefix;

    public void run() {
        Common.getInstance().sendConsoleMessage(Level.INFO, Common.getInstance().getLanguageManager().getString("starting_database_convert"));
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setMaximumPoolSize(Common.getInstance().getMainConfig().getInt("System.Database.Poolsize"));
        hikariConfig.setDataSourceClassName("org.h2.jdbcx.JdbcDataSource");
        hikariConfig.addDataSourceProperty("user", "sa");
        hikariConfig.addDataSourceProperty("url", "jdbc:h2:file:" + new File(Common.getInstance().getServerCaller().getDataFolder().getPath(), "database").getAbsolutePath() + ";MV_STORE=FALSE");
        hikariConfig.setConnectionTimeout(5000L);
        this.db = new HikariDataSource(hikariConfig);
        this.prefix = Common.getInstance().getMainConfig().getString("System.Database.Prefix");
        try {
            Connection connection = this.db.getConnection();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting accounts information");
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "account");
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                Account account = new Account();
                account.id = set.getInt("id");
                account.name = set.getString("name");
                account.ignoreACL = set.getBoolean("ignoreACL");
                if (set.getString("uuid") != null) {
                    account.uuid = UUID.fromString(set.getString("uuid"));
                } else if (!set.getBoolean("bank")) {
                    account.uuid = Common.getInstance().getServerCaller().getPlayerCaller().getUUID(account.name);
                }
                account.infiniteMoney = set.getBoolean("infiniteMoney");
                account.bank = set.getBoolean("bank");
                this.accountList.put(account.id, account);
            }
            set.close();
            statement.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting currency table information");
            statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "currency");
            set = statement.executeQuery();
            while (set.next()) {
                Currency currency = new Currency(set.getString("name"), set.getString("plural"), set.getString("minor"), set.getString("minorPlural"), set.getString("sign"), set.getBoolean("status"));
                this.currencyList.put(currency.getName(), currency);
            }
            set.close();
            statement.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting Balance table information");
            statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "balance");
            set = statement.executeQuery();
            while (set.next()) {
                Balance balance = new Balance();
                balance.balance = set.getDouble("balance");
                balance.worldName = set.getString("worldName");
                balance.currency_id = set.getString("currency_id");
                this.accountList.get((Object)Integer.valueOf((int)set.getInt((String)"username_id"))).balanceList.add(balance);
            }
            set.close();
            statement.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting access table information");
            statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "acl");
            set = statement.executeQuery();
            while (set.next()) {
                Access access = new Access();
                access.acl = set.getBoolean("acl");
                access.balance = set.getBoolean("balance");
                access.deposit = set.getBoolean("deposit");
                access.owner = set.getBoolean("owner");
                access.withdraw = set.getBoolean("withdraw");
                access.playerName = set.getString("playerName");
                this.accountList.get((Object)Integer.valueOf((int)set.getInt((String)"account_id"))).accessList.add(access);
            }
            set.close();
            statement.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting config table information");
            statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "config");
            set = statement.executeQuery();
            while (set.next()) {
                Config config = new Config();
                config.name = set.getString("name");
                config.value = set.getString("value");
                this.configList.add(config);
            }
            set.close();
            statement.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting Exchange table information");
            statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "exchange");
            set = statement.executeQuery();
            while (set.next()) {
                Exchange exchange = new Exchange();
                exchange.currency_id_from = set.getString("from_currency");
                exchange.currency_id_to = set.getString("to_currency");
                exchange.amount = set.getInt("amount");
                this.exchangeList.add(exchange);
            }
            set.close();
            statement.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting log table information");
            statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "log");
            set = statement.executeQuery();
            while (set.next()) {
                Log log = new Log();
                log.amount = set.getDouble("amount");
                log.cause = set.getString("cause");
                log.causeReason = set.getString("causeReason");
                log.currency_id = set.getString("currency_id");
                log.timestamp = set.getTimestamp("timestamp");
                log.type = set.getString("type");
                log.worldName = set.getString("worldName");
                this.accountList.get((Object)Integer.valueOf((int)set.getInt((String)"username_id"))).logList.add(log);
            }
            set.close();
            statement.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Getting world group information");
            statement = connection.prepareStatement("SELECT * FROM " + this.prefix + "worldgroup");
            set = statement.executeQuery();
            while (set.next()) {
                WorldGroup worldGroup = new WorldGroup();
                worldGroup.groupName = set.getString("groupName");
                worldGroup.worldList = set.getString("worldList");
                this.worldGroupList.add(worldGroup);
            }
            set.close();
            statement.close();
            Common.getInstance().getStorageHandler().getStorageEngine().disableAutoCommit();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Inserting currency information");
            for (Map.Entry<String, Currency> entry : this.currencyList.entrySet()) {
                Common.getInstance().getStorageHandler().getStorageEngine().saveCurrency(entry.getValue().getName(), entry.getValue());
            }
            Common.getInstance().sendConsoleMessage(Level.INFO, "Inserting config information");
            for (Config config : this.configList) {
                Common.getInstance().getStorageHandler().getStorageEngine().setConfigEntry(config.name, config.value);
            }
            Common.getInstance().sendConsoleMessage(Level.INFO, "Inserting Exchange information");
            for (Exchange exchange : this.exchangeList) {
                Common.getInstance().getStorageHandler().getStorageEngine().setExchangeRate(this.currencyList.get(exchange.currency_id_from), this.currencyList.get(exchange.currency_id_to), exchange.amount);
            }
            Common.getInstance().sendConsoleMessage(Level.INFO, "Inserting World Group information");
            for (WorldGroup worldGroup : this.worldGroupList) {
                Common.getInstance().getStorageHandler().getStorageEngine().saveWorldGroup(worldGroup.groupName, worldGroup.worldList);
            }
            Common.getInstance().sendConsoleMessage(Level.INFO, "Inserting account/balance/log/access information");
            for (Map.Entry entry : this.accountList.entrySet()) {
                com.greatmancode.craftconomy3.account.Account account = Common.getInstance().getStorageHandler().getStorageEngine().getAccount(((Account)entry.getValue()).name, ((Account)entry.getValue()).bank, false);
                Common.getInstance().getStorageHandler().getStorageEngine().updateUUID(((Account)entry.getValue()).name, ((Account)entry.getValue()).uuid);
                Common.getInstance().getStorageHandler().getStorageEngine().setInfiniteMoney(account, ((Account)entry.getValue()).infiniteMoney);
                Common.getInstance().getStorageHandler().getStorageEngine().setIgnoreACL(account, ((Account)entry.getValue()).ignoreACL);
                for (Balance balance : ((Account)entry.getValue()).balanceList) {
                    Common.getInstance().getStorageHandler().getStorageEngine().setBalance(account, balance.balance, this.currencyList.get(balance.currency_id), balance.worldName);
                }
                for (Access access : ((Account)entry.getValue()).accessList) {
                    Common.getInstance().getStorageHandler().getStorageEngine().saveACL(account, access.playerName, access.deposit, access.withdraw, access.acl, access.balance, access.owner);
                }
                for (Log log : ((Account)entry.getValue()).logList) {
                    Common.getInstance().getStorageHandler().getStorageEngine().saveLog(LogInfo.valueOf(log.type.toUpperCase()), Cause.valueOf(log.cause.toUpperCase()), log.causeReason, account, log.amount, this.currencyList.get(log.currency_id), log.worldName, log.timestamp);
                }
            }
            Common.getInstance().getStorageHandler().getStorageEngine().commit();
            Common.getInstance().getStorageHandler().getStorageEngine().enableAutoCommit();
            connection.close();
            this.db.close();
            Common.getInstance().sendConsoleMessage(Level.INFO, "Convertion complete!");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private class WorldGroup {
        public String worldList;
        public String groupName;

        private WorldGroup() {
        }
    }

    private class Log {
        public String type;
        public String cause;
        public String causeReason;
        public String worldName;
        public String currency_id;
        public Timestamp timestamp;
        public double amount;

        private Log() {
        }
    }

    private class Exchange {
        public String currency_id_from;
        public String currency_id_to;
        public double amount;

        private Exchange() {
        }
    }

    private class Config {
        public String name;
        public String value;

        private Config() {
        }
    }

    private class Access {
        public boolean owner;
        public boolean balance;
        public boolean deposit;
        public boolean acl;
        public boolean withdraw;
        public String playerName;

        private Access() {
        }
    }

    private class Balance {
        public double balance;
        public String worldName;
        public String currency_id;

        private Balance() {
        }
    }

    private class Account {
        public String name;
        public UUID uuid;
        public boolean infiniteMoney;
        public boolean ignoreACL;
        public boolean bank;
        public int id;
        public List<Balance> balanceList = new ArrayList<Balance>();
        public List<Access> accessList = new ArrayList<Access>();
        public List<Log> logList = new ArrayList<Log>();

        private Account() {
        }
    }
}

