/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.commands.bank;

import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandExecutor;
import com.greatmancode.craftconomy3.tools.utils.Tools;

public class BankSetCommand
extends CommandExecutor {
    @Override
    public void execute(String sender, String[] args) {
        if (Common.getInstance().getAccountManager().exist(args[0], true)) {
            Account bankAccount = Common.getInstance().getAccountManager().getAccount(args[0], true);
            if (Tools.isValidDouble(args[1])) {
                double amount = Double.parseDouble(args[1]);
                Currency currency = Common.getInstance().getCurrencyManager().getDefaultCurrency();
                if (args.length > 2) {
                    if (Common.getInstance().getCurrencyManager().getCurrency(args[2]) != null) {
                        currency = Common.getInstance().getCurrencyManager().getCurrency(args[2]);
                    } else {
                        Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("currency_not_exist"));
                        return;
                    }
                }
                String worldName = Account.getWorldGroupOfPlayerCurrentlyIn(sender);
                if (args.length > 3) {
                    if (!Common.getInstance().getServerCaller().worldExist(args[3])) {
                        Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("world_not_exist"));
                        return;
                    }
                    worldName = Common.getInstance().getWorldGroupManager().getWorldGroupName(args[3]);
                }
                bankAccount.set(amount, worldName, currency.getName(), Cause.USER, sender);
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().parse("bank_set_success", Common.getInstance().format(worldName, currency, amount), args[0]));
            } else {
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("invalid_amount"));
            }
        } else {
            Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, Common.getInstance().getLanguageManager().getString("account_not_exist"));
        }
    }

    @Override
    public String help() {
        return Common.getInstance().getLanguageManager().getString("bank_set_cmd_help");
    }

    @Override
    public int maxArgs() {
        return 3;
    }

    @Override
    public int minArgs() {
        return 2;
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "craftconomy.bank.set";
    }
}

