/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3;

import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.DisplayFormat;
import com.greatmancode.craftconomy3.LogInfo;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.account.AccountManager;
import com.greatmancode.craftconomy3.commands.bank.BankBalanceCommand;
import com.greatmancode.craftconomy3.commands.bank.BankCreateCommand;
import com.greatmancode.craftconomy3.commands.bank.BankDeleteCommand;
import com.greatmancode.craftconomy3.commands.bank.BankDepositCommand;
import com.greatmancode.craftconomy3.commands.bank.BankGiveCommand;
import com.greatmancode.craftconomy3.commands.bank.BankIgnoreACLCommand;
import com.greatmancode.craftconomy3.commands.bank.BankListCommand;
import com.greatmancode.craftconomy3.commands.bank.BankPermCommand;
import com.greatmancode.craftconomy3.commands.bank.BankSetCommand;
import com.greatmancode.craftconomy3.commands.bank.BankTakeCommand;
import com.greatmancode.craftconomy3.commands.bank.BankWithdrawCommand;
import com.greatmancode.craftconomy3.commands.config.ConfigBankPriceCommand;
import com.greatmancode.craftconomy3.commands.config.ConfigClearLogCommand;
import com.greatmancode.craftconomy3.commands.config.ConfigFormatCommand;
import com.greatmancode.craftconomy3.commands.config.ConfigHoldingsCommand;
import com.greatmancode.craftconomy3.commands.config.ConfigReloadCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyAddCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyDefaultCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyDeleteCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyEditCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyExchangeCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyInfoCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyListCommand;
import com.greatmancode.craftconomy3.commands.currency.CurrencyRatesCommand;
import com.greatmancode.craftconomy3.commands.group.GroupAddWorldCommand;
import com.greatmancode.craftconomy3.commands.group.GroupCreateCommand;
import com.greatmancode.craftconomy3.commands.group.GroupDelWorldCommand;
import com.greatmancode.craftconomy3.commands.money.AllCommand;
import com.greatmancode.craftconomy3.commands.money.BalanceCommand;
import com.greatmancode.craftconomy3.commands.money.CreateCommand;
import com.greatmancode.craftconomy3.commands.money.DeleteCommand;
import com.greatmancode.craftconomy3.commands.money.ExchangeCommand;
import com.greatmancode.craftconomy3.commands.money.GiveCommand;
import com.greatmancode.craftconomy3.commands.money.InfiniteCommand;
import com.greatmancode.craftconomy3.commands.money.LogCommand;
import com.greatmancode.craftconomy3.commands.money.MainCommand;
import com.greatmancode.craftconomy3.commands.money.PayCommand;
import com.greatmancode.craftconomy3.commands.money.SetCommand;
import com.greatmancode.craftconomy3.commands.money.TakeCommand;
import com.greatmancode.craftconomy3.commands.money.TopCommand;
import com.greatmancode.craftconomy3.commands.setup.NewSetupBasicCommand;
import com.greatmancode.craftconomy3.commands.setup.NewSetupConvertCommand;
import com.greatmancode.craftconomy3.commands.setup.NewSetupCurrencyCommand;
import com.greatmancode.craftconomy3.commands.setup.NewSetupDatabaseCommand;
import com.greatmancode.craftconomy3.commands.setup.NewSetupMainCommand;
import com.greatmancode.craftconomy3.converter.H2ToMySQLConverter;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.currency.CurrencyManager;
import com.greatmancode.craftconomy3.events.EventManager;
import com.greatmancode.craftconomy3.groups.WorldGroupsManager;
import com.greatmancode.craftconomy3.storage.StorageHandler;
import com.greatmancode.craftconomy3.tools.caller.bukkit.BukkitServerCaller;
import com.greatmancode.craftconomy3.tools.caller.unittest.UnitTestServerCaller;
import com.greatmancode.craftconomy3.tools.commands.CommandHandler;
import com.greatmancode.craftconomy3.tools.commands.SubCommand;
import com.greatmancode.craftconomy3.tools.configuration.Config;
import com.greatmancode.craftconomy3.tools.configuration.ConfigurationManager;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import com.greatmancode.craftconomy3.tools.language.LanguageManager;
import com.greatmancode.craftconomy3.tools.utils.FeatherBoard;
import com.greatmancode.craftconomy3.tools.utils.Metrics;
import com.greatmancode.craftconomy3.tools.utils.Tools;
import com.greatmancode.craftconomy3.tools.utils.Updater;
import com.greatmancode.craftconomy3.utils.OldFormatConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class Common
implements com.greatmancode.craftconomy3.tools.interfaces.Common {
    private Logger log = null;
    private static Common instance = null;
    private AccountManager accountManager = null;
    private ConfigurationManager config = null;
    private CurrencyManager currencyManager = null;
    private StorageHandler storageHandler = null;
    private EventManager eventManager = null;
    private LanguageManager languageManager = null;
    private WorldGroupsManager worldGroupManager = null;
    private CommandHandler commandManager = null;
    private ServerCaller serverCaller = null;
    private boolean databaseInitialized = false;
    private boolean currencyInitialized = false;
    private static boolean initialized = false;
    private Metrics metrics = null;
    private Config mainConfig = null;
    private Updater updater;
    private DisplayFormat displayFormat = null;
    private double holdings = 0.0;
    private double bankPrice = 0.0;

    @Override
    public void onEnable(ServerCaller serverCaller, Logger log) {
        this.serverCaller = serverCaller;
        instance = this;
        this.log = log;
        if (!initialized) {
            this.sendConsoleMessage(Level.INFO, "Starting up!");
            this.sendConsoleMessage(Level.INFO, "Loading the Configuration");
            this.config = new ConfigurationManager(serverCaller);
            this.mainConfig = this.config.loadFile(serverCaller.getDataFolder(), "config.yml");
            if (!this.mainConfig.has("System.Setup")) {
                this.initializeConfig();
            }
            if (!this.getMainConfig().has("System.Database.Prefix")) {
                this.getMainConfig().setValue("System.Database.Prefix", "cc3_");
            }
            if (!this.getMainConfig().has("System.Database.Poolsize")) {
                this.getMainConfig().setValue("System.Database.Poolsize", 10);
            }
            this.languageManager = new LanguageManager(serverCaller, serverCaller.getDataFolder(), "lang.yml");
            this.loadLanguage();
            serverCaller.setCommandPrefix(this.languageManager.getString("command_prefix"));
            if (!(this.getServerCaller() instanceof UnitTestServerCaller)) {
                try {
                    this.metrics = new Metrics("Craftconomy", this.getServerCaller().getPluginVersion(), serverCaller);
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, String.format(this.getLanguageManager().getString("metric_start_error"), e.getMessage()));
                }
            }
            if (this.getMainConfig().getBoolean("System.CheckNewVersion") && serverCaller instanceof BukkitServerCaller) {
                this.updater = new Updater(serverCaller, 35564, Updater.UpdateType.NO_DOWNLOAD, false);
                if (this.updater.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
                    this.sendConsoleMessage(Level.WARNING, this.getLanguageManager().parse("running_old_version", this.updater.getLatestName()));
                }
            }
            this.sendConsoleMessage(Level.INFO, "Loading listeners.");
            serverCaller.getLoader().getEventManager().registerEvents(this, new EventManager());
            this.sendConsoleMessage(Level.INFO, "Loading commands");
            Common.getInstance().getServerCaller().registerPermission("craftconomy.*");
            this.commandManager = new CommandHandler(serverCaller);
            this.registerCommands();
            if (this.getMainConfig().getBoolean("System.Setup")) {
                if (this.getMainConfig().getBoolean("System.QuickSetup.Enable")) {
                    this.quickSetup();
                    this.reloadPlugin();
                } else {
                    this.sendConsoleMessage(Level.WARNING, this.getLanguageManager().getString("loaded_setup_mode"));
                }
            } else {
                this.commandManager.setCurrentLevel(1);
                this.initialiseDatabase();
                this.updateDatabase();
                this.initializeCurrency();
                this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("loading_default_settings"));
                this.loadDefaultSettings();
                this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("default_settings_loaded"));
                this.startUp();
                this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("ready"));
            }
            this.getServerCaller().registerPermission("craftconomy.money.log.others");
            this.addFeatherboardSupport();
            initialized = true;
        }
    }

    @Override
    public void onDisable() {
        if (this.getStorageHandler() != null) {
            this.getLogger().info(this.getLanguageManager().getString("closing_db_link"));
            this.getStorageHandler().disable();
        }
        this.accountManager = null;
        this.config = null;
        this.currencyManager = null;
        this.storageHandler = null;
        this.eventManager = null;
        this.languageManager = null;
        this.worldGroupManager = null;
        this.commandManager = null;
        this.databaseInitialized = false;
        this.currencyInitialized = false;
        initialized = false;
        this.metrics = null;
        this.mainConfig = null;
        this.updater = null;
        this.displayFormat = null;
        this.holdings = 0.0;
        this.bankPrice = 0.0;
    }

    public void reloadPlugin() {
        this.sendConsoleMessage(Level.INFO, "Starting up!");
        this.sendConsoleMessage(Level.INFO, "Loading the Configuration");
        this.config = new ConfigurationManager(this.serverCaller);
        this.mainConfig = this.config.loadFile(this.serverCaller.getDataFolder(), "config.yml");
        if (!this.mainConfig.has("System.Setup")) {
            this.initializeConfig();
        }
        if (!this.getMainConfig().has("System.Database.Prefix")) {
            this.getMainConfig().setValue("System.Database.Prefix", "cc3_");
        }
        this.languageManager = new LanguageManager(this.serverCaller, this.serverCaller.getDataFolder(), "lang.yml");
        this.loadLanguage();
        this.serverCaller.setCommandPrefix(this.languageManager.getString("command_prefix"));
        this.commandManager.setCurrentLevel(1);
        this.initialiseDatabase();
        this.updateDatabase();
        this.initializeCurrency();
        this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("loading_default_settings"));
        this.loadDefaultSettings();
        this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("default_settings_loaded"));
        this.startUp();
        this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("ready"));
    }

    public Config getMainConfig() {
        return this.mainConfig;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void sendConsoleMessage(Level level, String msg) {
        if (!(this.getServerCaller() instanceof UnitTestServerCaller)) {
            this.getLogger().log(level, msg);
        }
    }

    public static Common getInstance() {
        return instance;
    }

    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.config;
    }

    public StorageHandler getStorageHandler() {
        return this.storageHandler;
    }

    public CurrencyManager getCurrencyManager() {
        return this.currencyManager;
    }

    public CommandHandler getCommandManager() {
        return this.commandManager;
    }

    public ServerCaller getServerCaller() {
        return this.serverCaller;
    }

    public String format(String worldName, Currency currency, double balance, DisplayFormat format) {
        StringBuilder string = new StringBuilder();
        if (worldName != null && !worldName.equals("default")) {
            string.append(worldName).append(": ");
        }
        if (currency != null) {
            String amount;
            String[] theAmount = BigDecimal.valueOf(balance).toPlainString().split("\\.");
            DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
            unusualSymbols.setGroupingSeparator(',');
            DecimalFormat decimalFormat = new DecimalFormat("###,###", unusualSymbols);
            String name = currency.getName();
            if (balance > 1.0 || balance < 1.0) {
                name = currency.getPlural();
            }
            String coin = theAmount.length == 2 ? (theAmount[1].length() >= 2 ? theAmount[1].substring(0, 2) : theAmount[1] + "0") : "0";
            try {
                amount = decimalFormat.format(Double.parseDouble(theAmount[0]));
            }
            catch (NumberFormatException e) {
                amount = theAmount[0];
            }
            if (format == DisplayFormat.LONG) {
                String subName = currency.getMinor();
                if (Long.parseLong(coin) > 1L) {
                    subName = currency.getMinorPlural();
                }
                string.append(amount).append(" ").append(name).append(" ").append(coin).append(" ").append(subName);
            } else if (format == DisplayFormat.SMALL) {
                string.append(amount).append(".").append(coin).append(" ").append(name);
            } else if (format == DisplayFormat.SIGN) {
                string.append(currency.getSign()).append(amount).append(".").append(coin);
            } else if (format == DisplayFormat.SIGNFRONT) {
                string.append(amount).append(".").append(coin).append(currency.getSign());
            } else if (format == DisplayFormat.MAJORONLY) {
                string.append(amount).append(" ").append(name);
            }
        }
        return string.toString();
    }

    public String format(String worldName, Currency currency, double balance) {
        return this.format(worldName, currency, balance, this.displayFormat);
    }

    public void initialiseDatabase() {
        if (!this.databaseInitialized) {
            this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("loading_database_manager"));
            this.storageHandler = new StorageHandler();
            if (this.getMainConfig().getBoolean("System.Database.ConvertFromH2")) {
                this.convertDatabase();
            }
            this.databaseInitialized = true;
            this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("database_manager_loaded"));
        }
    }

    private void convertDatabase() {
        this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("starting_database_convert"));
        new H2ToMySQLConverter().run();
        this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("convert_done"));
        this.getMainConfig().setValue("System.Database.ConvertFromH2", false);
    }

    public void initializeCurrency() {
        if (!this.currencyInitialized) {
            this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("loading_currency_manager"));
            this.currencyManager = new CurrencyManager();
            this.currencyInitialized = true;
            this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("currency_manager_loaded"));
        }
    }

    public void initializeWorldGroup() {
        if (this.worldGroupManager == null) {
            this.worldGroupManager = new WorldGroupsManager();
            this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("world_group_manager_loaded"));
        }
    }

    public void startUp() {
        this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("loading_account_manager"));
        this.accountManager = new AccountManager();
        this.startMetrics();
        this.sendConsoleMessage(Level.INFO, this.getLanguageManager().getString("account_manager_loaded"));
        this.eventManager = new EventManager();
        this.initializeWorldGroup();
    }

    public void addMetricsGraph(String title, String value) {
        if (this.metrics != null) {
            Metrics.Graph graph = this.metrics.createGraph(title);
            graph.addPlotter(new Metrics.Plotter(value){

                @Override
                public int getValue() {
                    return 1;
                }
            });
        }
    }

    public void addMetricsGraph(String title, boolean value) {
        this.addMetricsGraph(title, value ? "Yes" : "No");
    }

    public void startMetrics() {
        if (this.metrics != null) {
            this.getLogger().info("Starting Metrics.");
            this.metrics.start();
        }
    }

    public void writeLog(LogInfo info, Cause cause, String causeReason, Account account, double amount, Currency currency, String worldName) {
        if (this.getMainConfig().getBoolean("System.Logging.Enabled")) {
            this.getStorageHandler().getStorageEngine().saveLog(info, cause, causeReason, account, amount, currency, worldName);
        }
    }

    public Updater getVersionChecker() {
        return this.updater;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public WorldGroupsManager getWorldGroupManager() {
        return this.worldGroupManager;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public void loadDefaultSettings() {
        String value = this.getStorageHandler().getStorageEngine().getConfigEntry("longmode");
        if (value != null) {
            this.displayFormat = DisplayFormat.valueOf(value.toUpperCase());
        } else {
            this.getStorageHandler().getStorageEngine().setConfigEntry("longmode", "long");
            this.displayFormat = DisplayFormat.LONG;
        }
        this.addMetricsGraph("Display Format", this.displayFormat.toString());
        value = this.getStorageHandler().getStorageEngine().getConfigEntry("holdings");
        if (value != null && Tools.isValidDouble(value)) {
            this.holdings = Double.parseDouble(value);
        } else {
            this.getStorageHandler().getStorageEngine().setConfigEntry("holdings", "100.0");
            this.sendConsoleMessage(Level.SEVERE, "No default value was set for account creation or was invalid! Defaulting to 100.");
            this.holdings = 100.0;
        }
        value = this.getStorageHandler().getStorageEngine().getConfigEntry("bankprice");
        if (value != null && Tools.isValidDouble(value)) {
            this.bankPrice = Double.parseDouble(value);
        } else {
            this.getStorageHandler().getStorageEngine().setConfigEntry("bankprice", "100.0");
            this.sendConsoleMessage(Level.SEVERE, "No default value was set for bank creation or was invalid! Defaulting to 100.");
            this.bankPrice = 100.0;
        }
    }

    public DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(DisplayFormat format) {
        this.getStorageHandler().getStorageEngine().setConfigEntry("longmode", format.toString());
        this.displayFormat = format;
    }

    public double getDefaultHoldings() {
        return this.holdings;
    }

    public void setDefaultHoldings(double value) {
        this.getStorageHandler().getStorageEngine().setConfigEntry("holdings", String.valueOf(value));
        this.holdings = value;
    }

    public double getBankPrice() {
        return this.bankPrice;
    }

    public void setBankPrice(double value) {
        this.getStorageHandler().getStorageEngine().setConfigEntry("bankprice", String.valueOf(value));
        this.bankPrice = value;
    }

    private void quickSetup() {
        this.initialiseDatabase();
        Common.getInstance().initializeCurrency();
        Currency currency = Common.getInstance().getCurrencyManager().addCurrency(this.getMainConfig().getString("System.QuickSetup.Currency.Name"), this.getMainConfig().getString("System.QuickSetup.Currency.NamePlural"), this.getMainConfig().getString("System.QuickSetup.Currency.Minor"), this.getMainConfig().getString("System.QuickSetup.Currency.MinorPlural"), this.getMainConfig().getString("System.QuickSetup.Currency.Sign"), true);
        Common.getInstance().getCurrencyManager().setDefault(currency);
        Common.getInstance().getCurrencyManager().setDefaultBankCurrency(currency);
        this.getStorageHandler().getStorageEngine().setConfigEntry("longmode", DisplayFormat.valueOf(this.getMainConfig().getString("System.QuickSetup.DisplayMode").toUpperCase()).toString());
        this.getStorageHandler().getStorageEngine().setConfigEntry("holdings", this.getMainConfig().getString("System.QuickSetup.StartBalance"));
        this.getStorageHandler().getStorageEngine().setConfigEntry("bankprice", this.getMainConfig().getString("System.QuickSetup.PriceBank"));
        this.initializeCurrency();
        this.loadDefaultSettings();
        Common.getInstance().startUp();
        Common.getInstance().getMainConfig().setValue("System.Setup", false);
        this.commandManager.setCurrentLevel(1);
        this.sendConsoleMessage(Level.INFO, "Quick-Config done!");
    }

    private void registerCommands() {
        this.commandManager.setWrongLevelMsg(this.languageManager.getString("command_disabled_setup_mode"));
        SubCommand money = new SubCommand("money", this.commandManager, null, 1);
        money.addCommand("", new MainCommand());
        money.addCommand("all", new AllCommand());
        money.addCommand("pay", new PayCommand());
        money.addCommand("give", new GiveCommand());
        money.addCommand("take", new TakeCommand());
        money.addCommand("set", new SetCommand());
        money.addCommand("delete", new DeleteCommand());
        money.addCommand("create", new CreateCommand());
        money.addCommand("balance", new BalanceCommand());
        money.addCommand("top", new TopCommand());
        money.addCommand("exchange", new ExchangeCommand());
        money.addCommand("infinite", new InfiniteCommand());
        money.addCommand("log", new LogCommand());
        this.commandManager.registerMainCommand("money", money);
        SubCommand bank = new SubCommand("bank", this.commandManager, null, 1);
        bank.addCommand("create", new BankCreateCommand());
        bank.addCommand("balance", new BankBalanceCommand());
        bank.addCommand("deposit", new BankDepositCommand());
        bank.addCommand("withdraw", new BankWithdrawCommand());
        bank.addCommand("set", new BankSetCommand());
        bank.addCommand("give", new BankGiveCommand());
        bank.addCommand("take", new BankTakeCommand());
        bank.addCommand("perm", new BankPermCommand());
        bank.addCommand("list", new BankListCommand());
        bank.addCommand("delete", new BankDeleteCommand());
        bank.addCommand("ignoreacl", new BankIgnoreACLCommand());
        this.commandManager.registerMainCommand("bank", bank);
        SubCommand ccsetup = new SubCommand("ccsetup", this.commandManager, null, 0);
        ccsetup.addCommand("", new NewSetupMainCommand());
        ccsetup.addCommand("database", new NewSetupDatabaseCommand());
        ccsetup.addCommand("currency", new NewSetupCurrencyCommand());
        ccsetup.addCommand("basic", new NewSetupBasicCommand());
        ccsetup.addCommand("convert", new NewSetupConvertCommand());
        this.commandManager.registerMainCommand("ccsetup", ccsetup);
        SubCommand currency = new SubCommand("currency", this.commandManager, null, 1);
        currency.addCommand("add", new CurrencyAddCommand());
        currency.addCommand("delete", new CurrencyDeleteCommand());
        currency.addCommand("edit", new CurrencyEditCommand());
        currency.addCommand("info", new CurrencyInfoCommand());
        currency.addCommand("default", new CurrencyDefaultCommand());
        currency.addCommand("exchange", new CurrencyExchangeCommand());
        currency.addCommand("rates", new CurrencyRatesCommand());
        currency.addCommand("list", new CurrencyListCommand());
        this.commandManager.registerMainCommand("currency", currency);
        SubCommand configCommand = new SubCommand("craftconomy", this.commandManager, null, 1);
        configCommand.addCommand("holdings", new ConfigHoldingsCommand());
        configCommand.addCommand("bankprice", new ConfigBankPriceCommand());
        configCommand.addCommand("format", new ConfigFormatCommand());
        configCommand.addCommand("clearlog", new ConfigClearLogCommand());
        configCommand.addCommand("reload", new ConfigReloadCommand());
        this.commandManager.registerMainCommand("craftconomy", configCommand);
        SubCommand ccgroup = new SubCommand("ccgroup", this.commandManager, null, 1);
        ccgroup.addCommand("create", new GroupCreateCommand());
        ccgroup.addCommand("addworld", new GroupAddWorldCommand());
        ccgroup.addCommand("delworld", new GroupDelWorldCommand());
        this.commandManager.registerMainCommand("ccgroup", ccgroup);
        SubCommand payCommand = new SubCommand("pay", this.commandManager, null, 1);
        payCommand.addCommand("", new PayCommand());
        this.commandManager.registerMainCommand("pay", payCommand);
    }

    private void loadLanguage() {
        this.languageManager.addLanguageEntry("metric_start_error", "Unable to load Metrics! The error is: %s");
        this.languageManager.addLanguageEntry("checking_new_version", "Checking if there's a new version.");
        this.languageManager.addLanguageEntry("running_old_version", "Running a old version of Craftconomy! New version is: %s");
        this.languageManager.addLanguageEntry("database_connect_error", "A error occured while trying to connect to the database. Message received: %s");
        this.languageManager.addLanguageEntry("loading_default_settings", "Loading default settings.");
        this.languageManager.addLanguageEntry("default_settings_loaded", "Default settings loaded!");
        this.languageManager.addLanguageEntry("loaded_setup_mode", "Loading Craftconomy in setup mode. Please type /ccsetup to start the setup.");
        this.languageManager.addLanguageEntry("ready", "Ready!");
        this.languageManager.addLanguageEntry("closing_db_link", "Closing the connection to the database.");
        this.languageManager.addLanguageEntry("unable_close_db_link", "Unable to close the database connection! Reason is: %s");
        this.languageManager.addLanguageEntry("loading_database_manager", "Loading the Database Manager");
        this.languageManager.addLanguageEntry("database_manager_loaded", "Database Manager Loaded!");
        this.languageManager.addLanguageEntry("loading_curency_manager", "Loading the Currency Manager");
        this.languageManager.addLanguageEntry("currency_manager_loaded", "Currency Manager Loaded!");
        this.languageManager.addLanguageEntry("loading_account_manager", "Loading the Account Manager");
        this.languageManager.addLanguageEntry("account_manager_loaded", "Account Manager Loaded!");
        this.languageManager.addLanguageEntry("loading_payday_manager", "Loading the PayDay manager.");
        this.languageManager.addLanguageEntry("payday_manager_loaded", "PayDay Manager loaded!");
        this.languageManager.addLanguageEntry("error_write_log", "Error while writing the transaction logger! Error is: %s");
        this.languageManager.addLanguageEntry("invalid_library", "Invalid library URL for: %s. Full error is: %s");
        this.languageManager.addLanguageEntry("command_disabled_setup_mode", "{{DARK_RED}}This command is disabled while Craftconomy is under setup mode! Type /ccsetup to configure the plugin.");
        this.languageManager.addLanguageEntry("user_only_command", "{{DARK_RED}}This command should only be used by players!");
        this.languageManager.addLanguageEntry("no_permission", "{{DARK_RED}}You don't have permissions!");
        this.languageManager.addLanguageEntry("command_usage", "Usage: %s");
        this.languageManager.addLanguageEntry("subcommand_not_exist", "{{DARK_RED}}This subcommand doesn't exist!");
        this.languageManager.addLanguageEntry("bank_statement", "{{DARK_GREEN}}Bank Statement:");
        this.languageManager.addLanguageEntry("cant_check_bank_statement", "{{DARK_RED}}You can't check this bank account statement");
        this.languageManager.addLanguageEntry("account_not_exist", "{{DARK_RED}}This account doesn't exist!");
        this.languageManager.addLanguageEntry("bank_account_created", "{{DARK_GREEN}}The account has been created!");
        this.languageManager.addLanguageEntry("bank_account_not_enough_money_create", "{{DARK_RED}}You don't have enough money to create a bank account! You need {{WHITE}}%s");
        this.languageManager.addLanguageEntry("account_already_exists", "{{DARK_RED}}This account already exists!");
        this.languageManager.addLanguageEntry("currency_not_exist", "{{DARK_RED}}That currency doesn't exist!");
        this.languageManager.addLanguageEntry("not_enough_money", "{{DARK_RED}}Not enough money!");
        this.languageManager.addLanguageEntry("invalid_amount", "{{DARK_RED}}Invalid amount!");
        this.languageManager.addLanguageEntry("bank_cant_deposit", "{{DARK_RED}}You can't deposit in this account!");
        this.languageManager.addLanguageEntry("deposited", "{{DARK_GREEN}}Deposited {{WHITE}}%s {{DARK_GREEN}}in the {{WHITE}}%s {{DARK_GREEN}}bank Account.");
        this.languageManager.addLanguageEntry("bank_help_title", "{{DARK_GREEN}} ======== Bank Commands ========");
        this.languageManager.addLanguageEntry("bank_create_cmd_help", "/bank create <Account Name> - Create a bank account");
        this.languageManager.addLanguageEntry("bank_balance_cmd_help", "/bank balance <Account Name> - Check the balance of a account.");
        this.languageManager.addLanguageEntry("bank_deposit_cmd_help", "/bank deposit <Account Name> <Amount> [Currency] - Deposit money in a bank account.");
        this.languageManager.addLanguageEntry("bank_give_cmd_help", "/bank give <Account Name> <Amount> [Currency] [World] - Give money in a bank account.");
        this.languageManager.addLanguageEntry("bank_help_cmd_help", "/bank - Shows bank help");
        this.languageManager.addLanguageEntry("bank_perm_cmd_help", "/bank perm <Account Name> <deposit/withdraw/acl/show> <Player Name> <true/false> - Modify the permission of a player");
        this.languageManager.addLanguageEntry("bank_set_cmd_help", "/bank set <Account Name> <Amount> [Currency] [World]- Set a balance in a account.");
        this.languageManager.addLanguageEntry("bank_take_cmd_help", "/bank take <Account Name> <Amount> [Currency] [World]- Take money from a account.");
        this.languageManager.addLanguageEntry("bank_withdraw_cmd_help", "/bank withdraw <Account Name> <Amount> [Currency] - Withdraw money in a account.");
        this.languageManager.addLanguageEntry("world_not_exist", "{{DARK_RED}}This world doesn't exist!");
        this.languageManager.addLanguageEntry("bank_give_success", "{{DARK_GREEN}}Deposited {{WHITE}}%s{{DARK_GREEN}} from the {{WHITE}}%s{{DARK_GREEN}} bank Account.");
        this.languageManager.addLanguageEntry("invalid_flag", "{{DARK_RED}}Invalid flag!");
        this.languageManager.addLanguageEntry("bank_flag_set", "{{DARK_GREEN}}The flag {{WHITE}}%s {{DARK_GREEN}}for the player {{WHITE}}%s {{DARK_GREEN}}has been set to {{WHITE}}%s");
        this.languageManager.addLanguageEntry("cant_modify_acl", "{{DARK_RED}}You can't modify the ACL of this account!");
        this.languageManager.addLanguageEntry("bank_set_success", "{{DARK_GREEN}}Set {{WHITE}}%s {{DARK_GREEN}}in the {{WHITE}}%s {{DARK_GREEN}}bank Account.");
        this.languageManager.addLanguageEntry("bank_not_enough_money", "{{DARK_RED}}The bank account doesn't have enough money!");
        this.languageManager.addLanguageEntry("bank_take_success", "{{DARK_GREEN}}Taken {{WHITE}}%s {{DARK_GREEN}}from the {{WHITE}}%s {{DARK_GREEN}}bank Account.");
        this.languageManager.addLanguageEntry("cant_withdraw_bank", "{{DARK_RED}}You can't withdraw in this account!");
        this.languageManager.addLanguageEntry("bank_price_modified", "{{DARK_GREEN}}Bank price modified!");
        this.languageManager.addLanguageEntry("config_bankprice_cmd_help", "/craftconomy bankprice <Amount> - Change the price to create a bank account.");
        this.languageManager.addLanguageEntry("config_format_cmd_help", "/craftconomy format <long/small/sign/signfront/majoronly> - Set the display format.");
        this.languageManager.addLanguageEntry("config_cmd_help", "/craftconomy - shows config command help");
        this.languageManager.addLanguageEntry("config_holdings_cmd_help", "/craftconomy holdings <Amount> - Set the default amount of money of a user account.");
        this.languageManager.addLanguageEntry("config_help_title", "{{DARK_GREEN}} ======== Craftconomy Commands ========");
        this.languageManager.addLanguageEntry("format_modified", "{{DARK_GREEN}}long balance format changed!");
        this.languageManager.addLanguageEntry("invalid_mode", "{{DARK_RED}}Invalid mode!");
        this.languageManager.addLanguageEntry("default_holding_modified", "{{DARK_GREEN}}Default holdings modified!");
        this.languageManager.addLanguageEntry("currency_added", "{{DARK_GREEN}}Currency added!");
        this.languageManager.addLanguageEntry("currency_already_exists", "{{DARK_RED}}This currency already exists!");
        this.languageManager.addLanguageEntry("currency_add_cmd_help", "/currency add <Name> <Name Plural> <Minor> <Minor Plural> <Sign> - Add a currency.");
        this.languageManager.addLanguageEntry("currency_default_cmd_help", "/currency default <Name> - Set a currency as the default one.");
        this.languageManager.addLanguageEntry("currency_delete_cmd_help", "/currency delete <Name> - Delete a currency {{DARK_RED}}It also deletes all balance with this currency.");
        this.languageManager.addLanguageEntry("currency_edit_cmd_help", "/currency edit <name/nameplural/minor/minorplural/sign> <Currency Name> <new Value> - Modify a currency.");
        this.languageManager.addLanguageEntry("currency_help_cmd_help", "/currency - shows currency command help");
        this.languageManager.addLanguageEntry("currency_info_cmd_help", "/currency info <Name> - Display the information about a currency.");
        this.languageManager.addLanguageEntry("default_currency_set", "%s {{DARK_GREEN}}has been set as the default currency!");
        this.languageManager.addLanguageEntry("currency_deleted", "{{DARK_GREEN}}Currency deleted!");
        this.languageManager.addLanguageEntry("currency_modified", "{{DARK_GREEN}}Currency modified!");
        this.languageManager.addLanguageEntry("invalid_type", "{{DARK_RED}}Invalid type!");
        this.languageManager.addLanguageEntry("currency_empty_value", "{{DARK_RED}}Can't change a currency value to empty (Aka \\)");
        this.languageManager.addLanguageEntry("currency_help_title", "{{DARK_GREEN}} ======== Currency Commands ========");
        this.languageManager.addLanguageEntry("currency_info_name", "{{DARK_GREEN}}Name: {{WHITE}}%s");
        this.languageManager.addLanguageEntry("currency_info_name_plural", "{{DARK_GREEN}}Name Plural: {{WHITE}}%s");
        this.languageManager.addLanguageEntry("currency_info_minor", "{{DARK_GREEN}}Minor: {{WHITE}}%s");
        this.languageManager.addLanguageEntry("currency_info_minor_plural", "{{DARK_GREEN}}Minor plural: {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_all_title", "{{DARK_GREEN}}Balance: ");
        this.languageManager.addLanguageEntry("money_all_cmd_help", "/money all - Display your balance on all the worlds");
        this.languageManager.addLanguageEntry("money_balance_cmd_help", "/money balance <Player Name> - Display the balance of a player");
        this.languageManager.addLanguageEntry("money_create_cmd_help", "/money create <Name> - Create a account");
        this.languageManager.addLanguageEntry("money_delete_cmd_help", "/money delete <Name> - Delete a account");
        this.languageManager.addLanguageEntry("money_give_cmd_help", "/money give <Player Name> <Amount> [Currency] [World] - Give money to someone");
        this.languageManager.addLanguageEntry("money_main_cmd_help", "/money  - List your balance");
        this.languageManager.addLanguageEntry("money_help_cmd_help", "/money help - Shows money help");
        this.languageManager.addLanguageEntry("money_pay_cmd_help", "/money pay <Player Name> <Amount> [Currency] - Send money to someone");
        this.languageManager.addLanguageEntry("money_set_cmd_help", "/money set <Player Name> <Amount> [Currency] [World] - set a balance of someone");
        this.languageManager.addLanguageEntry("money_take_cmd_help", "/money take <Player Name> <Amount> [Currency] [World] - take money from someone");
        this.languageManager.addLanguageEntry("money_top_cmd_help", "/money top <Currency> [Page] [World] - Shows the top list");
        this.languageManager.addLanguageEntry("money_create_success", "{{DARK_GREEN}} Account created!");
        this.languageManager.addLanguageEntry("money_delete_success", "{{DARK_GREEN}}The account {{WHITE}}%s {{DARK_GREEN}}has been deleted!");
        this.languageManager.addLanguageEntry("money_give_received", "{{DARK_GREEN}}Received {{WHITE}}%s {{DARK_GREEN}}from {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_give_send", "{{DARK_GREEN}}Gave {{WHITE}}%s {{DARK_GREEN}}to {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_help_title", "{{DARK_GREEN}} ======== Money Commands ========");
        this.languageManager.addLanguageEntry("money_pay_sent", "{{DARK_GREEN}}Sent {{WHITE}}%s {{DARK_GREEN}}to {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_pay_received", "{{DARK_GREEN}}Received {{WHITE}}%s {{DARK_GREEN}}from {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_set", "{{DARK_GREEN}}Set {{WHITE}}%s {{DARK_GREEN}}balance to {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_set_other", "{{DARK_GREEN}}Your money has been set to {{WHITE}}%s {{DARK_GREEN}}by {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_take", "{{DARK_GREEN}}Took {{WHITE}}%s {{DARK_GREEN}}from {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_take_other", "{{WHITE}}%s {{DARK_GREEN}}has been removed from your account by {{WHITE}}%s");
        this.languageManager.addLanguageEntry("player_not_exist", "{{DARK_RED}}The player doesn't exist!");
        this.languageManager.addLanguageEntry("invalid_page", "{{DARK_RED}}Invalid page!");
        this.languageManager.addLanguageEntry("money_top_header", "{{DARK_GREEN}} Money Top | Page {{WHITE}}%s {{DARK_GREEN}} | World {{WHITE}}%s");
        this.languageManager.addLanguageEntry("payday_create_cmd_help", "/payday create <Name> <Interval> <wage/tax> <Amount> [Account] [Currency Name] [World Name] - Create a new payday");
        this.languageManager.addLanguageEntry("payday_delete_cmd_help", "/payday delete <Name> - Delete a PayDay.");
        this.languageManager.addLanguageEntry("payday_help_cmd_help", "/payday - shows payday command help");
        this.languageManager.addLanguageEntry("payday_info_cmd_help", "/payday info <Payday Name> - Show information about a payday.");
        this.languageManager.addLanguageEntry("payday_list_cmd_help", "/payday list - List all payday");
        this.languageManager.addLanguageEntry("payday_modify_cmd_help", "/payday modify <Name> <Name/status/disabled/interval/amount/account/currency/World> <Value> - Modify a payday setting.");
        this.languageManager.addLanguageEntry("payday_help_title", "{{DARK_GREEN}} ======== PayDay Commands ========");
        this.languageManager.addLanguageEntry("payday_already_exist", "{{DARK_RED}}There's already a payday named like that!");
        this.languageManager.addLanguageEntry("invalid_interval", "{{DARK_RED}}Invalid interval!");
        this.languageManager.addLanguageEntry("payday_invalid_mode", "{{DARK_RED}}Invalid mode. only wage or tax is supported!");
        this.languageManager.addLanguageEntry("payday_create_success", "{{DARK_GREEN}}Payday added! Add the permission node {{WHITE}}%s {{DARK_GREEN}}to the players you want to add this payday!");
        this.languageManager.addLanguageEntry("payday_not_found", "{{DARK_RED}}PayDay not found!");
        this.languageManager.addLanguageEntry("error_occured", "{{DARK_GREEN}}A error occured. Check the console for any errors!");
        this.languageManager.addLanguageEntry("payday_removed", "{{DARK_GREEN}}Payday removed!");
        this.languageManager.addLanguageEntry("payday_info_title", "{{DARK_GREEN}} ======== {{WHITE}}%s information {{DARK_GREEN}}========");
        this.languageManager.addLanguageEntry("payday_info_type_wage", "{{DARK_GREEN}}Type: {{WHITE}}Wage");
        this.languageManager.addLanguageEntry("payday_info_type_tax", "{{DARK_GREEN}}Type: {{WHITE}}Tax");
        this.languageManager.addLanguageEntry("payday_info_account", "{{DARK_GREEN}}Account: {{WHITE}}%s");
        this.languageManager.addLanguageEntry("payday_info_interval", "{{DARK_GREEN}}Interval: {{WHITE}}%s");
        this.languageManager.addLanguageEntry("payday_info_amount", "{{DARK_GREEN}}Amount: {{WHITE}}%s");
        this.languageManager.addLanguageEntry("payday_list_title", "{{DARK_GREEN}} ========= {{WHITE}}Payday list {{DARK_GREEN}}=========");
        this.languageManager.addLanguageEntry("invalid_edit_mode", "{{DARK_RED}}Invalid Edit mode.");
        this.languageManager.addLanguageEntry("world_changed", "{{DARK_GREEN}}World changed!");
        this.languageManager.addLanguageEntry("currency_changed", "{{DARK_GREEN}}Currency changed!");
        this.languageManager.addLanguageEntry("account_changed", "{{DARK_GREEN}}Account changed!");
        this.languageManager.addLanguageEntry("amount_changed", "{{DARK_GREEN}}Amount changed!");
        this.languageManager.addLanguageEntry("interval_changed", "{{DARK_GREEN}}Interval changed!");
        this.languageManager.addLanguageEntry("disabled_changed", "{{DARK_GREEN}}Disabled changed!");
        this.languageManager.addLanguageEntry("status_changed", "{{DARK_GREEN}}Status changed!");
        this.languageManager.addLanguageEntry("name_changed", "{{DARK_GREEN}}Name changed!");
        this.languageManager.addLanguageEntry("invalid_interval", "{{DARK_RED}}Invalid interval! I need a amount of seconds! (Example: 60 for 60 seconds)");
        this.languageManager.addLanguageEntry("invalid_disabled", "{{DARK_RED}}Invalid disabled mode! Valid values are: true/false");
        this.languageManager.addLanguageEntry("invalid_status", "{{DARK_RED}}Invalid status! Valid values are: wage/tax");
        this.languageManager.addLanguageEntry("payday_with_name_already_exist", "{{DARK_RED}}There's already a payday with this name!");
        this.languageManager.addLanguageEntry("money_exchange_cmd_help", "/money exchange <Current Currency> <New Currency> <Amount> -Exchange a currency");
        this.languageManager.addLanguageEntry("no_exchange_rate", "{{DARK_RED}}No exchange rate from {{WHITE}}%s {{DARK_RED}}to {{WHITE}}%s!");
        this.languageManager.addLanguageEntry("exchange_done", "{{WHITE}}%s %s {{DARK_GREEN}}has been converted to {{WHITE}}%s %s");
        this.languageManager.addLanguageEntry("currency_exchange_cmd_help", "/currency exchange <Currency from> <Currency to> <amount> - set a currency exchange rate");
        this.languageManager.addLanguageEntry("currency_exchange_set", "Currency exchange set!");
        this.languageManager.addLanguageEntry("world_group_manager_loaded", "World Group Manager loaded!");
        this.languageManager.addLanguageEntry("group_create_cmd_help", "/ccgroup create <Name> - Create a world group.");
        this.languageManager.addLanguageEntry("group_addworld_cmd_help", "/ccgroup addworld <Group Name> <World Name> - Add a world to a world group.");
        this.languageManager.addLanguageEntry("group_already_exist", "{{DARK_RED}}This world group already exist!");
        this.languageManager.addLanguageEntry("group_created", "World group created!");
        this.languageManager.addLanguageEntry("group_not_exist", "{{DARK_RED}}This world group doesn't exist!");
        this.languageManager.addLanguageEntry("group_world_added", "World added to the group!");
        this.languageManager.addLanguageEntry("world_already_in_group", "{{DARK_RED}}This world is already in a group! Please remove it with {{WHITE}}/ccgroup delworld %s");
        this.languageManager.addLanguageEntry("group_delworld_cmd_help", "/ccgroup delworld <World Name> - Remove a world from his group. Reverting it to the default group.");
        this.languageManager.addLanguageEntry("world_not_in_group", "{{DARK_RED}}This world isin't in a group!");
        this.languageManager.addLanguageEntry("world_removed_from_group", "The world has been removed from the group! It has been set to the default group.");
        this.languageManager.addLanguageEntry("loading_currency_manager", "Loading the Currency manager.");
        this.languageManager.addLanguageEntry("command_prefix", "{{DARK_GREEN}}[{{WHITE}}Money{{DARK_GREEN}}]{{WHITE}} ");
        this.languageManager.addLanguageEntry("group_help_title", "{{DARK_GREEN}} ======== Group Commands ========");
        this.languageManager.addLanguageEntry("group_help_cmd_help", "/ccgroup - Shows ccgroup help.");
        this.languageManager.addLanguageEntry("money_infinite_cmd_help", "/money infinite <Account Name> - Put a account in infinite money mode.");
        this.languageManager.addLanguageEntry("money_infinite_set_false", "The account is no more infinite!");
        this.languageManager.addLanguageEntry("money_infinite_set_true", "The account is now infinite!");
        this.languageManager.addLanguageEntry("money_log_header", "{{DARK_GREEN}} Money Log | Page {{WHITE}}%s {{DARK_GREEN}} | Account {{WHITE}}%s");
        this.languageManager.addLanguageEntry("money_log_cmd_help", "/money log <page> [Account Name] - Show the account log");
        this.languageManager.addLanguageEntry("bank_list_cmd_help", "/bank list - List all the bank accounts you have access");
        this.languageManager.addLanguageEntry("bank_account_list", "List of bank accounts: %s");
        this.languageManager.addLanguageEntry("currency_rates_cmd_help", "/currency rates - Show all the exchange rates available.");
        this.languageManager.addLanguageEntry("rates_header", "{{DARK_GREEN}}[Currency rates]");
        this.languageManager.addLanguageEntry("bank_delete_cmd_help", "/bank delete <Name> - Delete a bank account that you own.");
        this.languageManager.addLanguageEntry("bank_delete_not_owner", "{{DARK_RED}}You aren't this bank owner!");
        this.languageManager.addLanguageEntry("bank_account_deleted", "Bank account deleted");
        this.languageManager.addLanguageEntry("currency_list_cmd_help", "/currency list - List all the currencies");
        this.languageManager.addLanguageEntry("currency_list_title", "{{DARK_GREEN}}====== {{WHITE}}Currencies {{DARK_GREEN}}======");
        this.languageManager.addLanguageEntry("invalid_time_log", "Invalid time! It needs to be a positive number!");
        this.languageManager.addLanguageEntry("log_cleared", "The log table has been cleared up to the time you said!");
        this.languageManager.addLanguageEntry("craftconomy_clearlog_cmd_help", "/craftconomy clearlog <Time in days> - Clear the log table from entries olders than the value provided");
        this.languageManager.addLanguageEntry("bank_ignoreacl_cmd_help", "/bank ignoreacl <Account Name>  - Ignore the ACL system for that account.");
        this.languageManager.addLanguageEntry("account_is_ignoring_acl", "The account is now ignoring the ACL!");
        this.languageManager.addLanguageEntry("account_is_not_ignoring_acl", "The account is now following the ACL!");
        this.languageManager.addLanguageEntry("starting_database_convert", "Starting database convertion to MySQL. This can take come time.");
        this.languageManager.addLanguageEntry("convert_save_account", "Converting accounts... (1/9)");
        this.languageManager.addLanguageEntry("convert_save_balance", "Converting balances... (2/9)");
        this.languageManager.addLanguageEntry("convert_save_access", "Converting bank access... (3/9)");
        this.languageManager.addLanguageEntry("convert_save_currency", "Converting currencies... (4/9)");
        this.languageManager.addLanguageEntry("convert_save_config", "Converting config... (5/9)");
        this.languageManager.addLanguageEntry("convert_save_payday", "Converting payday... (6/9)");
        this.languageManager.addLanguageEntry("convert_save_exchange", "Converting exchange... (7/9)");
        this.languageManager.addLanguageEntry("convert_save_worldgroup", "Converting worldgroups... (8/9)");
        this.languageManager.addLanguageEntry("convert_save_log", "Converting logs... (9/9)");
        this.languageManager.addLanguageEntry("convert_done", "Conversion done!");
        this.languageManager.addLanguageEntry("config_reload_help_cmd", "/craftconomy reload - Reload craftconomy.");
        this.languageManager.addLanguageEntry("craftconomy_reloaded", "Craftconomy has been reloaded!");
    }

    private void initializeConfig() {
        this.mainConfig.setValue("System.Setup", true);
        this.mainConfig.setValue("System.QuickSetup.Enable", false);
        this.mainConfig.setValue("System.QuickSetup.Currency.Name", "Dollar");
        this.mainConfig.setValue("System.QuickSetup.Currency.NamePlural", "Dollars");
        this.mainConfig.setValue("System.QuickSetup.Currency.Minor", "Coin");
        this.mainConfig.setValue("System.QuickSetup.Currency.MinorPlural", "Coins");
        this.mainConfig.setValue("System.QuickSetup.Currency.Sign", "$");
        this.mainConfig.setValue("System.QuickSetup.StartBalance", 100.0);
        this.mainConfig.setValue("System.QuickSetup.PriceBank", 200.0);
        this.mainConfig.setValue("System.QuickSetup.DisplayMode", "long");
        this.mainConfig.setValue("System.CheckNewVersion", true);
        this.mainConfig.setValue("System.Case-sentitive", false);
        this.mainConfig.setValue("System.CreateOnLogin", false);
        this.mainConfig.setValue("System.Logging.Enabled", false);
        this.mainConfig.setValue("System.Database.Type", "h2");
        this.mainConfig.setValue("System.Database.Address", "localhost");
        this.mainConfig.setValue("System.Database.Port", 3306);
        this.mainConfig.setValue("System.Database.Username", "root");
        this.mainConfig.setValue("System.Database.Password", "");
        this.mainConfig.setValue("System.Database.Db", "craftconomy");
        this.mainConfig.setValue("System.Database.Prefix", "cc3_");
        this.mainConfig.setValue("System.Database.Poolsize", 10);
        this.mainConfig.setValue("System.Database.ConvertFromH2", false);
    }

    private void updateDatabase() {
        if (this.getMainConfig().getInt("Database.dbVersion") == 0) {
            this.alertOldDbVersion(0, 1);
            String value = this.getStorageHandler().getStorageEngine().getConfigEntry("dbVersion");
            if (value != null) {
                try {
                    new OldFormatConverter().run();
                    this.getMainConfig().setValue("Database.dbVersion", 1);
                    this.sendConsoleMessage(Level.INFO, "Updated to Revision 1!");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                this.getMainConfig().setValue("Database.dbVersion", 1);
                this.sendConsoleMessage(Level.INFO, "Updated to Revision 1!");
            }
        } else if (this.getMainConfig().getInt("Database.dbVersion") == -1) {
            this.alertOldDbVersion(-1, 1);
            try {
                new OldFormatConverter().step2();
                this.getMainConfig().setValue("Database.dbVersion", 1);
                this.sendConsoleMessage(Level.INFO, "Updated to Revision 1!");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void alertOldDbVersion(int currentVersion, int newVersion) {
        Common.getInstance().sendConsoleMessage(Level.INFO, "Your database is out of date! (Version " + currentVersion + "). Updating it to Revision " + newVersion + ".");
    }

    private void addFeatherboardSupport() {
        if (this.getServerCaller() instanceof BukkitServerCaller && this.getServerCaller().isPluginEnabled("MVdWPlaceholderAPI")) {
            FeatherBoard.registerPlaceHolder(this.getServerCaller().getLoader(), "cc3money", new FeatherBoard.FeatherBoardReplaceEvent(){

                @Override
                public String getResult(String username, boolean isOnline) {
                    if (Common.this.getAccountManager().exist(username, false)) {
                        return Common.this.format(null, Common.this.getCurrencyManager().getDefaultCurrency(), Common.this.getAccountManager().getAccount(username, false).getBalance("default", Common.this.getCurrencyManager().getDefaultCurrency().getName()), Common.this.getDisplayFormat());
                    }
                    return "";
                }
            });
        }
    }
}

