/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.libs.hikari.pool;

import com.greatmancode.com.zaxxer.libs.hikari.pool.PoolEntry;
import com.greatmancode.libs.org.slf4j.Logger;
import com.greatmancode.libs.org.slf4j.LoggerFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class ProxyLeakTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyLeakTask.class);
    private static final ProxyLeakTask NO_LEAK = new ProxyLeakTask(){

        @Override
        public void cancel() {
        }
    };
    private ScheduledExecutorService executorService;
    private long leakDetectionThreshold;
    private ScheduledFuture<?> scheduledFuture;
    private String connectionName;
    private Exception exception;

    ProxyLeakTask(long leakDetectionThreshold, ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    private ProxyLeakTask(ProxyLeakTask parent, PoolEntry poolEntry) {
        this.exception = new Exception("Apparent connection leak detected");
        this.connectionName = poolEntry.connection.toString();
        this.scheduledFuture = parent.executorService.schedule(this, parent.leakDetectionThreshold, TimeUnit.MILLISECONDS);
    }

    private ProxyLeakTask() {
    }

    ProxyLeakTask start(PoolEntry bagEntry) {
        return this.leakDetectionThreshold == 0L ? NO_LEAK : new ProxyLeakTask(this, bagEntry);
    }

    void updateLeakDetectionThreshold(long leakDetectionThreshold) {
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    @Override
    public void run() {
        StackTraceElement[] stackTrace = this.exception.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[stackTrace.length - 5];
        System.arraycopy(stackTrace, 5, trace, 0, trace.length);
        this.exception.setStackTrace(trace);
        LOGGER.warn("Connection leak detection triggered for connection {}, stack trace follows", (Object)this.connectionName, (Object)this.exception);
    }

    void cancel() {
        this.scheduledFuture.cancel(false);
    }
}

