/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.libs.hikari.pool;

import com.greatmancode.com.zaxxer.libs.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.libs.hikari.metrics.MetricsTracker;
import com.greatmancode.com.zaxxer.libs.hikari.pool.HikariPool;
import com.greatmancode.com.zaxxer.libs.hikari.pool.PoolEntry;
import com.greatmancode.com.zaxxer.libs.hikari.pool.ProxyConnection;
import com.greatmancode.com.zaxxer.libs.hikari.util.ClockSource;
import com.greatmancode.com.zaxxer.libs.hikari.util.DefaultThreadFactory;
import com.greatmancode.com.zaxxer.libs.hikari.util.DriverDataSource;
import com.greatmancode.com.zaxxer.libs.hikari.util.PropertyElf;
import com.greatmancode.com.zaxxer.libs.hikari.util.UtilityElf;
import com.greatmancode.libs.org.slf4j.Logger;
import com.greatmancode.libs.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;

abstract class PoolBase {
    private final Logger LOGGER = LoggerFactory.getLogger(PoolBase.class);
    protected final HikariConfig config;
    protected final String poolName;
    protected long connectionTimeout;
    private static final String[] RESET_STATES = new String[]{"readOnly", "autoCommit", "isolation", "catalog", "netTimeout"};
    private static final int UNINITIALIZED = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private int networkTimeout;
    private int transactionIsolation;
    private int isNetworkTimeoutSupported;
    private int isQueryTimeoutSupported;
    private Executor netTimeoutExecutor;
    private DataSource dataSource;
    private final String catalog;
    private final boolean isReadOnly;
    private final boolean isAutoCommit;
    private final boolean isUseJdbc4Validation;
    private final boolean isIsolateInternalQueries;
    private final AtomicReference<Throwable> lastConnectionFailure;
    private volatile boolean isValidChecked;

    PoolBase(HikariConfig config) {
        this.config = config;
        this.networkTimeout = -1;
        this.catalog = config.getCatalog();
        this.isReadOnly = config.isReadOnly();
        this.isAutoCommit = config.isAutoCommit();
        this.transactionIsolation = UtilityElf.getTransactionIsolation(config.getTransactionIsolation());
        this.isQueryTimeoutSupported = -1;
        this.isNetworkTimeoutSupported = -1;
        this.isUseJdbc4Validation = config.getConnectionTestQuery() == null;
        this.isIsolateInternalQueries = config.isIsolateInternalQueries();
        this.poolName = config.getPoolName();
        this.connectionTimeout = config.getConnectionTimeout();
        this.lastConnectionFailure = new AtomicReference();
        this.initializeDataSource();
    }

    public String toString() {
        return this.poolName;
    }

    abstract void releaseConnection(PoolEntry var1);

    void quietlyCloseConnection(Connection connection, String closureReason) {
        if (connection == null) {
            return;
        }
        try {
            this.LOGGER.debug("{} - Closing connection {}: {}", this.poolName, connection, closureReason);
            try {
                this.setNetworkTimeout(connection, TimeUnit.SECONDS.toMillis(15L));
            }
            finally {
                connection.close();
            }
        }
        catch (Throwable e) {
            this.LOGGER.debug("{} - Closing connection {} failed", this.poolName, connection, e);
        }
    }

    boolean isConnectionAlive(Connection connection) {
        try {
            long validationTimeout = this.config.getValidationTimeout();
            if (this.isUseJdbc4Validation) {
                return connection.isValid((int)TimeUnit.MILLISECONDS.toSeconds(validationTimeout));
            }
            int originalTimeout = this.getAndSetNetworkTimeout(connection, validationTimeout);
            try (Statement statement = connection.createStatement();){
                if (this.isNetworkTimeoutSupported != 1) {
                    this.setQueryTimeout(statement, (int)TimeUnit.MILLISECONDS.toSeconds(validationTimeout));
                }
                statement.execute(this.config.getConnectionTestQuery());
            }
            if (this.isIsolateInternalQueries && !this.isReadOnly && !this.isAutoCommit) {
                connection.rollback();
            }
            this.setNetworkTimeout(connection, originalTimeout);
            return true;
        }
        catch (SQLException e) {
            this.lastConnectionFailure.set(e);
            this.LOGGER.warn("{} - Connection {} failed alive test with exception {}", this.poolName, connection, e.getMessage());
            return false;
        }
    }

    Throwable getLastConnectionFailure() {
        return this.lastConnectionFailure.getAndSet(null);
    }

    public DataSource getUnwrappedDataSource() {
        return this.dataSource;
    }

    PoolEntry newPoolEntry() throws Exception {
        return new PoolEntry(this.newConnection(), this, this.isReadOnly, this.isAutoCommit);
    }

    void resetConnectionState(Connection connection, ProxyConnection proxyConnection, int dirtyBits) throws SQLException {
        int resetBits = 0;
        if ((dirtyBits & 1) != 0 && proxyConnection.getReadOnlyState() != this.isReadOnly) {
            connection.setReadOnly(this.isReadOnly);
            resetBits |= 1;
        }
        if ((dirtyBits & 2) != 0 && proxyConnection.getAutoCommitState() != this.isAutoCommit) {
            connection.setAutoCommit(this.isAutoCommit);
            resetBits |= 2;
        }
        if ((dirtyBits & 4) != 0 && proxyConnection.getTransactionIsolationState() != this.transactionIsolation) {
            connection.setTransactionIsolation(this.transactionIsolation);
            resetBits |= 4;
        }
        if ((dirtyBits & 8) != 0 && this.catalog != null && !this.catalog.equals(proxyConnection.getCatalogState())) {
            connection.setCatalog(this.catalog);
            resetBits |= 8;
        }
        if ((dirtyBits & 0x10) != 0 && proxyConnection.getNetworkTimeoutState() != this.networkTimeout) {
            this.setNetworkTimeout(connection, this.networkTimeout);
            resetBits |= 0x10;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("{} - Reset ({}) on connection {}", this.poolName, resetBits != 0 ? this.stringFromResetBits(resetBits) : "nothing", connection);
        }
    }

    void shutdownNetworkTimeoutExecutor() {
        if (this.netTimeoutExecutor != null && this.netTimeoutExecutor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.netTimeoutExecutor).shutdownNow();
        }
    }

    void registerMBeans(HikariPool hikariPool) {
        if (!this.config.isRegisterMbeans()) {
            return;
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanConfigName = new ObjectName("com.greatmancode.com.zaxxer.libs.hikari:type=PoolConfig (" + this.poolName + ")");
            ObjectName beanPoolName = new ObjectName("com.greatmancode.com.zaxxer.libs.hikari:type=Pool (" + this.poolName + ")");
            if (!mBeanServer.isRegistered(beanConfigName)) {
                mBeanServer.registerMBean(this.config, beanConfigName);
                mBeanServer.registerMBean(hikariPool, beanPoolName);
            } else {
                this.LOGGER.error("{} - You cannot use the same pool name for separate pool instances.", (Object)this.poolName);
            }
        }
        catch (Exception e) {
            this.LOGGER.warn("{} - Unable to register management beans.", (Object)this.poolName, (Object)e);
        }
    }

    void unregisterMBeans() {
        if (!this.config.isRegisterMbeans()) {
            return;
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName beanConfigName = new ObjectName("com.greatmancode.com.zaxxer.libs.hikari:type=PoolConfig (" + this.poolName + ")");
            ObjectName beanPoolName = new ObjectName("com.greatmancode.com.zaxxer.libs.hikari:type=Pool (" + this.poolName + ")");
            if (mBeanServer.isRegistered(beanConfigName)) {
                mBeanServer.unregisterMBean(beanConfigName);
                mBeanServer.unregisterMBean(beanPoolName);
            }
        }
        catch (Exception e) {
            this.LOGGER.warn("{} - Unable to unregister management beans.", (Object)this.poolName, (Object)e);
        }
    }

    private void initializeDataSource() {
        String jdbcUrl = this.config.getJdbcUrl();
        String username = this.config.getUsername();
        String password = this.config.getPassword();
        String dsClassName = this.config.getDataSourceClassName();
        String driverClassName = this.config.getDriverClassName();
        Properties dataSourceProperties = this.config.getDataSourceProperties();
        DataSource dataSource = this.config.getDataSource();
        if (dsClassName != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(dsClassName, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, dataSourceProperties);
        } else if (jdbcUrl != null && dataSource == null) {
            dataSource = new DriverDataSource(jdbcUrl, driverClassName, dataSourceProperties, username, password);
        }
        if (dataSource != null) {
            this.setLoginTimeout(dataSource, this.connectionTimeout);
            this.createNetworkTimeoutExecutor(dataSource, dsClassName, jdbcUrl);
        }
        this.dataSource = dataSource;
    }

    private Connection newConnection() throws Exception {
        Connection connection = null;
        try {
            String username = this.config.getUsername();
            String password = this.config.getPassword();
            connection = username == null ? this.dataSource.getConnection() : this.dataSource.getConnection(username, password);
            this.setupConnection(connection);
            this.lastConnectionFailure.set(null);
            return connection;
        }
        catch (Exception e) {
            this.lastConnectionFailure.set(e);
            this.quietlyCloseConnection(connection, "(exception during connection creation)");
            throw e;
        }
    }

    private void setupConnection(Connection connection) throws SQLException {
        this.networkTimeout = this.getAndSetNetworkTimeout(connection, this.connectionTimeout);
        this.checkValidationMode(connection);
        connection.setAutoCommit(this.isAutoCommit);
        connection.setReadOnly(this.isReadOnly);
        int defaultLevel = connection.getTransactionIsolation();
        int n = this.transactionIsolation = this.transactionIsolation < 0 || defaultLevel == 0 ? defaultLevel : this.transactionIsolation;
        if (this.transactionIsolation != defaultLevel) {
            connection.setTransactionIsolation(this.transactionIsolation);
        }
        if (this.catalog != null) {
            connection.setCatalog(this.catalog);
        }
        this.executeSql(connection, this.config.getConnectionInitSql(), this.isIsolateInternalQueries && !this.isAutoCommit, false);
        this.setNetworkTimeout(connection, this.networkTimeout);
    }

    private void checkValidationMode(Connection connection) throws SQLException {
        if (!this.isValidChecked) {
            if (this.isUseJdbc4Validation) {
                try {
                    connection.isValid(1);
                }
                catch (Throwable e) {
                    this.LOGGER.debug("{} - Connection.isValid() is not supported, configure connection test query. ({})", (Object)this.poolName, (Object)e.getMessage());
                    throw e;
                }
            }
            try {
                this.executeSql(connection, this.config.getConnectionTestQuery(), false, this.isIsolateInternalQueries && !this.isAutoCommit);
            }
            catch (Throwable e) {
                this.LOGGER.debug("{} - Exception during executing connection test query. ({})", (Object)this.poolName, (Object)e.getMessage());
                throw e;
            }
            this.isValidChecked = true;
        }
    }

    private void setQueryTimeout(Statement statement, int timeoutSec) {
        block3: {
            if (this.isQueryTimeoutSupported != 0) {
                try {
                    statement.setQueryTimeout(timeoutSec);
                    this.isQueryTimeoutSupported = 1;
                }
                catch (Throwable e) {
                    if (this.isQueryTimeoutSupported != -1) break block3;
                    this.isQueryTimeoutSupported = 0;
                    this.LOGGER.debug("{} - Statement.setQueryTimeout() is not supported ({})", (Object)this.poolName, (Object)e.getMessage());
                }
            }
        }
    }

    private int getAndSetNetworkTimeout(Connection connection, long timeoutMs) {
        block3: {
            if (this.isNetworkTimeoutSupported != 0) {
                try {
                    int originalTimeout = connection.getNetworkTimeout();
                    connection.setNetworkTimeout(this.netTimeoutExecutor, (int)timeoutMs);
                    this.isNetworkTimeoutSupported = 1;
                    return originalTimeout;
                }
                catch (Throwable e) {
                    if (this.isNetworkTimeoutSupported != -1) break block3;
                    this.isNetworkTimeoutSupported = 0;
                    this.LOGGER.debug("{} - Connection.setNetworkTimeout() is not supported ({})", (Object)this.poolName, (Object)e.getMessage());
                }
            }
        }
        return 0;
    }

    private void setNetworkTimeout(Connection connection, long timeoutMs) throws SQLException {
        if (this.isNetworkTimeoutSupported == 1) {
            connection.setNetworkTimeout(this.netTimeoutExecutor, (int)timeoutMs);
        }
    }

    private void executeSql(Connection connection, String sql, boolean isCommit, boolean isRollback) throws SQLException {
        if (sql != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
                if (!this.isReadOnly) {
                    if (isCommit) {
                        connection.commit();
                    } else if (isRollback) {
                        connection.rollback();
                    }
                }
            }
        }
    }

    private void createNetworkTimeoutExecutor(DataSource dataSource, String dsClassName, String jdbcUrl) {
        if (dsClassName != null && dsClassName.contains("Mysql") || jdbcUrl != null && jdbcUrl.contains("mysql") || dataSource != null && dataSource.getClass().getName().contains("Mysql")) {
            this.netTimeoutExecutor = new SynchronousExecutor();
        } else {
            ThreadFactory threadFactory = this.config.getThreadFactory() != null ? this.config.getThreadFactory() : new DefaultThreadFactory("Hikari JDBC-timeout executor", true);
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
            executor.allowCoreThreadTimeOut(true);
            executor.setKeepAliveTime(15L, TimeUnit.SECONDS);
            this.netTimeoutExecutor = executor;
        }
    }

    private void setLoginTimeout(DataSource dataSource, long connectionTimeout) {
        if (connectionTimeout != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout((int)TimeUnit.MILLISECONDS.toSeconds(Math.max(1000L, connectionTimeout)));
            }
            catch (Throwable e) {
                this.LOGGER.warn("{} - Unable to set DataSource login timeout", (Object)this.poolName, (Object)e);
            }
        }
    }

    private String stringFromResetBits(int bits) {
        StringBuilder sb = new StringBuilder();
        for (int ndx = 0; ndx < RESET_STATES.length; ++ndx) {
            if ((bits & 1 << ndx) == 0) continue;
            sb.append(RESET_STATES[ndx]).append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    static final class NopMetricsTrackerDelegate
    extends MetricsTrackerDelegate {
        NopMetricsTrackerDelegate() {
        }

        @Override
        void recordConnectionUsage(PoolEntry poolEntry) {
        }

        @Override
        public void close() {
        }

        @Override
        void recordBorrowStats(PoolEntry poolEntry, long startTime) {
        }
    }

    static class MetricsTrackerDelegate
    implements AutoCloseable {
        final MetricsTracker tracker;

        protected MetricsTrackerDelegate() {
            this.tracker = null;
        }

        MetricsTrackerDelegate(MetricsTracker tracker) {
            this.tracker = tracker;
        }

        @Override
        public void close() {
            this.tracker.close();
        }

        void recordConnectionUsage(PoolEntry poolEntry) {
            this.tracker.recordConnectionUsageMillis(poolEntry.getMillisSinceBorrowed());
        }

        void recordBorrowStats(PoolEntry poolEntry, long startTime) {
            long now;
            poolEntry.lastBorrowed = now = ClockSource.INSTANCE.currentTime();
            this.tracker.recordConnectionAcquiredNanos(ClockSource.INSTANCE.elapsedNanos(startTime, now));
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            try {
                command.run();
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(PoolBase.class).debug("Exception executing {}", (Object)command, (Object)t);
            }
        }
    }
}

