/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.libs.hikari;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.greatmancode.com.zaxxer.libs.hikari.HikariConfigMXBean;
import com.greatmancode.com.zaxxer.libs.hikari.metrics.MetricsTrackerFactory;
import com.greatmancode.com.zaxxer.libs.hikari.util.PropertyElf;
import com.greatmancode.com.zaxxer.libs.hikari.util.UtilityElf;
import com.greatmancode.libs.org.slf4j.Logger;
import com.greatmancode.libs.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class HikariConfig
implements HikariConfigMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariConfig.class);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long VALIDATION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger();
    private static boolean unitTest;
    private volatile long connectionTimeout;
    private volatile long validationTimeout;
    private volatile long idleTimeout;
    private volatile long leakDetectionThreshold;
    private volatile long maxLifetime;
    private volatile int maxPoolSize = 10;
    private volatile int minIdle = -1;
    private String catalog;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String dataSourceJndiName;
    private String driverClassName;
    private String jdbcUrl;
    private String password;
    private String poolName;
    private String transactionIsolationName;
    private String username;
    private boolean isAutoCommit = true;
    private boolean isReadOnly;
    private boolean isInitializationFailFast = true;
    private boolean isIsolateInternalQueries;
    private boolean isRegisterMbeans;
    private boolean isAllowPoolSuspension;
    private DataSource dataSource;
    private Properties dataSourceProperties = new Properties();
    private ThreadFactory threadFactory;
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private MetricsTrackerFactory metricsTrackerFactory;
    private Object metricRegistry;
    private Object healthCheckRegistry;
    private Properties healthCheckProperties = new Properties();

    public HikariConfig() {
        this.connectionTimeout = CONNECTION_TIMEOUT;
        this.validationTimeout = VALIDATION_TIMEOUT;
        this.idleTimeout = IDLE_TIMEOUT;
        this.maxLifetime = MAX_LIFETIME;
        String systemProp = System.getProperty("hikaricp.configurationFile");
        if (systemProp != null) {
            this.loadProperties(systemProp);
        }
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyElf.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String propertyFileName) {
        this();
        this.loadProperties(propertyFileName);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeoutMs) {
        if (connectionTimeoutMs == 0L) {
            this.connectionTimeout = Integer.MAX_VALUE;
        } else {
            if (connectionTimeoutMs < 1000L) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than 1000ms");
            }
            this.connectionTimeout = connectionTimeoutMs;
        }
        if (this.validationTimeout > connectionTimeoutMs && connectionTimeoutMs > 0L) {
            this.validationTimeout = connectionTimeoutMs;
        }
    }

    @Override
    public long getValidationTimeout() {
        return this.validationTimeout;
    }

    @Override
    public void setValidationTimeout(long validationTimeoutMs) {
        if (validationTimeoutMs < 1000L) {
            throw new IllegalArgumentException("validationTimeout cannot be less than 1000ms");
        }
        this.validationTimeout = validationTimeoutMs;
        if (this.validationTimeout > this.connectionTimeout) {
            this.validationTimeout = this.connectionTimeout;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String className) {
        this.dataSourceClassName = className;
    }

    public void addDataSourceProperty(String propertyName, Object value) {
        this.dataSourceProperties.put(propertyName, value);
    }

    public String getDataSourceJNDI() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJNDI(String jndiDataSource) {
        this.dataSourceJndiName = jndiDataSource;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void setDataSourceProperties(Properties dsProperties) {
        this.dataSourceProperties.putAll((Map<?, ?>)dsProperties);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        try {
            Class<?> driverClass = this.getClass().getClassLoader().loadClass(driverClassName);
            driverClass.newInstance();
            this.driverClassName = driverClassName;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load class of driverClassName " + driverClassName, e);
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeoutMs) {
        if (idleTimeoutMs < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.idleTimeout = idleTimeoutMs;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public boolean isAllowPoolSuspension() {
        return this.isAllowPoolSuspension;
    }

    public void setAllowPoolSuspension(boolean isAllowPoolSuspension) {
        this.isAllowPoolSuspension = isAllowPoolSuspension;
    }

    public boolean isInitializationFailFast() {
        return this.isInitializationFailFast;
    }

    public void setInitializationFailFast(boolean failFast) {
        this.isInitializationFailFast = failFast;
    }

    public boolean isIsolateInternalQueries() {
        return this.isIsolateInternalQueries;
    }

    public void setIsolateInternalQueries(boolean isolate) {
        this.isIsolateInternalQueries = isolate;
    }

    @Deprecated
    public boolean isJdbc4ConnectionTest() {
        return false;
    }

    @Deprecated
    public void setJdbc4ConnectionTest(boolean useIsValid) {
        LOGGER.warn("The jdbcConnectionTest property is now deprecated, see the documentation for connectionTestQuery");
    }

    public MetricsTrackerFactory getMetricsTrackerFactory() {
        return this.metricsTrackerFactory;
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        if (this.metricRegistry != null) {
            throw new IllegalStateException("cannot use setMetricsTrackerFactory() and setMetricRegistry() together");
        }
        this.metricsTrackerFactory = metricsTrackerFactory;
    }

    public Object getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(Object metricRegistry) {
        if (this.metricsTrackerFactory != null) {
            throw new IllegalStateException("cannot use setMetricRegistry() and setMetricsTrackerFactory() together");
        }
        if (metricRegistry != null) {
            if (metricRegistry instanceof String) {
                try {
                    InitialContext initCtx = new InitialContext();
                    metricRegistry = (MetricRegistry)initCtx.lookup((String)metricRegistry);
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (!(metricRegistry instanceof MetricRegistry)) {
                throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.MetricRegistry");
            }
        }
        this.metricRegistry = metricRegistry;
    }

    public Object getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        if (healthCheckRegistry != null) {
            if (healthCheckRegistry instanceof String) {
                try {
                    InitialContext initCtx = new InitialContext();
                    healthCheckRegistry = (HealthCheckRegistry)initCtx.lookup((String)healthCheckRegistry);
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (!(healthCheckRegistry instanceof HealthCheckRegistry)) {
                throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.health.HealthCheckRegistry");
            }
        }
        this.healthCheckRegistry = healthCheckRegistry;
    }

    public Properties getHealthCheckProperties() {
        return this.healthCheckProperties;
    }

    public void setHealthCheckProperties(Properties healthCheckProperties) {
        this.healthCheckProperties.putAll((Map<?, ?>)healthCheckProperties);
    }

    public void addHealthCheckProperty(String key, String value) {
        this.healthCheckProperties.setProperty(key, value);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean isRegisterMbeans() {
        return this.isRegisterMbeans;
    }

    public void setRegisterMbeans(boolean register) {
        this.isRegisterMbeans = register;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    @Override
    public void setLeakDetectionThreshold(long leakDetectionThresholdMs) {
        this.leakDetectionThreshold = leakDetectionThresholdMs;
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetimeMs) {
        this.maxLifetime = maxLifetimeMs;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize cannot be less than 1");
        }
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public int getMinimumIdle() {
        return this.minIdle;
    }

    @Override
    public void setMinimumIdle(int minIdle) {
        if (minIdle < 0) {
            throw new IllegalArgumentException("minimumIdle cannot be negative");
        }
        this.minIdle = minIdle;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public ScheduledThreadPoolExecutor getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    public void setScheduledExecutorService(ScheduledThreadPoolExecutor executor) {
        this.scheduledExecutor = executor;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolationName;
    }

    public void setTransactionIsolation(String isolationLevel) {
        this.transactionIsolationName = isolationLevel;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void validate() {
        this.validateNumerics();
        this.catalog = UtilityElf.getNullIfEmpty(this.catalog);
        this.connectionInitSql = UtilityElf.getNullIfEmpty(this.connectionInitSql);
        this.connectionTestQuery = UtilityElf.getNullIfEmpty(this.connectionTestQuery);
        this.transactionIsolationName = UtilityElf.getNullIfEmpty(this.transactionIsolationName);
        this.dataSourceClassName = UtilityElf.getNullIfEmpty(this.dataSourceClassName);
        this.dataSourceJndiName = UtilityElf.getNullIfEmpty(this.dataSourceJndiName);
        this.driverClassName = UtilityElf.getNullIfEmpty(this.driverClassName);
        this.jdbcUrl = UtilityElf.getNullIfEmpty(this.jdbcUrl);
        if (this.poolName == null) {
            this.poolName = "HikariPool-" + POOL_NUMBER.getAndIncrement();
        }
        if (this.poolName.contains(":") && this.isRegisterMbeans) {
            throw new IllegalArgumentException("poolName cannot contain ':' when used with JMX");
        }
        if (this.driverClassName != null && this.jdbcUrl == null) {
            LOGGER.error("jdbcUrl is required with driverClassName");
            throw new IllegalArgumentException("jdbcUrl is required with driverClassName");
        }
        if (this.driverClassName != null && this.dataSourceClassName != null) {
            LOGGER.error("cannot use driverClassName and dataSourceClassName together");
            throw new IllegalArgumentException("cannot use driverClassName and dataSourceClassName together");
        }
        if (this.jdbcUrl != null && this.dataSourceClassName != null) {
            LOGGER.warn("using dataSourceClassName and ignoring jdbcUrl");
        } else if (this.jdbcUrl == null) {
            if (this.dataSource == null && this.dataSourceClassName == null) {
                LOGGER.error("either dataSource or dataSourceClassName is required");
                throw new IllegalArgumentException("either dataSource or dataSourceClassName is required");
            }
            if (this.dataSource != null && this.dataSourceClassName != null) {
                LOGGER.warn("using dataSource and ignoring dataSourceClassName");
            }
        }
        if (LOGGER.isDebugEnabled() || unitTest) {
            this.logConfiguration();
        }
    }

    private void validateNumerics() {
        if (this.validationTimeout > this.connectionTimeout && this.connectionTimeout != Integer.MAX_VALUE) {
            this.validationTimeout = this.connectionTimeout;
        }
        if (this.minIdle < 0) {
            this.minIdle = this.maxPoolSize;
        } else if (this.minIdle > this.maxPoolSize) {
            this.maxPoolSize = this.minIdle;
        }
        if (this.maxLifetime < 0L) {
            LOGGER.error("maxLifetime cannot be negative.");
            throw new IllegalArgumentException("maxLifetime cannot be negative.");
        }
        if (this.maxLifetime > 0L && this.maxLifetime < TimeUnit.SECONDS.toMillis(30L)) {
            LOGGER.warn("maxLifetime is less than 30000ms, setting to default {}ms.", (Object)MAX_LIFETIME);
            this.maxLifetime = MAX_LIFETIME;
        }
        if (this.idleTimeout != 0L && this.idleTimeout < TimeUnit.SECONDS.toMillis(10L)) {
            LOGGER.warn("idleTimeout is less than 10000ms, setting to default {}ms.", (Object)IDLE_TIMEOUT);
            this.idleTimeout = IDLE_TIMEOUT;
        }
        if (this.idleTimeout + TimeUnit.SECONDS.toMillis(1L) > this.maxLifetime && this.maxLifetime > 0L) {
            LOGGER.warn("idleTimeout is close to or greater than maxLifetime, disabling it.");
            this.maxLifetime = this.idleTimeout;
            this.idleTimeout = 0L;
        }
        if (this.maxLifetime == 0L && this.idleTimeout == 0L) {
            LOGGER.warn("setting idleTimeout to {}ms.", (Object)IDLE_TIMEOUT);
            this.idleTimeout = IDLE_TIMEOUT;
        }
        if (this.leakDetectionThreshold != 0L && this.leakDetectionThreshold < TimeUnit.SECONDS.toMillis(2L) && !unitTest) {
            LOGGER.warn("leakDetectionThreshold is less than 2000ms, setting to minimum 2000ms.");
            this.leakDetectionThreshold = 2000L;
        }
    }

    private void logConfiguration() {
        LOGGER.debug("{} - configuration:", (Object)this.poolName);
        TreeSet<String> propertyNames = new TreeSet<String>(PropertyElf.getPropertyNames(HikariConfig.class));
        for (String prop : propertyNames) {
            try {
                Object value = PropertyElf.getProperty(prop, this);
                if ("dataSourceProperties".equals(prop)) {
                    Properties dsProps = PropertyElf.copyProperties(this.dataSourceProperties);
                    dsProps.setProperty("password", "<masked>");
                    value = dsProps;
                }
                value = prop.contains("password") ? "<masked>" : value;
                LOGGER.debug((prop + "................................................").substring(0, 32) + (value != null ? value : ""));
            }
            catch (Exception e) {}
        }
    }

    protected void loadProperties(String propertyFileName) {
        block15: {
            File propFile = new File(propertyFileName);
            try (InputStream is = propFile.isFile() ? new FileInputStream(propFile) : this.getClass().getResourceAsStream(propertyFileName);){
                if (is != null) {
                    Properties props = new Properties();
                    props.load(is);
                    PropertyElf.setTargetFromProperties(this, props);
                    break block15;
                }
                throw new IllegalArgumentException("Property file " + propertyFileName + " was not found.");
            }
            catch (IOException io) {
                throw new RuntimeException("Error loading properties file", io);
            }
        }
    }

    public void copyState(HikariConfig other) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(other, field.get(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Exception copying HikariConfig state: " + e.getMessage(), e);
            }
        }
    }
}

