/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.hikari;

import com.greatmancode.com.zaxxer.hikari.HikariConfigMBean;
import com.greatmancode.com.zaxxer.hikari.IConnectionCustomizer;
import com.greatmancode.com.zaxxer.hikari.proxy.JavassistProxyFactory;
import com.greatmancode.com.zaxxer.hikari.util.PropertyBeanSetter;
import com.greatmancode.org.slf4j.Logger;
import com.greatmancode.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class HikariConfig
implements HikariConfigMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariConfig.class);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static int poolNumber;
    private volatile long connectionTimeout;
    private volatile long idleTimeout;
    private volatile long leakDetectionThreshold;
    private volatile long maxLifetime;
    private volatile int maxPoolSize = 10;
    private volatile int minIdle = -1;
    private String catalog;
    private String connectionCustomizerClassName;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String dataSourceJndiName;
    private String driverClassName;
    private String jdbcUrl;
    private String metricsTrackerClassName = "com.greatmancode.com.zaxxer.hikari.metrics.CodaHaleMetricsTracker";
    private String password;
    private String poolName;
    private String transactionIsolationName;
    private String username;
    private boolean isAutoCommit = true;
    private boolean isReadOnly;
    private boolean isInitializationFailFast;
    private boolean isJdbc4connectionTest = true;
    private boolean isIsolateInternalQueries;
    private boolean isRecordMetrics = false;
    private boolean isRegisterMbeans;
    private DataSource dataSource;
    private Properties dataSourceProperties = new Properties();
    private IConnectionCustomizer customizer;
    private int transactionIsolation = -1;

    public HikariConfig() {
        this.connectionTimeout = CONNECTION_TIMEOUT;
        this.idleTimeout = IDLE_TIMEOUT;
        this.maxLifetime = MAX_LIFETIME;
        this.customizer = new IConnectionCustomizer(){

            @Override
            public void customize(Connection connection) throws SQLException {
            }
        };
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyBeanSetter.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String propertyFileName) {
        this();
        File propFile = new File(propertyFileName);
        if (!propFile.isFile()) {
            throw new IllegalArgumentException("Property file " + propertyFileName + " was not found.");
        }
        try {
            FileInputStream fis = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(fis);
            PropertyBeanSetter.setTargetFromProperties(this, props);
            fis.close();
        }
        catch (IOException io) {
            throw new RuntimeException("Error loading properties file", io);
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getConnectionCustomizerClassName() {
        return this.connectionCustomizerClassName;
    }

    public void setConnectionCustomizerClassName(String connectionCustomizerClassName) {
        this.connectionCustomizerClassName = connectionCustomizerClassName;
    }

    public IConnectionCustomizer getConnectionCustomizer() {
        return this.customizer;
    }

    public void setConnectionCustomizer(IConnectionCustomizer customizer) {
        this.customizer = customizer;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeoutMs) {
        if (connectionTimeoutMs == 0L) {
            this.connectionTimeout = Integer.MAX_VALUE;
        } else {
            if (connectionTimeoutMs < 100L) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than 100ms");
            }
            this.connectionTimeout = connectionTimeoutMs;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String className) {
        this.dataSourceClassName = className;
    }

    public void addDataSourceProperty(String propertyName, Object value) {
        this.dataSourceProperties.put(propertyName, value);
    }

    public String getDataSourceJNDI() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJNDI(String jndiDataSource) {
        this.dataSourceJndiName = jndiDataSource;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void setDataSourceProperties(Properties dsProperties) {
        this.dataSourceProperties.putAll((Map<?, ?>)dsProperties);
    }

    public void setDriverClassName(String driverClassName) {
        try {
            Class<?> driverClass = this.getClass().getClassLoader().loadClass(driverClassName);
            driverClass.newInstance();
            this.driverClassName = driverClassName;
        }
        catch (Exception e) {
            throw new RuntimeException("driverClassName specified class '" + driverClassName + "' could not be loaded", e);
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeoutMs) {
        this.idleTimeout = idleTimeoutMs;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public boolean isInitializationFailFast() {
        return this.isInitializationFailFast;
    }

    public void setInitializationFailFast(boolean failFast) {
        this.isInitializationFailFast = failFast;
    }

    public boolean isIsolateInternalQueries() {
        return this.isIsolateInternalQueries;
    }

    public void setIsolateInternalQueries(boolean isolate) {
        this.isIsolateInternalQueries = isolate;
    }

    public boolean isJdbc4ConnectionTest() {
        return this.isJdbc4connectionTest;
    }

    public void setJdbc4ConnectionTest(boolean useIsValid) {
        this.isJdbc4connectionTest = useIsValid;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean isRecordMetrics() {
        return this.isRecordMetrics;
    }

    @Deprecated
    public void setRecordMetrics(boolean recordMetrics) {
        this.isRecordMetrics = recordMetrics;
    }

    public boolean isRegisterMbeans() {
        return this.isRegisterMbeans;
    }

    public void setRegisterMbeans(boolean register) {
        this.isRegisterMbeans = register;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    @Override
    public void setLeakDetectionThreshold(long leakDetectionThresholdMs) {
        this.leakDetectionThreshold = leakDetectionThresholdMs;
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetimeMs) {
        this.maxLifetime = maxLifetimeMs;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("maxPoolSize cannot be negative");
        }
        this.maxPoolSize = maxPoolSize;
    }

    public String getMetricsTrackerClassName() {
        return this.metricsTrackerClassName;
    }

    public void setMetricsTrackerClassName(String className) {
        this.metricsTrackerClassName = className;
    }

    @Override
    public int getMinimumIdle() {
        return this.minIdle;
    }

    @Override
    public void setMinimumIdle(int minIdle) {
        if (minIdle < 0) {
            throw new IllegalArgumentException("maxPoolSize cannot be negative or greater than maximumPoolSize");
        }
        this.minIdle = minIdle;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(String isolationLevel) {
        this.transactionIsolationName = isolationLevel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void validate() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        this.validateNumerics();
        if (this.connectionCustomizerClassName != null) {
            try {
                this.getClass().getClassLoader().loadClass(this.connectionCustomizerClassName);
            }
            catch (Exception e) {
                logger.warn("connectionCustomizationClass specified class '" + this.connectionCustomizerClassName + "' could not be loaded", e);
                this.connectionCustomizerClassName = null;
            }
        }
        if (this.driverClassName != null && this.jdbcUrl == null) {
            logger.error("when specifying driverClassName, jdbcUrl must also be specified");
            throw new IllegalStateException("when specifying driverClassName, jdbcUrl must also be specified");
        }
        if (this.jdbcUrl != null && this.driverClassName == null) {
            logger.error("when specifying jdbcUrl, driverClassName must also be specified");
            throw new IllegalStateException("when specifying jdbcUrl, driverClassName must also be specified");
        }
        if (this.driverClassName == null || this.jdbcUrl == null) {
            if (this.dataSource == null && this.dataSourceClassName == null) {
                logger.error("one of either dataSource, dataSourceClassName, or jdbcUrl and driverClassName must be specified");
                throw new IllegalArgumentException("one of either dataSource or dataSourceClassName must be specified");
            }
            if (this.dataSource != null && this.dataSourceClassName != null) {
                logger.warn("both dataSource and dataSourceClassName are specified, ignoring dataSourceClassName");
            }
        }
        if (this.connectionTestQuery != null) {
            this.isJdbc4connectionTest = false;
        } else if (!this.isJdbc4connectionTest) {
            logger.error("Either jdbc4ConnectionTest must be enabled or a connectionTestQuery must be specified");
            throw new IllegalStateException("Either jdbc4ConnectionTest must be enabled or a connectionTestQuery must be specified");
        }
        if (this.transactionIsolationName != null) {
            try {
                int level;
                Field field = Connection.class.getField(this.transactionIsolationName);
                this.transactionIsolation = level = field.getInt(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid transaction isolation value: " + this.transactionIsolationName);
            }
        }
        this.poolName = "HikariPool-" + poolNumber++;
        this.logConfiguration();
    }

    private void validateNumerics() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (this.connectionTimeout == Integer.MAX_VALUE) {
            logger.warn("No connection wait timeout is set, this might cause an infinite wait");
        } else if (this.connectionTimeout < TimeUnit.MILLISECONDS.toMillis(250L)) {
            logger.warn("connectionTimeout is less than 250ms, did you specify the wrong time unit?  Using default instead");
            this.connectionTimeout = CONNECTION_TIMEOUT;
        }
        if (this.minIdle < 0 || this.minIdle > this.maxPoolSize) {
            this.minIdle = this.maxPoolSize;
        }
        if (this.idleTimeout < 0L) {
            logger.error("idleTimeout cannot be negative.");
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        if (this.idleTimeout < TimeUnit.SECONDS.toMillis(30L) && this.idleTimeout != 0L) {
            logger.warn("idleTimeout is less than 30000ms, did you specify the wrong time unit?  Using default instead");
            this.idleTimeout = IDLE_TIMEOUT;
        }
        if (this.leakDetectionThreshold != 0L && this.leakDetectionThreshold < TimeUnit.SECONDS.toMillis(10L)) {
            logger.warn("leakDetectionThreshold is less than 10000ms, did you specify the wrong time unit?  Disabling leak detection");
            this.leakDetectionThreshold = 0L;
        }
        if (this.maxLifetime < 0L) {
            logger.error("maxLifetime cannot be negative.");
            throw new IllegalArgumentException("maxLifetime cannot be negative.");
        }
        if (this.maxLifetime < TimeUnit.SECONDS.toMillis(120L) && this.maxLifetime != 0L) {
            logger.warn("maxLifetime is less than 120000ms, did you specify the wrong time unit?  Using default instead.");
            this.maxLifetime = MAX_LIFETIME;
        }
    }

    private void logConfiguration() {
        LOGGER.debug("HikariCP pool {} configuration:", (Object)this.poolName);
        TreeSet<String> propertyNames = new TreeSet<String>(PropertyBeanSetter.getPropertyNames(HikariConfig.class));
        for (String prop : propertyNames) {
            try {
                Object value = PropertyBeanSetter.getProperty(prop, this);
                prop = (prop + "................................................").substring(0, 32);
                LOGGER.debug(prop + (value != null ? value : ""));
            }
            catch (Exception e) {}
        }
    }

    void copyState(HikariConfig other) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(other, field.get(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Exception copying HikariConfig state: " + e.getMessage(), e);
            }
        }
    }

    static {
        JavassistProxyFactory.initialize();
    }
}

