/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.utils;

import com.greatmancode.com.zaxxer.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.LogInfo;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.storage.StorageEngine;
import com.greatmancode.craftconomy3.storage.sql.H2Engine;
import com.greatmancode.craftconomy3.storage.sql.MySQLEngine;
import com.greatmancode.craftconomy3.storage.sql.SQLStorageEngine;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OldFormatConverter {
    private HikariDataSource db;
    private String tablePrefix;

    public void run() throws SQLException, IOException, ParseException {
        JSONObject entry;
        String dbType = Common.getInstance().getMainConfig().getString("System.Database.Type");
        HikariConfig config = new HikariConfig();
        if (dbType.equalsIgnoreCase("mysql")) {
            config.setMaximumPoolSize(10);
            config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            config.addDataSourceProperty("serverName", Common.getInstance().getMainConfig().getString("System.Database.Address"));
            config.addDataSourceProperty("port", Common.getInstance().getMainConfig().getString("System.Database.Port"));
            config.addDataSourceProperty("databaseName", Common.getInstance().getMainConfig().getString("System.Database.Db"));
            config.addDataSourceProperty("user", Common.getInstance().getMainConfig().getString("System.Database.Username"));
            config.addDataSourceProperty("password", Common.getInstance().getMainConfig().getString("System.Database.Password"));
            config.addDataSourceProperty("autoDeserialize", true);
            config.setConnectionTimeout(5000L);
            this.db = new HikariDataSource(config);
        } else if (dbType.equalsIgnoreCase("sqlite")) {
            config.setDriverClassName("org.sqlite.JDBC");
            config.setJdbcUrl("jdbc:sqlite:" + Common.getInstance().getServerCaller().getDataFolder() + "database.db");
            this.db = new HikariDataSource(config);
        } else {
            Common.getInstance().sendConsoleMessage(Level.SEVERE, "Unknown database type for old format converter!");
            return;
        }
        Connection connection = this.db.getConnection();
        this.tablePrefix = Common.getInstance().getMainConfig().getString("System.Database.Prefix");
        File accountFile = new File(Common.getInstance().getServerCaller().getDataFolder(), "accounts.json");
        Common.getInstance().sendConsoleMessage(Level.INFO, "Doing a backup in a xml file before doing the conversion.");
        JSONObject mainObject = new JSONObject();
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving currency table");
        PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "currency");
        ResultSet set = statement.executeQuery();
        JSONArray array = new JSONArray();
        while (set.next()) {
            entry = new JSONObject();
            entry.put((Object)"id", (Object)set.getInt("id"));
            entry.put((Object)"name", (Object)set.getString("name"));
            entry.put((Object)"plural", (Object)set.getString("plural"));
            entry.put((Object)"minor", (Object)set.getString("minor"));
            entry.put((Object)"minorPlural", (Object)set.getString("minorPlural"));
            entry.put((Object)"sign", (Object)set.getString("sign"));
            entry.put((Object)"status", (Object)set.getBoolean("status"));
            array.add((Object)entry);
        }
        statement.close();
        mainObject.put((Object)"currencies", (Object)array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving world group table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "worldgroup");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put((Object)"groupName", (Object)set.getString("groupName"));
            entry.put((Object)"worldList", (Object)set.getString("worldList"));
            array.add((Object)entry);
        }
        statement.close();
        mainObject.put((Object)"worldgroups", (Object)array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving exchange table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "exchange");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put((Object)"from_currency_id", (Object)set.getInt("from_currency_id"));
            entry.put((Object)"to_currency_id", (Object)set.getInt("to_currency_id"));
            entry.put((Object)"amount", (Object)set.getDouble("amount"));
            array.add((Object)entry);
        }
        statement.close();
        mainObject.put((Object)"exchanges", (Object)array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving config table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "config");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put((Object)"name", (Object)set.getString("name"));
            entry.put((Object)"value", (Object)set.getString("value"));
            array.add((Object)entry);
        }
        statement.close();
        mainObject.put((Object)"configs", (Object)array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving account table");
        array = new JSONArray();
        statement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "account");
        set = statement.executeQuery();
        while (set.next()) {
            entry = new JSONObject();
            entry.put((Object)"name", (Object)set.getString("name"));
            entry.put((Object)"infiniteMoney", (Object)set.getBoolean("infiniteMoney"));
            entry.put((Object)"ignoreACL", (Object)set.getBoolean("ignoreACL"));
            entry.put((Object)"uuid", (Object)set.getString("uuid"));
            JSONArray balanceArray = new JSONArray();
            PreparedStatement internalStatement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "balance WHERE username_id=?");
            internalStatement.setInt(1, set.getInt("id"));
            ResultSet internalSet = internalStatement.executeQuery();
            while (internalSet.next()) {
                JSONObject object = new JSONObject();
                object.put((Object)"currency_id", (Object)internalSet.getInt("currency_id"));
                object.put((Object)"worldName", (Object)internalSet.getString("worldName"));
                object.put((Object)"balance", (Object)internalSet.getDouble("balance"));
                balanceArray.add((Object)object);
            }
            internalStatement.close();
            entry.put((Object)"balances", (Object)balanceArray);
            internalStatement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "log WHERE username_id=?");
            internalStatement.setInt(1, set.getInt("id"));
            internalSet = internalStatement.executeQuery();
            JSONArray logArray = new JSONArray();
            while (internalSet.next()) {
                JSONObject object = new JSONObject();
                object.put((Object)"type", internalSet.getObject("type"));
                object.put((Object)"cause", internalSet.getObject("cause"));
                object.put((Object)"timestamp", (Object)internalSet.getTimestamp("timestamp"));
                object.put((Object)"causeReason", (Object)internalSet.getString("causeReason"));
                object.put((Object)"currencyName", (Object)internalSet.getString("currencyName"));
                object.put((Object)"worldName", (Object)internalSet.getString("worldName"));
                object.put((Object)"amount", (Object)internalSet.getDouble("amount"));
                logArray.add((Object)object);
            }
            internalStatement.close();
            entry.put((Object)"logs", (Object)logArray);
            internalStatement = connection.prepareStatement("SELECT * FROM " + this.tablePrefix + "acl WHERE account_id=?");
            internalStatement.setInt(1, set.getInt("id"));
            internalSet = internalStatement.executeQuery();
            JSONArray aclArray = new JSONArray();
            while (internalSet.next()) {
                JSONObject object = new JSONObject();
                object.put((Object)"playerName", (Object)internalSet.getString("playerName"));
                object.put((Object)"deposit", (Object)internalSet.getBoolean("deposit"));
                object.put((Object)"withdraw", (Object)internalSet.getBoolean("withdraw"));
                object.put((Object)"acl", (Object)internalSet.getBoolean("acl"));
                object.put((Object)"balance", (Object)internalSet.getBoolean("balance"));
                object.put((Object)"owner", (Object)internalSet.getBoolean("owner"));
                aclArray.add((Object)object);
            }
            internalStatement.close();
            entry.put((Object)"acls", (Object)aclArray);
            array.add((Object)entry);
        }
        statement.close();
        mainObject.put((Object)"accounts", (Object)array);
        Common.getInstance().sendConsoleMessage(Level.INFO, "Writing json file");
        FileWriter writer = new FileWriter(accountFile);
        writer.write(mainObject.toJSONString());
        writer.flush();
        writer.close();
        Common.getInstance().sendConsoleMessage(Level.INFO, "File written! Dropping all tables");
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "config");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "acl");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "balance");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "log");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "worldgroup");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "exchange");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "account");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "currency");
        statement.execute();
        statement.close();
        statement = connection.prepareStatement("DROP TABLE " + this.tablePrefix + "payday");
        statement.execute();
        statement.close();
        connection.close();
        this.step2();
    }

    private void step2() throws SQLException, IOException, ParseException {
        Common.getInstance().sendConsoleMessage(Level.INFO, "Converting step 2: Inserting the data back in all the new tables");
        Common.getInstance().sendConsoleMessage(Level.INFO, "Creating the new tables");
        String dbType = Common.getInstance().getMainConfig().getString("System.Database.Type");
        if (dbType.equals("sqlite")) {
            Common.getInstance().sendConsoleMessage(Level.INFO, "You are using SQLite! This is now deprecated. Selecting H2 instead.");
            Common.getInstance().getMainConfig().setValue("System.Database.Type", "h2");
            dbType = "h2";
        }
        SQLStorageEngine engine = null;
        HikariConfig config = new HikariConfig();
        if (dbType.equalsIgnoreCase("mysql")) {
            engine = new MySQLEngine();
        } else if (dbType.equalsIgnoreCase("h2")) {
            engine = new H2Engine();
        } else {
            throw new UnsupportedOperationException("Unknown database!");
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Loading backup json file");
        File accountFile = new File(Common.getInstance().getServerCaller().getDataFolder(), "accounts.json");
        System.out.println(accountFile.exists());
        JSONObject jsonObject = (JSONObject)new JSONParser().parse((Reader)new FileReader(accountFile));
        HashMap<Integer, String> currenciesMap = new HashMap<Integer, String>();
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving currencies");
        JSONArray currencyArray = (JSONArray)jsonObject.get((Object)"currencies");
        for (JSONObject obj : currencyArray) {
            currenciesMap.put(((Long)obj.get((Object)"id")).intValue(), (String)obj.get((Object)"name"));
            Currency currency = new Currency((String)obj.get((Object)"name"), (String)obj.get((Object)"plural"), (String)obj.get((Object)"minor"), (String)obj.get((Object)"minorPlural"), (String)obj.get((Object)"sign"));
            try {
                Class<?> clazz = currency.getClass();
                Method setDefault = clazz.getDeclaredMethod("setDefault", Boolean.TYPE);
                setDefault.setAccessible(true);
                setDefault.invoke((Object)currency, (boolean)((Boolean)obj.get((Object)"status")));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            ((StorageEngine)engine).saveCurrency("", currency);
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving world groups...");
        JSONArray worldgroup = (JSONArray)jsonObject.get((Object)"worldgroups");
        for (JSONObject obj : worldgroup) {
            ((StorageEngine)engine).saveWorldGroup((String)obj.get((Object)"groupName"), (String)obj.get((Object)"worldList"));
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving Exchange rates");
        JSONArray exchangeArray = (JSONArray)jsonObject.get((Object)"exchanges");
        for (JSONObject obj : exchangeArray) {
            int id_from = ((Long)obj.get((Object)"from_currency_id")).intValue();
            int id_to = ((Long)obj.get((Object)"to_currency_id")).intValue();
            ((StorageEngine)engine).setExchangeRate(((StorageEngine)engine).getCurrency((String)currenciesMap.get(id_from)), ((StorageEngine)engine).getCurrency((String)currenciesMap.get(id_to)), (Double)obj.get((Object)"amount"));
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving configs");
        JSONArray configArray = (JSONArray)jsonObject.get((Object)"configs");
        for (JSONObject obj : configArray) {
            if (obj.get((Object)"name").equals("dbVersion")) continue;
            ((StorageEngine)engine).setConfigEntry((String)obj.get((Object)"name"), (String)obj.get((Object)"value"));
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Saving accounts. This may take a long time.");
        boolean log = false;
        if (Common.getInstance().getMainConfig().getBoolean("System.Logging.Enabled")) {
            Common.getInstance().getMainConfig().setValue("System.Logging.Enabled", false);
            log = true;
        }
        JSONArray accounts = (JSONArray)jsonObject.get((Object)"accounts");
        for (JSONObject obj : accounts) {
            String name = (String)obj.get((Object)"name");
            Account account = null;
            account = name.startsWith("bank:") ? ((StorageEngine)engine).getAccount(name.split(":")[1], true, false) : ((StorageEngine)engine).getAccount(name, false, false);
            ((StorageEngine)engine).setIgnoreACL(account, (Boolean)obj.get((Object)"ignoreACL"));
            ((StorageEngine)engine).setInfiniteMoney(account, (Boolean)obj.get((Object)"infiniteMoney"));
            if (obj.get((Object)"uuid") != null) {
                ((StorageEngine)engine).updateUUID(account.getAccountName(), UUID.fromString((String)obj.get((Object)"uuid")));
            }
            JSONArray balances = (JSONArray)obj.get((Object)"balances");
            for (JSONObject internalObj : balances) {
                ((StorageEngine)engine).setBalance(account, (Double)internalObj.get((Object)"balance"), ((StorageEngine)engine).getCurrency((String)currenciesMap.get(((Long)internalObj.get((Object)"currency_id")).intValue())), (String)internalObj.get((Object)"worldName"));
            }
            JSONArray logs = (JSONArray)obj.get((Object)"logs");
            for (JSONObject internalObj : logs) {
                ((StorageEngine)engine).saveLog(LogInfo.valueOf((String)internalObj.get((Object)"type")), Cause.valueOf((String)internalObj.get((Object)"cause")), (String)internalObj.get((Object)"causeReason"), account, (Double)internalObj.get((Object)"amount"), ((StorageEngine)engine).getCurrency((String)internalObj.get((Object)"currencyName")), (String)internalObj.get((Object)"worldName"), (Timestamp)internalObj.get((Object)"timestamp"));
            }
            JSONArray acls = (JSONArray)obj.get((Object)"acls");
            for (JSONObject internalObj : acls) {
                ((StorageEngine)engine).saveACL(account, (String)internalObj.get((Object)"playerName"), (Boolean)internalObj.get((Object)"deposit"), (Boolean)internalObj.get((Object)"withdraw"), (Boolean)internalObj.get((Object)"acl"), (Boolean)internalObj.get((Object)"balance"), (Boolean)internalObj.get((Object)"owner"));
            }
        }
        if (log) {
            Common.getInstance().getMainConfig().setValue("System.Logging.Enabled", true);
        }
        Common.getInstance().sendConsoleMessage(Level.INFO, "Converting done!");
    }
}

