/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.tools.language;

import com.greatmancode.craftconomy3.tools.configuration.Config;
import com.greatmancode.craftconomy3.tools.configuration.ConfigurationManager;
import com.greatmancode.craftconomy3.tools.interfaces.caller.ServerCaller;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class LanguageManager {
    private static final String MAIN_KEY = "language";
    private static final String SEPARATOR = ".";
    private Config languageFile = null;
    private Map<String, String> languageList = new HashMap<String, String>();

    public LanguageManager(ServerCaller serverCaller, File path, String fileName) {
        this.languageFile = new ConfigurationManager(serverCaller).loadFile(path, fileName);
        this.loadLanguage();
    }

    private void loadLanguage() {
        this.languageList = this.languageFile.getStringMap(MAIN_KEY);
    }

    public void addLanguageEntry(String key, String value) {
        if (!this.languageList.containsKey(key)) {
            this.languageFile.setValue("language." + key, value);
            this.loadLanguage();
        }
    }

    public String parse(String key, Object ... args) {
        return String.format(this.languageList.get(key), args);
    }

    public String getString(String key) {
        return this.languageList.get(key);
    }
}

