/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.storage.sql;

import com.greatmancode.com.zaxxer.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.LogInfo;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.account.AccountACLValue;
import com.greatmancode.craftconomy3.account.Balance;
import com.greatmancode.craftconomy3.commands.currency.CurrencyRatesCommand;
import com.greatmancode.craftconomy3.commands.money.LogCommand;
import com.greatmancode.craftconomy3.commands.money.TopCommand;
import com.greatmancode.craftconomy3.converter.Converter;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.groups.WorldGroup;
import com.greatmancode.craftconomy3.storage.StorageEngine;
import com.greatmancode.craftconomy3.storage.sql.tables.AccessTable;
import com.greatmancode.craftconomy3.storage.sql.tables.AccountTable;
import com.greatmancode.craftconomy3.storage.sql.tables.BalanceTable;
import com.greatmancode.craftconomy3.storage.sql.tables.ConfigTable;
import com.greatmancode.craftconomy3.storage.sql.tables.CurrencyTable;
import com.greatmancode.craftconomy3.storage.sql.tables.ExchangeTable;
import com.greatmancode.craftconomy3.storage.sql.tables.LogTable;
import com.greatmancode.craftconomy3.storage.sql.tables.WorldGroupTable;
import com.greatmancode.craftconomy3.tools.utils.Tools;
import com.greatmancode.craftconomy3.utils.BackendErrorException;
import com.greatmancode.craftconomy3.utils.NoExchangeRate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class SQLStorageEngine
extends StorageEngine {
    protected String tablePrefix;
    protected HikariDataSource db;
    protected AccessTable accessTable;
    protected AccountTable accountTable;
    protected BalanceTable balanceTable;
    protected ConfigTable configTable;
    protected CurrencyTable currencyTable;
    protected ExchangeTable exchangeTable;
    protected LogTable logTable;
    protected WorldGroupTable worldGroupTable;

    @Override
    public void disable() {
        this.db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Account getAccount(String name, boolean bankAccount, boolean createDefault) {
        Account account;
        if (Common.getInstance().getCommandManager().getLevel() == 0) {
            return null;
        }
        boolean create = false;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            boolean infiniteMoney = false;
            boolean ignoreACL = false;
            connection = this.db.getConnection();
            statement = connection.prepareStatement(this.accountTable.selectEntryName);
            statement.setString(1, name);
            statement.setBoolean(2, bankAccount);
            ResultSet set = statement.executeQuery();
            if (!set.next()) {
                statement.close();
                if (bankAccount) {
                    statement = connection.prepareStatement(this.accountTable.insertEntryBank);
                    statement.setString(1, name);
                } else {
                    statement = connection.prepareStatement(this.accountTable.insertEntry);
                    statement.setString(1, name);
                    if (Common.getInstance().getServerCaller().getPlayerCaller().isOnline(name)) {
                        statement.setString(2, Common.getInstance().getServerCaller().getPlayerCaller().getUUID(name).toString());
                    } else {
                        statement.setString(2, null);
                    }
                }
                statement.executeUpdate();
                statement.close();
                create = true;
            } else {
                infiniteMoney = set.getBoolean("infiniteMoney");
                ignoreACL = set.getBoolean("ignoreACL");
            }
            statement.close();
            if (create && !bankAccount && createDefault) {
                statement = connection.prepareStatement(this.balanceTable.insertEntry);
                statement.setDouble(1, Common.getInstance().getDefaultHoldings());
                statement.setString(2, Account.getWorldGroupOfPlayerCurrentlyIn(name));
                statement.setString(3, name);
                statement.setBoolean(4, bankAccount);
                statement.setString(5, Common.getInstance().getCurrencyManager().getDefaultCurrency().getName());
                statement.executeUpdate();
                statement.close();
            }
            account = new Account(name, bankAccount, infiniteMoney, ignoreACL);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
                throw throwable;
            }
            Tools.closeJDBCStatement(statement);
            Tools.closeJDBCConnection(connection);
            return null;
        }
        Tools.closeJDBCStatement(statement);
        Tools.closeJDBCConnection(connection);
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Account getAccount(UUID uuid) {
        Connection connection;
        PreparedStatement statement;
        block7: {
            Account account;
            block6: {
                statement = null;
                connection = null;
                try {
                    connection = this.db.getConnection();
                    statement = connection.prepareStatement(this.accountTable.selectEntryUuid);
                    statement.setString(1, uuid.toString());
                    ResultSet set = statement.executeQuery();
                    if (set.next()) {
                        account = new Account(set.getString("name"), set.getBoolean("bank"), set.getBoolean("infiniteMoney"), set.getBoolean("ignoreACL"));
                        Tools.closeJDBCStatement(statement);
                        break block6;
                    }
                    Tools.closeJDBCStatement(statement);
                    break block7;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Tools.closeJDBCConnection(connection);
            return account;
        }
        Tools.closeJDBCConnection(connection);
        return null;
        finally {
            Tools.closeJDBCStatement(statement);
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllAccounts(boolean bank) {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.selectAllEntry);
                statement.setBoolean(1, bank);
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    result.add(set.getString("name"));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    @Override
    public void saveLog(LogInfo info, Cause cause, String causeReason, Account account, double amount, Currency currency, String worldName) {
        this.saveLog(info, cause, causeReason, account, amount, currency, worldName, new Timestamp(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLog(LogInfo info, Cause cause, String causeReason, Account account, double amount, Currency currency, String worldName, Timestamp timestamp) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.logTable.insertEntry);
                statement.setString(1, account.getAccountName());
                statement.setBoolean(2, account.isBankAccount());
                statement.setString(3, info.toString());
                statement.setString(4, cause.toString());
                statement.setString(5, causeReason);
                statement.setString(6, worldName);
                statement.setDouble(7, amount);
                statement.setString(8, currency.getName());
                statement.setTimestamp(9, timestamp);
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfigEntry(String name) {
        String result;
        block6: {
            Connection connection = null;
            PreparedStatement statement = null;
            result = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.configTable.selectEntry);
                statement.setString(1, name);
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    result = set.getString("value");
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigEntry(String name, String value) {
        block7: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                if (this.getConfigEntry(name) != null) {
                    statement = connection.prepareStatement(this.configTable.updateEntry);
                    statement.setString(1, value);
                    statement.setString(2, name);
                    statement.executeUpdate();
                } else {
                    statement = connection.prepareStatement(this.configTable.insertEntry);
                    statement.setString(1, name);
                    statement.setString(2, value);
                    statement.executeUpdate();
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Balance> getAllBalance(Account account) {
        ArrayList<Balance> balanceList;
        block6: {
            balanceList = new ArrayList<Balance>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.balanceTable.selectAllEntryAccount);
                statement.setString(1, account.getAccountName());
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    balanceList.add(new Balance(set.getString("worldName"), Common.getInstance().getCurrencyManager().getCurrency(set.getString("currency_id")), set.getDouble("balance")));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return balanceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Balance> getAllWorldBalance(Account account, String worldName) {
        ArrayList<Balance> balanceList;
        block6: {
            balanceList = new ArrayList<Balance>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.balanceTable.selectWorldEntryAccount);
                statement.setString(1, account.getAccountName());
                statement.setString(2, worldName);
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    balanceList.add(new Balance(set.getString("worldName"), Common.getInstance().getCurrencyManager().getCurrency(set.getString("currency_id")), set.getDouble("balance")));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return balanceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBalance(Account account, Currency currency, String world) {
        double balance;
        block5: {
            balance = 0.0;
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.balanceTable.selectWorldCurrencyEntryAccount);
                statement.setString(1, account.getAccountName());
                statement.setString(2, world);
                statement.setString(3, currency.getName());
                ResultSet set = statement.executeQuery();
                balance = set.next() ? set.getDouble("balance") : 0.0;
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return balance;
    }

    @Override
    public double setBalance(Account account, double amount, Currency currency, String world) {
        double result;
        PreparedStatement statement;
        Connection connection;
        block5: {
            connection = null;
            statement = null;
            result = 0.0;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.balanceTable.selectWorldCurrencyEntryAccount);
                statement.setString(1, account.getAccountName());
                statement.setString(2, world);
                statement.setString(3, currency.getName());
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    result = amount;
                    statement.close();
                    statement = connection.prepareStatement(this.balanceTable.updateEntry);
                    statement.setDouble(1, result);
                    statement.setString(2, account.getAccountName());
                    statement.setBoolean(3, account.isBankAccount());
                    statement.setString(4, currency.getName());
                    statement.setString(5, world);
                    statement.executeUpdate();
                    statement.close();
                    break block5;
                }
                result = amount;
                statement.close();
                statement = connection.prepareStatement(this.balanceTable.insertEntry);
                statement.setDouble(1, result);
                statement.setString(2, world);
                statement.setString(3, account.getAccountName());
                statement.setBoolean(4, account.isBankAccount());
                statement.setString(5, currency.getName());
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new BackendErrorException(e.getMessage());
                }
                catch (Throwable throwable) {
                    Tools.closeJDBCStatement(statement);
                    Tools.closeJDBCConnection(connection);
                    throw throwable;
                }
            }
        }
        Tools.closeJDBCStatement(statement);
        Tools.closeJDBCConnection(connection);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInfiniteMoney(Account account, boolean infinite) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.updateInfinitemoneyEntry);
                statement.setBoolean(1, infinite);
                statement.setString(2, account.getAccountName());
                statement.setBoolean(3, account.isBankAccount());
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIgnoreACL(Account account, boolean ignoreACL) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.updateIgnoreaclEntry);
                statement.setBoolean(1, ignoreACL);
                statement.setString(2, account.getAccountName());
                statement.setBoolean(3, account.isBankAccount());
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AccountACLValue> retrieveACL(Account account) {
        HashMap<String, AccountACLValue> result;
        block6: {
            result = new HashMap<String, AccountACLValue>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accessTable.selectEntry);
                statement.setString(1, account.getAccountName());
                statement.setBoolean(2, account.isBankAccount());
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    result.put(set.getString("playerName"), new AccountACLValue(set.getBoolean("deposit"), set.getBoolean("withdraw"), set.getBoolean("acl"), set.getBoolean("balance"), set.getBoolean("owner")));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountACLValue saveACL(Account account, String name, boolean deposit, boolean withdraw, boolean acl, boolean balance, boolean owner) {
        block7: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accessTable.selectEntryUnique);
                statement.setString(1, account.getAccountName());
                statement.setBoolean(2, account.isBankAccount());
                statement.setString(3, name);
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    statement.close();
                    statement = connection.prepareStatement(this.accessTable.updateEntry);
                    statement.setBoolean(1, owner);
                    statement.setBoolean(2, balance);
                    statement.setBoolean(3, deposit);
                    statement.setBoolean(4, acl);
                    statement.setBoolean(5, withdraw);
                    statement.setString(6, account.getAccountName());
                    statement.setBoolean(7, account.isBankAccount());
                    statement.setString(8, name);
                } else {
                    statement.close();
                    statement = connection.prepareStatement(this.accessTable.insertEntry);
                    statement.setString(1, account.getAccountName());
                    statement.setBoolean(2, account.isBankAccount());
                    statement.setString(3, name);
                    statement.setBoolean(4, owner);
                    statement.setBoolean(5, balance);
                    statement.setBoolean(6, deposit);
                    statement.setBoolean(7, acl);
                    statement.setBoolean(8, withdraw);
                    statement.executeUpdate();
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return new AccountACLValue(deposit, withdraw, acl, balance, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getExchangeRate(Currency currency, Currency otherCurrency) throws NoExchangeRate {
        double result;
        block6: {
            result = 0.0;
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.exchangeTable.selectEntry);
                statement.setString(1, currency.getName());
                statement.setString(2, otherCurrency.getName());
                ResultSet set = statement.executeQuery();
                if (!set.next()) {
                    throw new NoExchangeRate();
                }
                result = set.getDouble("amount");
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExchangeRate(Currency currency, Currency otherCurrency, double amount) {
        block7: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.exchangeTable.selectEntry);
                statement.setString(1, currency.getName());
                statement.setString(2, otherCurrency.getName());
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    statement.close();
                    statement = connection.prepareStatement(this.exchangeTable.updateEntry);
                    statement.setString(1, currency.getName());
                    statement.setString(2, otherCurrency.getName());
                    statement.setDouble(3, amount);
                    statement.executeUpdate();
                } else {
                    statement.close();
                    statement = connection.prepareStatement(this.exchangeTable.insertEntry);
                    statement.setString(1, currency.getName());
                    statement.setString(2, otherCurrency.getName());
                    statement.setDouble(3, amount);
                    statement.executeUpdate();
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCurrency(String oldName, Currency currency) {
        block7: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.currencyTable.selectEntry);
                statement.setString(1, currency.getName());
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    statement.close();
                    statement = connection.prepareStatement(this.currencyTable.updateEntry);
                    statement.setString(1, currency.getName());
                    statement.setString(2, currency.getPlural());
                    statement.setString(3, currency.getMinor());
                    statement.setString(4, currency.getMinorPlural());
                    statement.setString(5, currency.getSign());
                    statement.setBoolean(6, currency.getStatus());
                    statement.setBoolean(7, currency.isPrimaryBankCurrency());
                    statement.setString(8, oldName);
                    statement.executeUpdate();
                } else {
                    statement.close();
                    statement = connection.prepareStatement(this.currencyTable.insertEntry);
                    statement.setString(1, currency.getName());
                    statement.setString(2, currency.getPlural());
                    statement.setString(3, currency.getMinor());
                    statement.setString(4, currency.getMinorPlural());
                    statement.setString(5, currency.getSign());
                    statement.setBoolean(6, currency.getStatus());
                    statement.setBoolean(7, currency.isPrimaryBankCurrency());
                    statement.executeUpdate();
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCurrency(Currency currency) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.currencyTable.deleteEntry);
                statement.setString(1, currency.getName());
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUsername(String name, UUID uuid) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.updateNameByUuid);
                statement.setString(1, name);
                statement.setString(2, uuid.toString());
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUUID(String name, UUID uuid) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.updateUuidByName);
                statement.setString(1, uuid.toString());
                statement.setString(2, name);
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, WorldGroup> getWorldGroups() {
        HashMap<String, WorldGroup> result;
        block6: {
            result = new HashMap<String, WorldGroup>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.worldGroupTable.selectAllEntry);
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    result.put(set.getString("groupName"), new WorldGroup(set.getString("groupName")));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorldGroup(String group) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.worldGroupTable.deleteEntry);
                statement.setString(1, group);
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String[] getBankAccountList(String sender) {
        ArrayList<String> results = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.db.getConnection();
            statement = connection.prepareStatement(this.accessTable.getAccountList);
            statement.setString(1, sender);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                results.add(set.getString("name"));
            }
        }
        catch (SQLException e) {
            Tools.closeJDBCStatement(statement);
            Tools.closeJDBCConnection(connection);
            catch (Throwable throwable) {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
                throw throwable;
            }
        }
        Tools.closeJDBCStatement(statement);
        Tools.closeJDBCConnection(connection);
        return (String[])results.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogCommand.LogEntry> getLog(Account user, int page) {
        ArrayList<LogCommand.LogEntry> logEntryList;
        block5: {
            logEntryList = new ArrayList<LogCommand.LogEntry>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.logTable.selectEntryLimit);
                statement.setString(1, user.getAccountName());
                statement.setInt(2, (page - 1) * 10);
                statement.setInt(3, 10);
                ResultSet set = statement.executeQuery();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return logEntryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TopCommand.TopEntry> getTopEntry(int page, Currency currency, String world) {
        ArrayList<TopCommand.TopEntry> result;
        block6: {
            result = new ArrayList<TopCommand.TopEntry>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.balanceTable.listTopAccount);
                statement.setString(1, world);
                statement.setString(2, currency.getName());
                statement.setInt(3, (page - 1) * 10);
                statement.setInt(4, 10);
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    result.add(new TopCommand.TopEntry(set.getString("name"), Common.getInstance().getCurrencyManager().getCurrency(set.getString("currencyName")), set.getDouble("balance")));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CurrencyRatesCommand.CurrencyRateEntry> getCurrencyExchanges() {
        ArrayList<CurrencyRatesCommand.CurrencyRateEntry> results;
        block6: {
            results = new ArrayList<CurrencyRatesCommand.CurrencyRateEntry>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.exchangeTable.selectAll);
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    results.add(new CurrencyRatesCommand.CurrencyRateEntry(Common.getInstance().getCurrencyManager().getCurrency(set.getString("from_currency")), Common.getInstance().getCurrencyManager().getCurrency(set.getString("to_currency")), set.getDouble("amount")));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanLog(Timestamp timestamp) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.logTable.cleanEntry);
                statement.setTimestamp(1, timestamp);
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAccount(String name, boolean bankAccount) {
        boolean result;
        block6: {
            result = false;
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.deleteEntry);
                statement.setString(1, name);
                statement.setBoolean(2, bankAccount);
                if (statement.executeUpdate() == 1) {
                    result = true;
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accountExist(String name, boolean bankAccount) {
        boolean result;
        block6: {
            result = false;
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.selectEntryName);
                statement.setString(1, name);
                statement.setBoolean(2, bankAccount);
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    result = true;
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveWorldGroup(String name, String worldList) {
        block7: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.worldGroupTable.selectEntry);
                statement.setString(1, name);
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    statement.close();
                    statement = connection.prepareStatement(this.worldGroupTable.updateEntry);
                    statement.setString(1, worldList);
                    statement.setString(2, name);
                    statement.executeUpdate();
                } else {
                    statement.close();
                    statement = connection.prepareStatement(this.worldGroupTable.insertEntryWithWorldlist);
                    statement.setString(1, name);
                    statement.setString(2, worldList);
                    statement.executeUpdate();
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllCurrencyNames() {
        ArrayList<String> results;
        block6: {
            results = new ArrayList<String>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.currencyTable.selectAllEntry);
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    results.add(set.getString("name"));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultCurrency(Currency currency) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.currencyTable.setAsDefault1);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.currencyTable.setAsDefault2);
                statement.setString(1, currency.getName());
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultBankCurrency(Currency currency) {
        block5: {
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.currencyTable.setAsDefaultBank1);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.currencyTable.setAsDefaultBank2);
                statement.setString(1, currency.getName());
                statement.executeUpdate();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Currency getCurrency(String name) {
        Currency result;
        block6: {
            result = null;
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.currencyTable.selectEntry);
                statement.setString(1, name);
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    result = new Currency(set.getString("name"), set.getString("plural"), set.getString("minor"), set.getString("minorPlural"), set.getString("sign"));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Currency> getAllCurrencies() {
        HashMap<String, Currency> results;
        block6: {
            results = new HashMap<String, Currency>();
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.currencyTable.selectAllEntry);
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    results.put(set.getString("name"), new Currency(set.getString("name"), set.getString("plural"), set.getString("minor"), set.getString("minorPlural"), set.getString("sign"), set.getBoolean("status"), set.getBoolean("bankCurrency")));
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String retrieveWorldGroupWorlds(String name) {
        String result;
        block7: {
            result = "";
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.worldGroupTable.selectEntry);
                statement.setString(1, name);
                ResultSet set = statement.executeQuery();
                if (set.next()) {
                    result = set.getString("worldList");
                } else {
                    statement.close();
                    statement = connection.prepareStatement(this.worldGroupTable.insertEntry);
                    statement.setString(1, name);
                    statement.executeUpdate();
                }
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveImporterUsers(List<Converter.User> userList) {
        block11: {
            StringBuilder builder = new StringBuilder("INSERT INTO " + this.tablePrefix + "account" + "(name,uuid) VALUES(");
            StringBuilder balanceBuilder = new StringBuilder("INSERT INTO " + this.tablePrefix + "balance" + "(balance, worldName, currency_id, username_id) VALUES(");
            boolean first = true;
            for (Converter.User userEntry : userList) {
                if (!first) {
                    builder.append(",(");
                    balanceBuilder.append(",(");
                } else {
                    first = false;
                }
                if (userEntry.getUuid() == null) {
                    builder.append("'" + userEntry.getUser() + "',null)");
                } else {
                    builder.append("'" + userEntry.getUser() + "','" + userEntry.getUuid() + "')");
                }
                if (userEntry.getUuid() != null) {
                    balanceBuilder.append(userEntry.getBalance() + ",'default','" + Common.getInstance().getCurrencyManager().getDefaultCurrency().getName() + "',(SELECT id from " + this.tablePrefix + "account" + " WHERE uuid='" + userEntry.getUuid() + "'))");
                    continue;
                }
                balanceBuilder.append(userEntry.getBalance() + ",'default','" + Common.getInstance().getCurrencyManager().getDefaultCurrency().getName() + "',(SELECT id from " + this.tablePrefix + "account" + " WHERE name='" + userEntry.getUser() + "'))");
            }
            builder.append(";");
            balanceBuilder.append(";");
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(builder.toString());
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(balanceBuilder.toString());
                statement.executeUpdate();
                statement.close();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block11;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }
}

