/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.storage.sql;

import com.greatmancode.com.zaxxer.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.storage.sql.SQLStorageEngine;
import com.greatmancode.craftconomy3.storage.sql.tables.AccessTable;
import com.greatmancode.craftconomy3.storage.sql.tables.AccountTable;
import com.greatmancode.craftconomy3.storage.sql.tables.BalanceTable;
import com.greatmancode.craftconomy3.storage.sql.tables.ConfigTable;
import com.greatmancode.craftconomy3.storage.sql.tables.CurrencyTable;
import com.greatmancode.craftconomy3.storage.sql.tables.ExchangeTable;
import com.greatmancode.craftconomy3.storage.sql.tables.LogTable;
import com.greatmancode.craftconomy3.storage.sql.tables.WorldGroupTable;
import com.greatmancode.craftconomy3.tools.utils.Tools;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class H2Engine
extends SQLStorageEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H2Engine() {
        block5: {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(10);
            config.setDataSourceClassName("org.h2.jdbcx.JdbcDataSource");
            config.addDataSourceProperty("user", "sa");
            config.addDataSourceProperty("url", "jdbc:h2:file:" + new File(Common.getInstance().getServerCaller().getDataFolder().getPath(), "database").getAbsolutePath() + ";MV_STORE=FALSE");
            config.setConnectionTimeout(5000L);
            this.db = new HikariDataSource(config);
            this.tablePrefix = Common.getInstance().getMainConfig().getString("System.Database.Prefix");
            this.accessTable = new AccessTable(this.tablePrefix);
            this.accountTable = new AccountTable(this.tablePrefix);
            this.balanceTable = new BalanceTable(this.tablePrefix);
            this.configTable = new ConfigTable(this.tablePrefix);
            this.currencyTable = new CurrencyTable(this.tablePrefix);
            this.exchangeTable = new ExchangeTable(this.tablePrefix);
            this.logTable = new LogTable(this.tablePrefix);
            this.worldGroupTable = new WorldGroupTable(this.tablePrefix);
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement(this.accountTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.currencyTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.configTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.worldGroupTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.balanceTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.accessTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.exchangeTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                statement = connection.prepareStatement(this.logTable.createTableH2);
                statement.executeUpdate();
                statement.close();
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
        }
    }
}

