/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.currency;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.currency.Currency;
import java.util.List;
import java.util.Map;

public class CurrencyManager {
    private static Currency defaultCurrency;
    private static Currency defaultBankCurrency;
    private final Map<String, Currency> currencyList = Common.getInstance().getStorageHandler().getStorageEngine().getAllCurrencies();

    public CurrencyManager() {
        for (Map.Entry<String, Currency> currencyEntry : this.currencyList.entrySet()) {
            if (currencyEntry.getValue().getStatus()) {
                defaultCurrency = currencyEntry.getValue();
            }
            if (!currencyEntry.getValue().isPrimaryBankCurrency()) continue;
            defaultBankCurrency = currencyEntry.getValue();
        }
        Common.getInstance().addMetricsGraph("NumberCurrency", this.currencyList.size() + "");
    }

    public Currency getCurrency(String name) {
        Currency result;
        if (!this.currencyList.containsKey(name)) {
            result = Common.getInstance().getStorageHandler().getStorageEngine().getCurrency(name);
            if (result != null) {
                this.currencyList.put(result.getName(), result);
            }
        } else {
            result = this.currencyList.get(name);
        }
        return result;
    }

    public List<String> getCurrencyNames() {
        return Common.getInstance().getStorageHandler().getStorageEngine().getAllCurrencyNames();
    }

    public Currency addCurrency(String name, String plural, String minor, String minorPlural, String sign, boolean save) {
        return this.addCurrency(name, plural, minor, minorPlural, sign, save, false);
    }

    private Currency addCurrency(String name, String plural, String minor, String minorPlural, String sign, boolean save, boolean status) {
        Currency currency = new Currency(name, plural, minor, minorPlural, sign, status);
        if (save) {
            Common.getInstance().getStorageHandler().getStorageEngine().saveCurrency(name, currency);
        }
        this.currencyList.put(currency.getName(), currency);
        return currency;
    }

    public void setDefault(Currency currency) {
        if (this.currencyList.containsKey(currency.getName())) {
            Common.getInstance().getStorageHandler().getStorageEngine().setDefaultCurrency(currency);
            defaultCurrency = currency;
            currency.setDefault(true);
            for (Map.Entry<String, Currency> currencyEntry : this.currencyList.entrySet()) {
                if (currencyEntry.getValue().equals(currency)) continue;
                currency.setDefault(false);
            }
        }
    }

    public void deleteCurrency(Currency currency) {
        if (this.currencyList.containsKey(currency.getName())) {
            Common.getInstance().getStorageHandler().getStorageEngine().deleteCurrency(currency);
            this.currencyList.remove(currency.getName());
        }
    }

    public Currency getDefaultCurrency() {
        return defaultCurrency;
    }

    protected void updateEntry(String oldName, Currency currency) {
        this.currencyList.remove(oldName);
        this.currencyList.put(currency.getName(), currency);
    }

    public void setDefaultBankCurrency(Currency currency) {
        if (this.currencyList.containsKey(currency.getName())) {
            Common.getInstance().getStorageHandler().getStorageEngine().setDefaultBankCurrency(currency);
            defaultBankCurrency = currency;
            currency.setBankCurrency(true);
            for (Map.Entry<String, Currency> currencyEntry : this.currencyList.entrySet()) {
                if (currencyEntry.getValue().equals(currency)) continue;
                currency.setBankCurrency(false);
            }
        }
    }

    public Currency getDefaultBankCurrency() {
        return defaultBankCurrency;
    }
}

