/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.converter.converters;

import com.greatmancode.com.zaxxer.hikari.HikariConfig;
import com.greatmancode.com.zaxxer.hikari.HikariDataSource;
import com.greatmancode.craftconomy3.converter.Converter;
import com.greatmancode.craftconomy3.tools.utils.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Mineconomy
extends Converter {
    private HikariDataSource db;

    public Mineconomy() {
        this.getDbTypes().add("flatfile");
        this.getDbTypes().add("mysql");
    }

    @Override
    public List<String> getDbInfo() {
        if (this.getDbInfoList().size() == 0 && "mysql".equals(this.getSelectedDbType())) {
            this.getDbInfoList().add("address");
            this.getDbInfoList().add("port");
            this.getDbInfoList().add("username");
            this.getDbInfoList().add("password");
            this.getDbInfoList().add("database");
        }
        return this.getDbInfoList();
    }

    @Override
    public boolean connect() {
        boolean result = false;
        if (!"flatfile".equals(this.getSelectedDbType()) && "mysql".equals(this.getSelectedDbType())) {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(10);
            config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
            config.addDataSourceProperty("serverName", this.getDbConnectInfo().get("address"));
            config.addDataSourceProperty("port", this.getDbConnectInfo().get("port"));
            config.addDataSourceProperty("databaseName", this.getDbConnectInfo().get("database"));
            config.addDataSourceProperty("user", this.getDbConnectInfo().get("username"));
            config.addDataSourceProperty("password", this.getDbConnectInfo().get("password"));
            config.addDataSourceProperty("autoDeserialize", true);
            this.db = new HikariDataSource(config);
        }
        return result;
    }

    @Override
    public String getWarning() {
        return "Multi-currency support of Mineconomy currently not supported. Flatfile also not currently supported";
    }

    @Override
    public boolean importData(String sender) {
        List<Converter.User> userList = "flatfile".equals(this.getSelectedDbType()) ? this.importFlatfile(sender) : this.importMySQL(sender);
        this.addAccountToString(sender, userList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Converter.User> importMySQL(String sender) {
        block6: {
            ArrayList<Converter.User> arrayList;
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = this.db.getConnection();
                statement = connection.prepareStatement("SELECT * FROM mineconomy_accounts");
                ResultSet set = statement.executeQuery();
                ArrayList<Converter.User> userList = new ArrayList<Converter.User>();
                while (set.next()) {
                    userList.add(new Converter.User(set.getString("account"), set.getDouble("balance")));
                }
                arrayList = userList;
                Tools.closeJDBCStatement(statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Tools.closeJDBCStatement(statement);
                Tools.closeJDBCConnection(connection);
            }
            Tools.closeJDBCConnection(connection);
            return arrayList;
        }
        return null;
    }

    private List<Converter.User> importFlatfile(String sender) {
        return null;
    }
}

