/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.craftconomy3.commands.setup;

import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.DisplayFormat;
import com.greatmancode.craftconomy3.NewSetupWizard;
import com.greatmancode.craftconomy3.tools.commands.interfaces.CommandExecutor;
import com.greatmancode.craftconomy3.tools.utils.Tools;

public class NewSetupBasicCommand
extends CommandExecutor {
    private INTERNALSTEP step = INTERNALSTEP.START;

    @Override
    public void execute(String sender, String[] args) {
        if (NewSetupWizard.getState().equals((Object)NewSetupWizard.BASIC_STEP)) {
            if (this.step.equals((Object)INTERNALSTEP.START)) {
                this.start(sender);
            } else if (this.step.equals((Object)INTERNALSTEP.DEFAULT_MONEY)) {
                this.defaultMoney(sender, args);
            } else if (this.step.equals((Object)INTERNALSTEP.BANK_PRICE)) {
                this.bankMoney(sender, args);
            } else if (this.step.equals((Object)INTERNALSTEP.FORMAT)) {
                this.format(sender, args);
            }
        }
    }

    @Override
    public String help() {
        return "/ccsetup basic - Basic command of the setup wizard.";
    }

    @Override
    public int maxArgs() {
        return 1;
    }

    @Override
    public int minArgs() {
        return 0;
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    @Override
    public String getPermissionNode() {
        return "craftconomy.setup";
    }

    private void format(String sender, String[] args) {
        if (args.length == 1) {
            try {
                DisplayFormat format = DisplayFormat.valueOf(args[0].toUpperCase());
                Common.getInstance().getStorageHandler().getStorageEngine().setConfigEntry("longmode", format.toString());
                NewSetupWizard.setState(NewSetupWizard.CONVERT_STEP);
                Common.getInstance().loadDefaultSettings();
                Common.getInstance().startUp();
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_GREEN}}Only 1 step left! Do you want to convert from another system? Type {{WHITE}} /ccsetup convert yes {{DARK_GREEN}}or {{WHITE}}/ccsetup convert no");
            }
            catch (IllegalArgumentException e) {
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}This display format doesn't exist! Please type {{WHITE}}/ccsetup basic <format>");
            }
        }
    }

    private void bankMoney(String sender, String[] args) {
        if (args.length == 1) {
            if (Tools.isValidDouble(args[0])) {
                Common.getInstance().getStorageHandler().getStorageEngine().setConfigEntry("bankprice", args[0]);
                this.step = INTERNALSTEP.FORMAT;
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_GREEN}}Now, let's select the display format you want the balance to be shown. Craftconomy have {{WHITE}}4 {{DARK_GREEN}} display formats");
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{WHITE}}Long{{DARK_GREEN}}: {{WHITE}}40 Dollars 1 Coin");
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{WHITE}}Small{{DARK_GREEN}}: {{WHITE}} 40.1 Dollars");
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{WHITE}}Sign{{DARK_GREEN}}: {{WHITE}} $40.1");
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{WHITE}}MajorOnly{{DARK_GREEN}}: {{WHITE}}40 Dollars");
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_GREEN}}Please type {{WHITE}}/ccsetup basic <format>");
            } else {
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}Invalid amount! Please type {{WHITE}}/ccsetup basic <amount>");
            }
        } else {
            Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}You need to enter a amount of money! Please type {{WHITE}}/ccsetup basic <amount>");
        }
    }

    private void defaultMoney(String sender, String[] args) {
        if (args.length == 1) {
            if (Tools.isValidDouble(args[0])) {
                Common.getInstance().getStorageHandler().getStorageEngine().setConfigEntry("holdings", args[0]);
                this.step = INTERNALSTEP.BANK_PRICE;
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_GREEN}}How much do you want your players to pay for a {{WHITE}}bank account{{DARK_GREEN}}? Please type {{WHITE}}/ccsetup basic <amount>");
            } else {
                Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}Invalid amount! Please type {{WHITE}}/ccsetup basic <amount>");
            }
        } else {
            Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_RED}}You need to enter a amount of money! Please type {{WHITE}}/ccsetup basic <amount>");
        }
    }

    private void start(String sender) {
        Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_GREEN}}Basic setup. In this step, you will configure the basic settings of Craftconomy.");
        Common.getInstance().getServerCaller().getPlayerCaller().sendMessage(sender, "{{DARK_GREEN}}How much money you want your players to have initially? Please type {{WHITE}}/ccsetup basic <amount>");
        this.step = INTERNALSTEP.DEFAULT_MONEY;
    }

    private static enum INTERNALSTEP {
        DEFAULT_MONEY,
        BANK_PRICE,
        FORMAT,
        START;

    }
}

