/*
 * Decompiled with CFR 0.152.
 */
package com.greatmancode.com.zaxxer.hikari.util;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;

public final class PoolUtilities {
    public static final boolean IS_JAVA7;

    public static void quietlyCloseConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                return;
            }
        }
    }

    public static long elapsedTimeMs(long start) {
        return System.currentTimeMillis() - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlAutoCommit(Connection connection, String sql) throws SQLException {
        if (sql != null) {
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            try {
                statement.execute(sql);
            }
            finally {
                statement.close();
            }
        }
    }

    public static void quietlySleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstance(String className, Class<T> clazz, Object ... args) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> loaded = PoolUtilities.class.getClassLoader().loadClass(className);
            Class[] argClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argClasses[i] = args[i].getClass();
            }
            if (args.length > 0) {
                Constructor<?> constructor = loaded.getConstructor(argClasses);
                return (T)constructor.newInstance(args);
            }
            return (T)loaded.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int queueSize, final String threadName) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadName);
                t.setDaemon(true);
                return t;
            }
        };
        int processors = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(processors, processors, 2L, TimeUnit.SECONDS, queue, threadFactory, new ThreadPoolExecutor.DiscardPolicy());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    static {
        boolean b = false;
        try {
            b = AbstractQueuedLongSynchronizer.class.getMethod("hasQueuedPredecessors", new Class[0]) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_JAVA7 = b;
    }
}

