/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.CacheMap;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DispatchResult;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.Try;
import org.dataloader.ValueCache;
import org.dataloader.annotations.GuardedBy;
import org.dataloader.annotations.Internal;
import org.dataloader.impl.Assertions;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.stats.StatisticsCollector;

@Internal
class DataLoaderHelper<K, V> {
    private final DataLoader<K, V> dataLoader;
    private final Object batchLoadFunction;
    private final DataLoaderOptions loaderOptions;
    private final CacheMap<Object, V> futureCache;
    private final ValueCache<K, V> valueCache;
    private final List<LoaderQueueEntry<K, CompletableFuture<V>>> loaderQueue;
    private final StatisticsCollector stats;
    private final Clock clock;
    private final AtomicReference<Instant> lastDispatchTime;
    private final List<Try<V>> NOT_SUPPORTED_LIST = Collections.emptyList();
    private final CompletableFuture<List<Try<V>>> NOT_SUPPORTED = CompletableFuture.completedFuture(this.NOT_SUPPORTED_LIST);
    private final Try<V> ALWAYS_FAILED = Try.alwaysFailed();

    DataLoaderHelper(DataLoader<K, V> dataLoader, Object batchLoadFunction, DataLoaderOptions loaderOptions, CacheMap<Object, V> futureCache, ValueCache<K, V> valueCache, StatisticsCollector stats, Clock clock) {
        this.dataLoader = dataLoader;
        this.batchLoadFunction = batchLoadFunction;
        this.loaderOptions = loaderOptions;
        this.futureCache = futureCache;
        this.valueCache = valueCache;
        this.loaderQueue = new ArrayList<LoaderQueueEntry<K, CompletableFuture<V>>>();
        this.stats = stats;
        this.clock = clock;
        this.lastDispatchTime = new AtomicReference();
        this.lastDispatchTime.set(this.now());
    }

    Instant now() {
        return this.clock.instant();
    }

    public Instant getLastDispatchTime() {
        return this.lastDispatchTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CompletableFuture<V>> getIfPresent(K key) {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            Object cacheKey;
            boolean cachingEnabled = this.loaderOptions.cachingEnabled();
            if (cachingEnabled && this.futureCache.containsKey(cacheKey = this.getCacheKey(Assertions.nonNull(key)))) {
                this.stats.incrementCacheHitCount();
                return Optional.of(this.futureCache.get(cacheKey));
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CompletableFuture<V>> getIfCompleted(K key) {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            CompletableFuture<V> promise;
            Optional<CompletableFuture<V>> cachedPromise = this.getIfPresent(key);
            if (cachedPromise.isPresent() && (promise = cachedPromise.get()).isDone()) {
                return cachedPromise;
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<V> load(K key, Object loadContext) {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            boolean batchingEnabled = this.loaderOptions.batchingEnabled();
            boolean cachingEnabled = this.loaderOptions.cachingEnabled();
            this.stats.incrementLoadCount();
            if (cachingEnabled) {
                return this.loadFromCache(key, loadContext, batchingEnabled);
            }
            return this.queueOrInvokeLoader(key, loadContext, batchingEnabled, false);
        }
    }

    Object getCacheKey(K key) {
        return this.loaderOptions.cacheKeyFunction().isPresent() ? this.loaderOptions.cacheKeyFunction().get().getKey(key) : key;
    }

    Object getCacheKeyWithContext(K key, Object context) {
        return this.loaderOptions.cacheKeyFunction().isPresent() ? this.loaderOptions.cacheKeyFunction().get().getKeyWithContext(key, context) : key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DispatchResult<V> dispatch() {
        boolean batchingEnabled = this.loaderOptions.batchingEnabled();
        ArrayList keys = new ArrayList();
        ArrayList<Object> callContexts = new ArrayList<Object>();
        ArrayList queuedFutures = new ArrayList();
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            this.loaderQueue.forEach(entry -> {
                keys.add(entry.getKey());
                queuedFutures.add((CompletableFuture)entry.getValue());
                callContexts.add(entry.getCallContext());
            });
            this.loaderQueue.clear();
            this.lastDispatchTime.set(this.now());
        }
        if (!batchingEnabled || keys.isEmpty()) {
            return new DispatchResult(CompletableFuture.completedFuture(Collections.emptyList()), 0);
        }
        int totalEntriesHandled = keys.size();
        int maxBatchSize = this.loaderOptions.maxBatchSize();
        CompletableFuture<List<Object>> futureList = maxBatchSize > 0 && maxBatchSize < keys.size() ? this.sliceIntoBatchesOfBatches(keys, queuedFutures, callContexts, maxBatchSize) : this.dispatchQueueBatch(keys, callContexts, queuedFutures);
        return new DispatchResult(futureList, totalEntriesHandled);
    }

    private CompletableFuture<List<V>> sliceIntoBatchesOfBatches(List<K> keys, List<CompletableFuture<V>> queuedFutures, List<Object> callContexts, int maxBatchSize) {
        ArrayList allBatches = new ArrayList();
        int len = keys.size();
        int batchCount = (int)Math.ceil((double)len / (double)maxBatchSize);
        for (int i = 0; i < batchCount; ++i) {
            int fromIndex = i * maxBatchSize;
            int toIndex = Math.min((i + 1) * maxBatchSize, len);
            List<K> subKeys = keys.subList(fromIndex, toIndex);
            List<CompletableFuture<V>> subFutures = queuedFutures.subList(fromIndex, toIndex);
            List<Object> subCallContexts = callContexts.subList(fromIndex, toIndex);
            allBatches.add(this.dispatchQueueBatch(subKeys, subCallContexts, subFutures));
        }
        return CompletableFuture.allOf(allBatches.toArray(new CompletableFuture[0])).thenApply(v -> allBatches.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private CompletableFuture<List<V>> dispatchQueueBatch(List<K> keys, List<Object> callContexts, List<CompletableFuture<V>> queuedFutures) {
        this.stats.incrementBatchLoadCountBy(keys.size());
        CompletableFuture<List<V>> batchLoad = this.invokeLoader(keys, callContexts, this.loaderOptions.cachingEnabled());
        return ((CompletableFuture)batchLoad.thenApply(values -> {
            this.assertResultSize(keys, (List<V>)values);
            ArrayList clearCacheKeys = new ArrayList();
            for (int idx = 0; idx < queuedFutures.size(); ++idx) {
                Object value = values.get(idx);
                CompletableFuture future = (CompletableFuture)queuedFutures.get(idx);
                if (value instanceof Throwable) {
                    this.stats.incrementLoadErrorCount();
                    future.completeExceptionally((Throwable)value);
                    clearCacheKeys.add(keys.get(idx));
                    continue;
                }
                if (value instanceof Try) {
                    Try tryValue = (Try)value;
                    if (tryValue.isSuccess()) {
                        future.complete(tryValue.get());
                        continue;
                    }
                    this.stats.incrementLoadErrorCount();
                    future.completeExceptionally(tryValue.getThrowable());
                    clearCacheKeys.add(keys.get(idx));
                    continue;
                }
                future.complete(value);
            }
            this.possiblyClearCacheEntriesOnExceptions(clearCacheKeys);
            return values;
        })).exceptionally(ex -> {
            this.stats.incrementBatchLoadExceptionCount();
            if (ex instanceof CompletionException) {
                ex = ex.getCause();
            }
            for (int idx = 0; idx < queuedFutures.size(); ++idx) {
                Object key = keys.get(idx);
                CompletableFuture future = (CompletableFuture)queuedFutures.get(idx);
                future.completeExceptionally((Throwable)ex);
                this.dataLoader.clear(key);
            }
            return Collections.emptyList();
        });
    }

    private void assertResultSize(List<K> keys, List<V> values) {
        Assertions.assertState(keys.size() == values.size(), () -> "The size of the promised values MUST be the same size as the key list");
    }

    private void possiblyClearCacheEntriesOnExceptions(List<K> keys) {
        if (keys.isEmpty()) {
            return;
        }
        if (!this.loaderOptions.cachingExceptionsEnabled()) {
            keys.forEach(this.dataLoader::clear);
        }
    }

    @GuardedBy(value="dataLoader")
    private CompletableFuture<V> loadFromCache(K key, Object loadContext, boolean batchingEnabled) {
        Object cacheKey;
        Object object = cacheKey = loadContext == null ? this.getCacheKey(key) : this.getCacheKeyWithContext(key, loadContext);
        if (this.futureCache.containsKey(cacheKey)) {
            this.stats.incrementCacheHitCount();
            return this.futureCache.get(cacheKey);
        }
        CompletableFuture<V> loadCallFuture = this.queueOrInvokeLoader(key, loadContext, batchingEnabled, true);
        this.futureCache.set(cacheKey, loadCallFuture);
        return loadCallFuture;
    }

    @GuardedBy(value="dataLoader")
    private CompletableFuture<V> queueOrInvokeLoader(K key, Object loadContext, boolean batchingEnabled, boolean cachingEnabled) {
        if (batchingEnabled) {
            CompletableFuture loadCallFuture = new CompletableFuture();
            this.loaderQueue.add(new LoaderQueueEntry(key, loadCallFuture, loadContext));
            return loadCallFuture;
        }
        this.stats.incrementBatchLoadCountBy(1L);
        return this.invokeLoaderImmediately(key, loadContext, cachingEnabled);
    }

    CompletableFuture<V> invokeLoaderImmediately(K key, Object keyContext, boolean cachingEnabled) {
        List<K> keys = Collections.singletonList(key);
        List<Object> keyContexts = Collections.singletonList(keyContext);
        return ((CompletableFuture)this.invokeLoader(keys, keyContexts, cachingEnabled).thenApply(list -> list.get(0))).toCompletableFuture();
    }

    CompletableFuture<List<V>> invokeLoader(List<K> keys, List<Object> keyContexts, boolean cachingEnabled) {
        if (!cachingEnabled) {
            return this.invokeLoader(keys, keyContexts);
        }
        CompletableFuture<List<Try<V>>> cacheCallCF = this.getFromValueCache(keys);
        return cacheCallCF.thenCompose(cachedValues -> {
            int i;
            ArrayList<Try> valuesInKeyOrder = new ArrayList<Try>();
            ArrayList<Integer> missedKeyIndexes = new ArrayList<Integer>();
            ArrayList missedKeys = new ArrayList();
            ArrayList<Object> missedKeyContexts = new ArrayList<Object>();
            if (cachedValues == this.NOT_SUPPORTED_LIST) {
                for (i = 0; i < keys.size(); ++i) {
                    valuesInKeyOrder.add(this.ALWAYS_FAILED);
                    missedKeyIndexes.add(i);
                    missedKeys.add(keys.get(i));
                    missedKeyContexts.add(keyContexts.get(i));
                }
            } else {
                Assertions.assertState(keys.size() == cachedValues.size(), () -> "The size of the cached values MUST be the same size as the key list");
                for (i = 0; i < keys.size(); ++i) {
                    Try cacheGet = (Try)cachedValues.get(i);
                    valuesInKeyOrder.add(cacheGet);
                    if (!cacheGet.isFailure()) continue;
                    missedKeyIndexes.add(i);
                    missedKeys.add(keys.get(i));
                    missedKeyContexts.add(keyContexts.get(i));
                }
            }
            if (missedKeys.isEmpty()) {
                List assembledValues = valuesInKeyOrder.stream().map(Try::get).collect(Collectors.toList());
                return CompletableFuture.completedFuture(assembledValues);
            }
            CompletableFuture<List<V>> batchLoad = this.invokeLoader(missedKeys, missedKeyContexts);
            return batchLoad.thenCompose(missedValues -> {
                this.assertResultSize(missedKeys, (List<V>)missedValues);
                for (int i = 0; i < missedValues.size(); ++i) {
                    Object v = missedValues.get(i);
                    Integer listIndex = (Integer)missedKeyIndexes.get(i);
                    valuesInKeyOrder.set(listIndex, Try.succeeded(v));
                }
                List assembledValues = valuesInKeyOrder.stream().map(Try::get).collect(Collectors.toList());
                return this.setToValueCache(assembledValues, missedKeys, (List<V>)missedValues);
            });
        });
    }

    CompletableFuture<List<V>> invokeLoader(List<K> keys, List<Object> keyContexts) {
        CompletableFuture<List<V>> batchLoad;
        try {
            Object context = this.loaderOptions.getBatchLoaderContextProvider().getContext();
            BatchLoaderEnvironment environment = BatchLoaderEnvironment.newBatchLoaderEnvironment().context(context).keyContexts(keys, keyContexts).build();
            batchLoad = this.isMapLoader() ? this.invokeMapBatchLoader(keys, environment) : this.invokeListBatchLoader(keys, environment);
        }
        catch (Exception e) {
            batchLoad = CompletableFutureKit.failedFuture(e);
        }
        return batchLoad;
    }

    private CompletableFuture<List<V>> invokeListBatchLoader(List<K> keys, BatchLoaderEnvironment environment) {
        CompletionStage loadResult = this.batchLoadFunction instanceof BatchLoaderWithContext ? ((BatchLoaderWithContext)this.batchLoadFunction).load(keys, environment) : ((BatchLoader)this.batchLoadFunction).load(keys);
        return Assertions.nonNull(loadResult, () -> "Your batch loader function MUST return a non null CompletionStage").toCompletableFuture();
    }

    private CompletableFuture<List<V>> invokeMapBatchLoader(List<K> keys, BatchLoaderEnvironment environment) {
        LinkedHashSet<K> setOfKeys = new LinkedHashSet<K>(keys);
        CompletionStage loadResult = this.batchLoadFunction instanceof MappedBatchLoaderWithContext ? ((MappedBatchLoaderWithContext)this.batchLoadFunction).load(setOfKeys, environment) : ((MappedBatchLoader)this.batchLoadFunction).load(setOfKeys);
        CompletableFuture mapBatchLoad = Assertions.nonNull(loadResult, () -> "Your batch loader function MUST return a non null CompletionStage").toCompletableFuture();
        return mapBatchLoad.thenApply(map -> {
            ArrayList values = new ArrayList();
            for (Object key : keys) {
                Object value = map.get(key);
                values.add(value);
            }
            return values;
        });
    }

    private boolean isMapLoader() {
        return this.batchLoadFunction instanceof MappedBatchLoader || this.batchLoadFunction instanceof MappedBatchLoaderWithContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int dispatchDepth() {
        DataLoader<K, V> dataLoader = this.dataLoader;
        synchronized (dataLoader) {
            return this.loaderQueue.size();
        }
    }

    private CompletableFuture<List<Try<V>>> getFromValueCache(List<K> keys) {
        try {
            return Assertions.nonNull(this.valueCache.getValues(keys), () -> "Your ValueCache.getValues function MUST return a non null CompletableFuture");
        }
        catch (ValueCache.ValueCachingNotSupported ignored) {
            return this.NOT_SUPPORTED;
        }
        catch (RuntimeException e) {
            return CompletableFutureKit.failedFuture(e);
        }
    }

    private CompletableFuture<List<V>> setToValueCache(List<V> assembledValues, List<K> missedKeys, List<V> missedValues) {
        try {
            boolean completeValueAfterCacheSet = this.loaderOptions.getValueCacheOptions().isCompleteValueAfterCacheSet();
            if (completeValueAfterCacheSet) {
                return Assertions.nonNull(this.valueCache.setValues(missedKeys, missedValues), () -> "Your ValueCache.setValues function MUST return a non null CompletableFuture").handle((ignored, setExIgnored) -> assembledValues);
            }
            this.valueCache.setValues(missedKeys, missedValues);
        }
        catch (ValueCache.ValueCachingNotSupported valueCachingNotSupported) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(assembledValues);
    }

    static class LoaderQueueEntry<K, V> {
        final K key;
        final V value;
        final Object callContext;

        public LoaderQueueEntry(K key, V value, Object callContext) {
            this.key = key;
            this.value = value;
            this.callContext = callContext;
        }

        K getKey() {
            return this.key;
        }

        V getValue() {
            return this.value;
        }

        Object getCallContext() {
            return this.callContext;
        }
    }
}

