/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.CacheMap;
import org.dataloader.DataLoaderHelper;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DispatchResult;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.Try;
import org.dataloader.annotations.PublicApi;
import org.dataloader.annotations.VisibleForTesting;
import org.dataloader.impl.Assertions;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;

@PublicApi
public class DataLoader<K, V> {
    private final DataLoaderHelper<K, V> helper;
    private final CacheMap<Object, CompletableFuture<V>> futureCache;
    private final StatisticsCollector stats;

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction) {
        return DataLoader.newDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, V>(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoader.newDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, Try<V>>(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoader.newDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, V>(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoader.newDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, V>(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction) {
        return DataLoader.newMappedDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, V>(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoader.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, V>(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoader.newMappedDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, V>(batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoader.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return new DataLoader<K, V>(batchLoadFunction, options);
    }

    public DataLoader(BatchLoader<K, V> batchLoadFunction) {
        this(batchLoadFunction, null);
    }

    public DataLoader(BatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        this((Object)batchLoadFunction, options);
    }

    private DataLoader(Object batchLoadFunction, DataLoaderOptions options) {
        DataLoaderOptions loaderOptions = options == null ? new DataLoaderOptions() : options;
        this.futureCache = this.determineCacheMap(loaderOptions);
        this.stats = Assertions.nonNull(loaderOptions.getStatisticsCollector());
        this.helper = new DataLoaderHelper(this, batchLoadFunction, loaderOptions, this.futureCache, this.stats, this.clock());
    }

    @VisibleForTesting
    Clock clock() {
        return Clock.systemUTC();
    }

    private CacheMap<Object, CompletableFuture<V>> determineCacheMap(DataLoaderOptions loaderOptions) {
        return loaderOptions.cacheMap().isPresent() ? loaderOptions.cacheMap().get() : CacheMap.simpleMap();
    }

    public Instant getLastDispatchTime() {
        return this.helper.getLastDispatchTime();
    }

    public CompletableFuture<V> load(K key) {
        return this.load(key, null);
    }

    public Optional<CompletableFuture<V>> getIfPresent(K key) {
        return this.helper.getIfPresent(key);
    }

    public Optional<CompletableFuture<V>> getIfCompleted(K key) {
        return this.helper.getIfCompleted(key);
    }

    public CompletableFuture<V> load(K key, Object keyContext) {
        return this.helper.load(key, keyContext);
    }

    public CompletableFuture<List<V>> loadMany(List<K> keys) {
        return this.loadMany(keys, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<V>> loadMany(List<K> keys, List<Object> keyContexts) {
        Assertions.nonNull(keys);
        Assertions.nonNull(keyContexts);
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            ArrayList collect = new ArrayList();
            for (int i = 0; i < keys.size(); ++i) {
                K key = keys.get(i);
                Object keyContext = null;
                if (i < keyContexts.size()) {
                    keyContext = keyContexts.get(i);
                }
                collect.add(this.load(key, keyContext));
            }
            return CompletableFutureKit.allOf(collect);
        }
    }

    public CompletableFuture<List<V>> dispatch() {
        return this.helper.dispatch().getPromisedResults();
    }

    public DispatchResult<V> dispatchWithCounts() {
        return this.helper.dispatch();
    }

    public List<V> dispatchAndJoin() {
        List<V> joinedResults = this.dispatch().join();
        ArrayList<V> results = new ArrayList<V>(joinedResults);
        while (this.dispatchDepth() > 0) {
            joinedResults = this.dispatch().join();
            results.addAll(joinedResults);
        }
        return results;
    }

    public int dispatchDepth() {
        return this.helper.dispatchDepth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader<K, V> clear(K key) {
        Object cacheKey = this.getCacheKey(key);
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            this.futureCache.delete(cacheKey);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader<K, V> clearAll() {
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            this.futureCache.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader<K, V> prime(K key, V value) {
        Object cacheKey = this.getCacheKey(key);
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            if (!this.futureCache.containsKey(cacheKey)) {
                this.futureCache.set(cacheKey, CompletableFuture.completedFuture(value));
            }
        }
        return this;
    }

    public DataLoader<K, V> prime(K key, Exception error) {
        Object cacheKey = this.getCacheKey(key);
        if (!this.futureCache.containsKey(cacheKey)) {
            this.futureCache.set(cacheKey, CompletableFutureKit.failedFuture(error));
        }
        return this;
    }

    public Object getCacheKey(K key) {
        return this.helper.getCacheKey(key);
    }

    public Statistics getStatistics() {
        return this.stats.getStatistics();
    }
}

