/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.stats;

import org.dataloader.impl.Assertions;
import org.dataloader.stats.SimpleStatisticsCollector;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;
import org.dataloader.stats.context.IncrementBatchLoadCountByStatisticsContext;
import org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import org.dataloader.stats.context.IncrementCacheHitCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;

public class DelegatingStatisticsCollector
implements StatisticsCollector {
    private final StatisticsCollector collector = new SimpleStatisticsCollector();
    private final StatisticsCollector delegateCollector;

    public DelegatingStatisticsCollector(StatisticsCollector delegateCollector) {
        this.delegateCollector = Assertions.nonNull(delegateCollector);
    }

    @Override
    public <K> void incrementLoadCount(IncrementLoadCountStatisticsContext<K> context) {
        this.delegateCollector.incrementLoadCount(context);
        this.collector.incrementLoadCount(context);
    }

    @Override
    @Deprecated
    public void incrementLoadCount() {
        this.incrementLoadCount(null);
    }

    @Override
    public <K> void incrementLoadErrorCount(IncrementLoadErrorCountStatisticsContext<K> context) {
        this.delegateCollector.incrementLoadErrorCount(context);
        this.collector.incrementLoadErrorCount(context);
    }

    @Override
    @Deprecated
    public void incrementLoadErrorCount() {
        this.incrementLoadErrorCount(null);
    }

    @Override
    public <K> void incrementBatchLoadCountBy(long delta, IncrementBatchLoadCountByStatisticsContext<K> context) {
        this.delegateCollector.incrementBatchLoadCountBy(delta, context);
        this.collector.incrementBatchLoadCountBy(delta, context);
    }

    @Override
    @Deprecated
    public void incrementBatchLoadCountBy(long delta) {
        this.incrementBatchLoadCountBy(delta, null);
    }

    @Override
    public <K> void incrementBatchLoadExceptionCount(IncrementBatchLoadExceptionCountStatisticsContext<K> context) {
        this.delegateCollector.incrementBatchLoadExceptionCount(context);
        this.collector.incrementBatchLoadExceptionCount(context);
    }

    @Override
    @Deprecated
    public void incrementBatchLoadExceptionCount() {
        this.incrementBatchLoadExceptionCount(null);
    }

    @Override
    public <K> void incrementCacheHitCount(IncrementCacheHitCountStatisticsContext<K> context) {
        this.delegateCollector.incrementCacheHitCount(context);
        this.collector.incrementCacheHitCount(context);
    }

    @Override
    @Deprecated
    public void incrementCacheHitCount() {
        this.incrementCacheHitCount(null);
    }

    @Override
    public Statistics getStatistics() {
        return this.collector.getStatistics();
    }

    public Statistics getDelegateStatistics() {
        return this.delegateCollector.getStatistics();
    }
}

