/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.BatchPublisher;
import org.dataloader.BatchPublisherWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.MappedBatchPublisher;
import org.dataloader.MappedBatchPublisherWithContext;
import org.dataloader.Try;
import org.dataloader.annotations.PublicApi;
import org.dataloader.impl.Assertions;
import org.jspecify.annotations.Nullable;

@PublicApi
public class DataLoaderFactory {
    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction) {
        return DataLoaderFactory.newDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(String name, BatchLoader<K, V> batchLoadFunction) {
        return DataLoaderFactory.newDataLoader(name, batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(String name, BatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(String name, BatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoader(String name, BatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(String name, BatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction, @Nullable DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(String name, MappedBatchLoader<K, V> batchLoadFunction, @Nullable DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(String name, MappedBatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoader(String name, MappedBatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(String name, MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisher<K, V> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisher<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(String name, BatchPublisher<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisher<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisher<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(String name, BatchPublisher<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisherWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(BatchPublisherWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoader(String name, BatchPublisherWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisherWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(BatchPublisherWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newPublisherDataLoaderWithTry(String name, BatchPublisherWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisher<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisher<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(String name, MappedBatchPublisher<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisher<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisher<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(String name, MappedBatchPublisher<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisherWithContext<K, V> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoader(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(MappedBatchPublisherWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoader(String name, MappedBatchPublisherWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisherWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoaderFactory.newMappedPublisherDataLoaderWithTry(batchLoadFunction, null);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(MappedBatchPublisherWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(null, batchLoadFunction, options);
    }

    public static <K, V> DataLoader<K, V> newMappedPublisherDataLoaderWithTry(String name, MappedBatchPublisherWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(Assertions.nonNull(name), batchLoadFunction, options);
    }

    static <K, V> DataLoader<K, V> mkDataLoader(@Nullable String name, Object batchLoadFunction, @Nullable DataLoaderOptions options) {
        return new DataLoader(name, batchLoadFunction, options);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> builder(DataLoader<K, V> dataLoader) {
        return new Builder(dataLoader);
    }

    public static class Builder<K, V> {
        String name;
        Object batchLoadFunction;
        DataLoaderOptions options = DataLoaderOptions.newOptions();

        Builder() {
        }

        Builder(DataLoader<?, ?> dataLoader) {
            this.name = dataLoader.getName();
            this.batchLoadFunction = dataLoader.getBatchLoadFunction();
            this.options = dataLoader.getOptions();
        }

        public Builder<K, V> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<K, V> options(DataLoaderOptions options) {
            this.options = options;
            return this;
        }

        public Builder<K, V> batchLoadFunction(Object batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> batchLoader(BatchLoader<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> batchLoader(BatchLoaderWithContext<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> mappedBatchLoader(MappedBatchLoader<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> mappedBatchLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> publisherBatchLoader(BatchPublisher<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> publisherBatchLoader(BatchPublisherWithContext<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> mappedPublisherBatchLoader(MappedBatchPublisher<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public Builder<K, V> mappedPublisherBatchLoader(MappedBatchPublisherWithContext<K, V> batchLoadFunction) {
            this.batchLoadFunction = batchLoadFunction;
            return this;
        }

        public DataLoader<K, V> build() {
            return DataLoaderFactory.mkDataLoader(this.name, this.batchLoadFunction, this.options);
        }
    }
}

