/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.CacheMap;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderHelper;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DispatchResult;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.Try;
import org.dataloader.ValueCache;
import org.dataloader.annotations.PublicApi;
import org.dataloader.annotations.VisibleForTesting;
import org.dataloader.impl.Assertions;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.stats.Statistics;
import org.dataloader.stats.StatisticsCollector;

@PublicApi
public class DataLoader<K, V> {
    private final DataLoaderHelper<K, V> helper;
    private final StatisticsCollector stats;
    private final CacheMap<Object, V> futureCache;
    private final ValueCache<K, V> valueCache;

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction) {
        return DataLoader.newDataLoader(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoader.newDataLoaderWithTry(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoader.newDataLoader(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoader(BatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoader.newDataLoaderWithTry(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newDataLoaderWithTry(BatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction) {
        return DataLoader.newMappedDataLoader(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction) {
        return DataLoader.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoader<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction) {
        return DataLoader.newMappedDataLoader(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoader(MappedBatchLoaderWithContext<K, V> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction) {
        return DataLoader.newMappedDataLoaderWithTry(batchLoadFunction, null);
    }

    @Deprecated
    public static <K, V> DataLoader<K, V> newMappedDataLoaderWithTry(MappedBatchLoaderWithContext<K, Try<V>> batchLoadFunction, DataLoaderOptions options) {
        return DataLoaderFactory.mkDataLoader(batchLoadFunction, options);
    }

    @Deprecated
    public DataLoader(BatchLoader<K, V> batchLoadFunction) {
        this((Object)batchLoadFunction, null);
    }

    @Deprecated
    public DataLoader(BatchLoader<K, V> batchLoadFunction, DataLoaderOptions options) {
        this((Object)batchLoadFunction, options);
    }

    @VisibleForTesting
    DataLoader(Object batchLoadFunction, DataLoaderOptions options) {
        this(batchLoadFunction, options, Clock.systemUTC());
    }

    @VisibleForTesting
    DataLoader(Object batchLoadFunction, DataLoaderOptions options, Clock clock) {
        DataLoaderOptions loaderOptions = options == null ? new DataLoaderOptions() : options;
        this.futureCache = this.determineFutureCache(loaderOptions);
        this.valueCache = this.determineValueCache(loaderOptions);
        this.stats = Assertions.nonNull(loaderOptions.getStatisticsCollector());
        this.helper = new DataLoaderHelper<K, V>(this, batchLoadFunction, loaderOptions, this.futureCache, this.valueCache, this.stats, clock);
    }

    private CacheMap<Object, V> determineFutureCache(DataLoaderOptions loaderOptions) {
        return loaderOptions.cacheMap().orElseGet(CacheMap::simpleMap);
    }

    private ValueCache<K, V> determineValueCache(DataLoaderOptions loaderOptions) {
        return loaderOptions.valueCache().orElseGet(ValueCache::defaultValueCache);
    }

    public Instant getLastDispatchTime() {
        return this.helper.getLastDispatchTime();
    }

    public Duration getTimeSinceDispatch() {
        return Duration.between(this.helper.getLastDispatchTime(), this.helper.now());
    }

    public CompletableFuture<V> load(K key) {
        return this.load(key, null);
    }

    public Optional<CompletableFuture<V>> getIfPresent(K key) {
        return this.helper.getIfPresent(key);
    }

    public Optional<CompletableFuture<V>> getIfCompleted(K key) {
        return this.helper.getIfCompleted(key);
    }

    public CompletableFuture<V> load(K key, Object keyContext) {
        return this.helper.load(key, keyContext);
    }

    public CompletableFuture<List<V>> loadMany(List<K> keys) {
        return this.loadMany(keys, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<V>> loadMany(List<K> keys, List<Object> keyContexts) {
        Assertions.nonNull(keys);
        Assertions.nonNull(keyContexts);
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            ArrayList collect = new ArrayList(keys.size());
            for (int i = 0; i < keys.size(); ++i) {
                K key = keys.get(i);
                Object keyContext = null;
                if (i < keyContexts.size()) {
                    keyContext = keyContexts.get(i);
                }
                collect.add(this.load(key, keyContext));
            }
            return CompletableFutureKit.allOf(collect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Map<K, V>> loadMany(Map<K, ?> keysAndContexts) {
        Assertions.nonNull(keysAndContexts);
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            HashMap<K, CompletableFuture<V>> collect = new HashMap<K, CompletableFuture<V>>(keysAndContexts.size());
            for (Map.Entry<K, ?> entry : keysAndContexts.entrySet()) {
                K key = entry.getKey();
                Object keyContext = entry.getValue();
                collect.put(key, this.load(key, keyContext));
            }
            return CompletableFutureKit.allOf(collect);
        }
    }

    public CompletableFuture<List<V>> dispatch() {
        return this.helper.dispatch().getPromisedResults();
    }

    public DispatchResult<V> dispatchWithCounts() {
        return this.helper.dispatch();
    }

    public List<V> dispatchAndJoin() {
        List<V> joinedResults = this.dispatch().join();
        ArrayList<V> results = new ArrayList<V>(joinedResults);
        while (this.dispatchDepth() > 0) {
            joinedResults = this.dispatch().join();
            results.addAll(joinedResults);
        }
        return results;
    }

    public int dispatchDepth() {
        return this.helper.dispatchDepth();
    }

    public DataLoader<K, V> clear(K key) {
        return this.clear(key, (v, e) -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader<K, V> clear(K key, BiConsumer<Void, Throwable> handler) {
        Object cacheKey = this.getCacheKey(key);
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            this.futureCache.delete(cacheKey);
            this.valueCache.delete(key).whenComplete((BiConsumer)handler);
        }
        return this;
    }

    public DataLoader<K, V> clearAll() {
        return this.clearAll((v, e) -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader<K, V> clearAll(BiConsumer<Void, Throwable> handler) {
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            this.futureCache.clear();
            this.valueCache.clear().whenComplete((BiConsumer)handler);
        }
        return this;
    }

    public DataLoader<K, V> prime(K key, V value) {
        return this.prime(key, CompletableFuture.completedFuture(value));
    }

    public DataLoader<K, V> prime(K key, Exception error) {
        return this.prime(key, CompletableFutureKit.failedFuture(error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoader<K, V> prime(K key, CompletableFuture<V> value) {
        Object cacheKey = this.getCacheKey(key);
        DataLoader dataLoader = this;
        synchronized (dataLoader) {
            if (!this.futureCache.containsKey(cacheKey)) {
                this.futureCache.set(cacheKey, value);
            }
        }
        return this;
    }

    public Object getCacheKey(K key) {
        return this.helper.getCacheKey(key);
    }

    public Statistics getStatistics() {
        return this.stats.getStatistics();
    }

    public CacheMap<Object, V> getCacheMap() {
        return this.futureCache;
    }

    public ValueCache<K, V> getValueCache() {
        return this.valueCache;
    }
}

