/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.oembedler.moon.graphql.boot.GraphQLJavaToolsAutoConfiguration;
import com.oembedler.moon.graphql.boot.GraphQLServletProperties;
import com.oembedler.moon.graphql.boot.GraphQLWsServerEndpointRegistration;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import graphql.servlet.AbstractGraphQLHttpServlet;
import graphql.servlet.DefaultExecutionStrategyProvider;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLErrorHandler;
import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.GraphQLRootObjectBuilder;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.GraphQLWebsocketServlet;
import graphql.servlet.ObjectMapperConfigurer;
import graphql.servlet.SimpleGraphQLHttpServlet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.CorsRegistryWorkaround;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@ConditionalOnBean(value={GraphQLSchema.class})
@ConditionalOnProperty(value={"graphql.servlet.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={GraphQLJavaToolsAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLServletProperties.class})
public class GraphQLWebAutoConfiguration {
    public static final String QUERY_EXECUTION_STRATEGY = "queryExecutionStrategy";
    public static final String MUTATION_EXECUTION_STRATEGY = "mutationExecutionStrategy";
    public static final String SUBSCRIPTION_EXECUTION_STRATEGY = "subscriptionExecutionStrategy";
    @Autowired
    private GraphQLServletProperties graphQLServletProperties;
    @Value(value="${graphql.servlet.subscriptions.websocket.path:/subscriptions}")
    private String websocketPath;
    @Autowired(required=false)
    private List<GraphQLServletListener> listeners;
    @Autowired(required=false)
    private Instrumentation instrumentation;
    @Autowired(required=false)
    private GraphQLErrorHandler errorHandler;
    @Autowired(required=false)
    private Map<String, ExecutionStrategy> executionStrategies;
    @Autowired(required=false)
    private GraphQLContextBuilder contextBuilder;
    @Autowired(required=false)
    private GraphQLRootObjectBuilder graphQLRootObjectBuilder;
    @Autowired(required=false)
    private ObjectMapperConfigurer objectMapperConfigurer;
    @Autowired(required=false)
    private PreparsedDocumentProvider preparsedDocumentProvider;
    @Autowired(required=false)
    private MultipartConfigElement multipartConfigElement;

    @Bean
    @ConditionalOnClass(value={CorsFilter.class})
    @ConditionalOnProperty(value={"graphql.servlet.corsEnabled"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsConfigurer() {
        UrlBasedCorsConfigurationSource configurationSource = new UrlBasedCorsConfigurationSource();
        configurationSource.setCorsConfigurations(CorsRegistryWorkaround.getCorsConfiguration(this.graphQLServletProperties.getCorsMapping()));
        configurationSource.setAlwaysUseFullPath(true);
        return new CorsFilter((CorsConfigurationSource)configurationSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaProvider graphQLSchemaProvider(GraphQLSchema schema) {
        return new DefaultGraphQLSchemaProvider(schema);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecutionStrategyProvider executionStrategyProvider() {
        if (this.executionStrategies == null || this.executionStrategies.isEmpty()) {
            return new DefaultExecutionStrategyProvider((ExecutionStrategy)new AsyncExecutionStrategy(), null, (ExecutionStrategy)new SubscriptionExecutionStrategy());
        }
        if (this.executionStrategies.entrySet().size() == 1) {
            return new DefaultExecutionStrategyProvider((ExecutionStrategy)((Map.Entry)this.executionStrategies.entrySet().stream().findFirst().get()).getValue());
        }
        if (!this.executionStrategies.containsKey(QUERY_EXECUTION_STRATEGY)) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        if (this.executionStrategies.size() == 2 && !this.executionStrategies.containsKey(MUTATION_EXECUTION_STRATEGY) && !this.executionStrategies.containsKey(SUBSCRIPTION_EXECUTION_STRATEGY)) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        if (!(this.executionStrategies.size() < 3 || this.executionStrategies.containsKey(MUTATION_EXECUTION_STRATEGY) && this.executionStrategies.containsKey(SUBSCRIPTION_EXECUTION_STRATEGY))) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        return new DefaultExecutionStrategyProvider(this.executionStrategies.get(QUERY_EXECUTION_STRATEGY), this.executionStrategies.get(MUTATION_EXECUTION_STRATEGY), this.executionStrategies.get(SUBSCRIPTION_EXECUTION_STRATEGY));
    }

    private void throwIncorrectExecutionStrategyNameException() {
        throw new IllegalStateException(String.format("When defining more than one execution strategy, they must be named %s, %s, or %s", QUERY_EXECUTION_STRATEGY, MUTATION_EXECUTION_STRATEGY, SUBSCRIPTION_EXECUTION_STRATEGY));
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLInvocationInputFactory invocationInputFactory(GraphQLSchemaProvider schemaProvider) {
        GraphQLInvocationInputFactory.Builder builder = GraphQLInvocationInputFactory.newBuilder((GraphQLSchemaProvider)schemaProvider);
        if (this.graphQLRootObjectBuilder != null) {
            builder.withGraphQLRootObjectBuilder(this.graphQLRootObjectBuilder);
        }
        if (this.contextBuilder != null) {
            builder.withGraphQLContextBuilder(this.contextBuilder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLQueryInvoker queryInvoker(ExecutionStrategyProvider executionStrategyProvider) {
        GraphQLQueryInvoker.Builder builder = GraphQLQueryInvoker.newBuilder().withExecutionStrategyProvider(executionStrategyProvider);
        if (this.instrumentation != null) {
            builder.withInstrumentation(this.instrumentation);
        }
        if (this.preparsedDocumentProvider != null) {
            builder.withPreparsedDocumentProvider(this.preparsedDocumentProvider);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLObjectMapper graphQLObjectMapper() {
        GraphQLObjectMapper.Builder builder = GraphQLObjectMapper.newBuilder();
        if (this.errorHandler != null) {
            builder.withGraphQLErrorHandler(this.errorHandler);
        }
        if (this.objectMapperConfigurer != null) {
            builder.withObjectMapperConfigurer(this.objectMapperConfigurer);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public SimpleGraphQLHttpServlet graphQLHttpServlet(GraphQLInvocationInputFactory invocationInputFactory, GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper) {
        return SimpleGraphQLHttpServlet.newBuilder((GraphQLInvocationInputFactory)invocationInputFactory).withQueryInvoker(queryInvoker).withObjectMapper(graphQLObjectMapper).build();
    }

    @Bean
    public ServletRegistrationBean<AbstractGraphQLHttpServlet> graphQLServletRegistrationBean(AbstractGraphQLHttpServlet servlet) {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, new String[]{this.graphQLServletProperties.getServletMapping()});
        registration.setMultipartConfig(this.multipartConfigElement());
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLWebsocketServlet graphQLWebsocketServlet(GraphQLInvocationInputFactory invocationInputFactory, GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper) {
        return new GraphQLWebsocketServlet(queryInvoker, invocationInputFactory, graphQLObjectMapper);
    }

    @Bean
    public ServerEndpointRegistration serverEndpointRegistration(GraphQLWebsocketServlet servlet) {
        return new GraphQLWsServerEndpointRegistration(this.websocketPath, servlet);
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    private MultipartConfigElement multipartConfigElement() {
        return Optional.ofNullable(this.multipartConfigElement).orElse(new MultipartConfigElement(""));
    }
}

