/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.alias;

import graphql.Assert;
import graphql.Internal;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Map;

@Internal
public class AliasedScalar {
    private static GraphQLScalarType aliasedScalarImpl(String name, String description, final GraphQLScalarType aliasedScalar) {
        Assert.assertNotNull((Object)aliasedScalar);
        Coercing<Object, Object> coercing = new Coercing<Object, Object>(){

            public Object serialize(Object input) throws CoercingSerializeException {
                return aliasedScalar.getCoercing().serialize(input);
            }

            public Object parseValue(Object input) throws CoercingParseValueException {
                return aliasedScalar.getCoercing().parseValue(input);
            }

            public Object parseLiteral(Object input) throws CoercingParseLiteralException {
                return aliasedScalar.getCoercing().parseLiteral(input);
            }

            public Object parseLiteral(Object input, Map<String, Object> variables) throws CoercingParseLiteralException {
                Coercing c = aliasedScalar.getCoercing();
                return c.parseLiteral(input, variables);
            }

            public Value<?> valueToLiteral(Object input) {
                return aliasedScalar.getCoercing().valueToLiteral(input);
            }
        };
        return GraphQLScalarType.newScalar().name(name).description(description).coercing((Coercing)coercing).build();
    }

    public static class Builder {
        private String name;
        private String description;
        private GraphQLScalarType aliasedScalar;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder aliasedScalar(GraphQLScalarType aliasedScalar) {
            this.aliasedScalar = aliasedScalar;
            return this;
        }

        public GraphQLScalarType build() {
            Assert.assertNotNull((Object)this.name);
            return AliasedScalar.aliasedScalarImpl(this.name, this.description, this.aliasedScalar);
        }
    }
}

