/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.color.hex;

import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.awt.Color;
import java.util.function.Function;
import java.util.regex.Pattern;

public class HexColorCodeScalar {
    public static final GraphQLScalarType INSTANCE;

    static {
        Coercing<Color, String> coercing = new Coercing<Color, String>(){
            private final Pattern HEX_PATTERN = Pattern.compile("^(#([A-Fa-f0-9]{3,4}){1,2})$");

            public String serialize(Object input) throws CoercingSerializeException {
                boolean hasAlpha;
                Color color = this.parseColor(input, CoercingSerializeException::new);
                boolean bl = hasAlpha = color.getAlpha() != 255;
                if (hasAlpha) {
                    return String.format("#%02x%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                }
                return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
            }

            public Color parseValue(Object input) throws CoercingParseValueException {
                return this.parseColor(input, CoercingParseValueException::new);
            }

            public Color parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                String stringValue = ((StringValue)input).getValue();
                return this.parseColor(stringValue, CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }

            private Color parseColor(Object input, Function<String, RuntimeException> exceptionMaker) {
                Color result;
                if (input instanceof Color) {
                    result = (Color)input;
                } else if (input instanceof String) {
                    try {
                        String hex = (String)input;
                        if (!this.HEX_PATTERN.matcher(hex).matches()) {
                            throw new IllegalArgumentException("Invalid hex color code value : '" + String.valueOf(input) + "'.");
                        }
                        int i = Integer.decode(hex);
                        int inputLength = hex.length();
                        if (inputLength == 4) {
                            result = new Color((i >> 8 & 0xF) * 17, (i >> 4 & 0xF) * 17, (i & 0xF) * 17);
                        }
                        if (inputLength == 5) {
                            result = new Color((i >> 12 & 0xF) * 17, (i >> 8 & 0xF) * 17, (i >> 4 & 0xF) * 17, (i & 0xF) * 17);
                        }
                        if (inputLength == 7) {
                            result = new Color(i);
                        }
                        result = new Color(i >> 24 & 0xFF, i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
                    }
                    catch (IllegalArgumentException | NullPointerException ex) {
                        throw exceptionMaker.apply("Invalid hex color code value : '" + String.valueOf(input) + "'. because of : '" + ex.getMessage() + "'");
                    }
                } else {
                    throw exceptionMaker.apply("Expected a 'String' or 'Color' but was '" + Kit.typeName(input) + "'.");
                }
                return result;
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("HexColorCode").description("A field whose value is a hexadecimal color code: https://en.wikipedia.org/wiki/Web_colors.").coercing((Coercing)coercing).build();
    }
}

