/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.annotations.PublicApi;
import org.dataloader.instrumentation.ChainedDataLoaderInstrumentation;
import org.dataloader.instrumentation.DataLoaderInstrumentation;
import org.dataloader.instrumentation.DataLoaderInstrumentationHelper;
import org.dataloader.stats.Statistics;

@PublicApi
public class DataLoaderRegistry {
    protected final Map<String, DataLoader<?, ?>> dataLoaders;
    protected final DataLoaderInstrumentation instrumentation;

    public DataLoaderRegistry() {
        this(new ConcurrentHashMap(), null);
    }

    private DataLoaderRegistry(Builder builder) {
        this(builder.dataLoaders, builder.instrumentation);
    }

    protected DataLoaderRegistry(Map<String, DataLoader<?, ?>> dataLoaders, DataLoaderInstrumentation instrumentation) {
        this.dataLoaders = this.instrumentDLs(dataLoaders, instrumentation);
        this.instrumentation = instrumentation;
    }

    private Map<String, DataLoader<?, ?>> instrumentDLs(Map<String, DataLoader<?, ?>> incomingDataLoaders, DataLoaderInstrumentation registryInstrumentation) {
        ConcurrentHashMap dataLoaders = new ConcurrentHashMap(incomingDataLoaders);
        if (registryInstrumentation != null) {
            dataLoaders.replaceAll((k, existingDL) -> DataLoaderRegistry.instrumentDL(registryInstrumentation, existingDL));
        }
        return dataLoaders;
    }

    private static DataLoader<?, ?> instrumentDL(DataLoaderInstrumentation registryInstrumentation, DataLoader<?, ?> existingDL) {
        if (registryInstrumentation == null) {
            return existingDL;
        }
        DataLoaderOptions options = existingDL.getOptions();
        DataLoaderInstrumentation existingInstrumentation = options.getInstrumentation();
        if (existingInstrumentation != null) {
            if (existingInstrumentation == registryInstrumentation) {
                return existingDL;
            }
            if (existingInstrumentation == DataLoaderInstrumentationHelper.NOOP_INSTRUMENTATION) {
                return DataLoaderRegistry.mkInstrumentedDataLoader(existingDL, options, registryInstrumentation);
            }
            if (existingInstrumentation instanceof ChainedDataLoaderInstrumentation) {
                ChainedDataLoaderInstrumentation newInstrumentation = ((ChainedDataLoaderInstrumentation)existingInstrumentation).prepend(registryInstrumentation);
                return DataLoaderRegistry.mkInstrumentedDataLoader(existingDL, options, newInstrumentation);
            }
            ChainedDataLoaderInstrumentation newInstrumentation = new ChainedDataLoaderInstrumentation().add(registryInstrumentation).add(existingInstrumentation);
            return DataLoaderRegistry.mkInstrumentedDataLoader(existingDL, options, newInstrumentation);
        }
        return DataLoaderRegistry.mkInstrumentedDataLoader(existingDL, options, registryInstrumentation);
    }

    private static DataLoader<?, ?> mkInstrumentedDataLoader(DataLoader<?, ?> existingDL, DataLoaderOptions options, DataLoaderInstrumentation newInstrumentation) {
        return existingDL.transform(builder -> builder.options(DataLoaderRegistry.setInInstrumentation(options, newInstrumentation)));
    }

    private static DataLoaderOptions setInInstrumentation(DataLoaderOptions options, DataLoaderInstrumentation newInstrumentation) {
        return options.transform(optionsBuilder -> optionsBuilder.setInstrumentation(newInstrumentation));
    }

    public DataLoaderInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public DataLoaderRegistry register(String key, DataLoader<?, ?> dataLoader) {
        this.dataLoaders.put(key, DataLoaderRegistry.instrumentDL(this.instrumentation, dataLoader));
        return this;
    }

    public <K, V> DataLoader<K, V> computeIfAbsent(String key, Function<String, DataLoader<?, ?>> mappingFunction) {
        return this.dataLoaders.computeIfAbsent(key, (? super K k) -> {
            DataLoader dl = (DataLoader)mappingFunction.apply((String)k);
            return DataLoaderRegistry.instrumentDL(this.instrumentation, dl);
        });
    }

    public DataLoaderRegistry combine(DataLoaderRegistry registry) {
        DataLoaderRegistry combined = new DataLoaderRegistry();
        this.dataLoaders.forEach(combined::register);
        registry.dataLoaders.forEach(combined::register);
        return combined;
    }

    public List<DataLoader<?, ?>> getDataLoaders() {
        return new ArrayList(this.dataLoaders.values());
    }

    public Map<String, DataLoader<?, ?>> getDataLoadersMap() {
        return new LinkedHashMap(this.dataLoaders);
    }

    public DataLoaderRegistry unregister(String key) {
        this.dataLoaders.remove(key);
        return this;
    }

    public <K, V> DataLoader<K, V> getDataLoader(String key) {
        return this.dataLoaders.get(key);
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.dataLoaders.keySet());
    }

    public void dispatchAll() {
        this.getDataLoaders().forEach(DataLoader::dispatch);
    }

    public int dispatchAllWithCount() {
        int sum = 0;
        for (DataLoader<?, ?> dataLoader : this.getDataLoaders()) {
            sum += dataLoader.dispatchWithCounts().getKeysCount();
        }
        return sum;
    }

    public int dispatchDepth() {
        int totalDispatchDepth = 0;
        for (DataLoader<?, ?> dataLoader : this.getDataLoaders()) {
            totalDispatchDepth += dataLoader.dispatchDepth();
        }
        return totalDispatchDepth;
    }

    public Statistics getStatistics() {
        Statistics stats = new Statistics();
        for (DataLoader<?, ?> dataLoader : this.dataLoaders.values()) {
            stats = stats.combine(dataLoader.getStatistics());
        }
        return stats;
    }

    public static Builder newRegistry() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, DataLoader<?, ?>> dataLoaders = new HashMap();
        private DataLoaderInstrumentation instrumentation;

        public Builder register(String key, DataLoader<?, ?> dataLoader) {
            this.dataLoaders.put(key, dataLoader);
            return this;
        }

        public Builder registerAll(DataLoaderRegistry otherRegistry) {
            this.dataLoaders.putAll(otherRegistry.dataLoaders);
            return this;
        }

        public Builder instrumentation(DataLoaderInstrumentation instrumentation) {
            this.instrumentation = instrumentation;
            return this;
        }

        public DataLoaderRegistry build() {
            return new DataLoaderRegistry(this);
        }
    }
}

