/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphql.spring.boot.test.GraphQLResponse;
import com.graphql.spring.boot.test.RequestFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;

public class GraphQLTestTemplate {
    private final ResourceLoader resourceLoader;
    private final TestRestTemplate restTemplate;
    private final String graphqlMapping;
    private final ObjectMapper objectMapper;
    private final HttpHeaders headers = new HttpHeaders();

    public GraphQLTestTemplate(ResourceLoader resourceLoader, TestRestTemplate restTemplate, @Value(value="${graphql.servlet.mapping:/graphql}") String graphqlMapping, ObjectMapper objectMapper) {
        this.resourceLoader = resourceLoader;
        this.restTemplate = restTemplate;
        this.graphqlMapping = graphqlMapping;
        this.objectMapper = objectMapper;
    }

    private String createJsonQuery(String graphql, String operation, ObjectNode variables) throws JsonProcessingException {
        ObjectNode wrapper = this.objectMapper.createObjectNode();
        wrapper.put("query", graphql);
        if (Objects.nonNull(operation)) {
            wrapper.put("operationName", operation);
        }
        wrapper.set("variables", (JsonNode)variables);
        return this.objectMapper.writeValueAsString((Object)wrapper);
    }

    private String loadQuery(String location) throws IOException {
        Resource resource = this.resourceLoader.getResource("classpath:" + location);
        return this.loadResource(resource);
    }

    private String loadResource(Resource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public GraphQLTestTemplate withAdditionalHeader(String name, String ... value) {
        this.headers.addAll(name, Arrays.asList(value));
        return this;
    }

    public GraphQLTestTemplate withAdditionalHeaders(MultiValueMap<String, String> additionalHeaders) {
        this.headers.addAll(additionalHeaders);
        return this;
    }

    public GraphQLTestTemplate withBearerAuth(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.headers.setBearerAuth(token);
        return this;
    }

    public GraphQLTestTemplate withBasicAuth(@NonNull String username, @NonNull String password, @Nullable Charset charset) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.headers.setBasicAuth(username, password, charset);
        return this;
    }

    public GraphQLTestTemplate withBasicAuth(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.headers.setBasicAuth(username, password, null);
        return this;
    }

    public GraphQLTestTemplate withBasicAuth(@NonNull String encodedCredentials) {
        if (encodedCredentials == null) {
            throw new NullPointerException("encodedCredentials is marked non-null but is null");
        }
        this.headers.setBasicAuth(encodedCredentials);
        return this;
    }

    public GraphQLTestTemplate withHeaders(HttpHeaders newHeaders) {
        return this.withClearHeaders().withAdditionalHeaders((MultiValueMap<String, String>)newHeaders);
    }

    public GraphQLTestTemplate withClearHeaders() {
        this.headers.clear();
        return this;
    }

    public GraphQLResponse perform(String graphqlResource, ObjectNode variables) throws IOException {
        return this.perform(graphqlResource, null, variables, Collections.emptyList());
    }

    public GraphQLResponse perform(String graphqlResource, String operationName) throws IOException {
        return this.perform(graphqlResource, operationName, null, Collections.emptyList());
    }

    public GraphQLResponse perform(String graphqlResource, String operation, ObjectNode variables) throws IOException {
        return this.perform(graphqlResource, operation, variables, Collections.emptyList());
    }

    public GraphQLResponse perform(String graphqlResource, ObjectNode variables, List<String> fragmentResources) throws IOException {
        return this.perform(graphqlResource, null, variables, fragmentResources);
    }

    public GraphQLResponse perform(String graphqlResource, String operationName, ObjectNode variables, List<String> fragmentResources) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String fragmentResource : fragmentResources) {
            sb.append(this.loadQuery(fragmentResource));
        }
        String graphql = sb.append(this.loadQuery(graphqlResource)).toString();
        String payload = this.createJsonQuery(graphql, operationName, variables);
        return this.post(payload);
    }

    public GraphQLResponse postForResource(String graphqlResource) throws IOException {
        return this.perform(graphqlResource, null, null, Collections.emptyList());
    }

    public GraphQLResponse postForResource(String graphqlResource, List<String> fragmentResources) throws IOException {
        return this.perform(graphqlResource, null, null, fragmentResources);
    }

    public GraphQLResponse postMultipart(String query, String variables) {
        return this.postRequest(RequestFactory.forMultipart(query, variables, this.headers));
    }

    public GraphQLResponse post(String payload) {
        return this.postRequest(RequestFactory.forJson(payload, this.headers));
    }

    private GraphQLResponse postRequest(HttpEntity<Object> request) {
        ResponseEntity response = this.restTemplate.exchange(this.graphqlMapping, HttpMethod.POST, request, String.class, new Object[0]);
        return new GraphQLResponse((ResponseEntity<String>)response, this.objectMapper);
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

