/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryResult;
import graphql.kickstart.servlet.BatchedQueryResponseWriter;
import graphql.kickstart.servlet.ErrorQueryResponseWriter;
import graphql.kickstart.servlet.SingleAsynchronousQueryResponseWriter;
import graphql.kickstart.servlet.SingleQueryResponseWriter;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

interface QueryResponseWriter {
    public static QueryResponseWriter createWriter(GraphQLQueryResult result, GraphQLObjectMapper graphQLObjectMapper, long subscriptionTimeout) {
        Objects.requireNonNull(result, "GraphQL query result cannot be null");
        if (result.isBatched()) {
            return new BatchedQueryResponseWriter(result.getResults(), graphQLObjectMapper);
        }
        if (result.isAsynchronous()) {
            return new SingleAsynchronousQueryResponseWriter((ExecutionResult)result.getResult(), graphQLObjectMapper, subscriptionTimeout);
        }
        if (result.isError()) {
            return new ErrorQueryResponseWriter(result.getStatusCode(), result.getMessage());
        }
        return new SingleQueryResponseWriter((ExecutionResult)result.getResult(), graphQLObjectMapper);
    }

    public void write(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
}

