/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.schema.GraphQLSchema;
import graphql.servlet.DefaultGraphQLBatchExecutionHandlerFactory;
import graphql.servlet.DefaultGraphQLSchemaProvider;
import graphql.servlet.GraphQLBatchExecutionHandlerFactory;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.GraphQLRootObjectBuilder;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.internal.GraphQLThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class GraphQLConfiguration {
    private GraphQLInvocationInputFactory invocationInputFactory;
    private GraphQLQueryInvoker queryInvoker;
    private GraphQLObjectMapper objectMapper;
    private GraphQLBatchExecutionHandlerFactory batchExecutionHandlerFactory;
    private List<GraphQLServletListener> listeners;
    private boolean asyncServletModeEnabled;
    private Executor asyncExecutor;
    private long subscriptionTimeout;

    public static Builder with(GraphQLSchema schema) {
        return GraphQLConfiguration.with(new DefaultGraphQLSchemaProvider(schema));
    }

    public static Builder with(GraphQLSchemaProvider schemaProvider) {
        return new Builder(GraphQLInvocationInputFactory.newBuilder(schemaProvider));
    }

    public static Builder with(GraphQLInvocationInputFactory invocationInputFactory) {
        return new Builder(invocationInputFactory);
    }

    private GraphQLConfiguration(GraphQLInvocationInputFactory invocationInputFactory, GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper objectMapper, GraphQLBatchExecutionHandlerFactory batchExecutionHandlerFactory, List<GraphQLServletListener> listeners, boolean asyncServletModeEnabled, Executor asyncExecutor, long subscriptionTimeout) {
        this.invocationInputFactory = invocationInputFactory;
        this.queryInvoker = queryInvoker;
        this.objectMapper = objectMapper;
        this.batchExecutionHandlerFactory = batchExecutionHandlerFactory;
        this.listeners = listeners;
        this.asyncServletModeEnabled = asyncServletModeEnabled;
        this.asyncExecutor = asyncExecutor;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    public GraphQLInvocationInputFactory getInvocationInputFactory() {
        return this.invocationInputFactory;
    }

    public GraphQLQueryInvoker getQueryInvoker() {
        return this.queryInvoker;
    }

    public GraphQLObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public GraphQLBatchExecutionHandlerFactory getBatchExecutionHandlerFactory() {
        return this.batchExecutionHandlerFactory;
    }

    public List<GraphQLServletListener> getListeners() {
        return new ArrayList<GraphQLServletListener>(this.listeners);
    }

    public boolean isAsyncServletModeEnabled() {
        return this.asyncServletModeEnabled;
    }

    public Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public void add(GraphQLServletListener listener) {
        this.listeners.add(listener);
    }

    public boolean remove(GraphQLServletListener listener) {
        return this.listeners.remove(listener);
    }

    public long getSubscriptionTimeout() {
        return this.subscriptionTimeout;
    }

    public static class Builder {
        private GraphQLInvocationInputFactory.Builder invocationInputFactoryBuilder;
        private GraphQLInvocationInputFactory invocationInputFactory;
        private GraphQLQueryInvoker queryInvoker = GraphQLQueryInvoker.newBuilder().build();
        private GraphQLObjectMapper objectMapper = GraphQLObjectMapper.newBuilder().build();
        private GraphQLBatchExecutionHandlerFactory graphQLBatchExecutionHandlerFactory = new DefaultGraphQLBatchExecutionHandlerFactory();
        private List<GraphQLServletListener> listeners = new ArrayList<GraphQLServletListener>();
        private boolean asyncServletModeEnabled = false;
        private Executor asyncExecutor = Executors.newCachedThreadPool(new GraphQLThreadFactory());
        private long subscriptionTimeout = 0L;

        private Builder(GraphQLInvocationInputFactory.Builder invocationInputFactoryBuilder) {
            this.invocationInputFactoryBuilder = invocationInputFactoryBuilder;
        }

        private Builder(GraphQLInvocationInputFactory invocationInputFactory) {
            this.invocationInputFactory = invocationInputFactory;
        }

        public Builder with(GraphQLQueryInvoker queryInvoker) {
            if (queryInvoker != null) {
                this.queryInvoker = queryInvoker;
            }
            return this;
        }

        public Builder with(GraphQLObjectMapper objectMapper) {
            if (objectMapper != null) {
                this.objectMapper = objectMapper;
            }
            return this;
        }

        public Builder with(GraphQLBatchExecutionHandlerFactory batchExecutionHandlerFactory) {
            if (batchExecutionHandlerFactory != null) {
                this.graphQLBatchExecutionHandlerFactory = batchExecutionHandlerFactory;
            }
            return this;
        }

        public Builder with(List<GraphQLServletListener> listeners) {
            if (listeners != null) {
                this.listeners = listeners;
            }
            return this;
        }

        public Builder with(boolean asyncServletModeEnabled) {
            this.asyncServletModeEnabled = asyncServletModeEnabled;
            return this;
        }

        public Builder with(Executor asyncExecutor) {
            if (asyncExecutor != null) {
                this.asyncExecutor = asyncExecutor;
            }
            return this;
        }

        public Builder with(GraphQLContextBuilder contextBuilder) {
            this.invocationInputFactoryBuilder.withGraphQLContextBuilder(contextBuilder);
            return this;
        }

        public Builder with(GraphQLRootObjectBuilder rootObjectBuilder) {
            this.invocationInputFactoryBuilder.withGraphQLRootObjectBuilder(rootObjectBuilder);
            return this;
        }

        public Builder with(long subscriptionTimeout) {
            this.subscriptionTimeout = subscriptionTimeout;
            return this;
        }

        public GraphQLConfiguration build() {
            return new GraphQLConfiguration(this.invocationInputFactory != null ? this.invocationInputFactory : this.invocationInputFactoryBuilder.build(), this.queryInvoker, this.objectMapper, this.graphQLBatchExecutionHandlerFactory, this.listeners, this.asyncServletModeEnabled, this.asyncExecutor, this.subscriptionTimeout);
        }
    }
}

