/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.gradleplugin;

import com.graphql_java_generator.gradleplugin.GenerateCodeCommonExtension;
import com.graphql_java_generator.gradleplugin.GenerateCodeCommonTask;
import com.graphql_java_generator.gradleplugin.GenerateServerCodeExtension;
import com.graphql_java_generator.gradleplugin.GenerateServerCodeSpringConfiguration;
import com.graphql_java_generator.plugin.conf.GenerateServerCodeConfiguration;
import com.graphql_java_generator.plugin.conf.Packaging;
import com.graphql_java_generator.plugin.conf.PluginMode;
import com.graphql_java_generator.plugin.generate_code.GenerateCodeDocumentParser;
import com.graphql_java_generator.plugin.generate_code.GenerateCodeGenerator;
import com.graphql_java_generator.util.GraphqlUtils;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class GenerateServerCodeTask
extends GenerateCodeCommonTask
implements GenerateServerCodeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GenerateServerCodeTask.class);
    private Boolean generateBatchLoaderEnvironment;
    private Boolean generateJPAAnnotation;
    Boolean generateDataLoaderForLists;
    public String javaTypeForIDType;
    private String scanBasePackages;
    private String schemaPersonalizationFile;

    @Inject
    public GenerateServerCodeTask() {
        super((Class<? extends GenerateCodeCommonExtension>)GenerateServerCodeExtension.class);
    }

    public GenerateServerCodeTask(Class<? extends GenerateServerCodeExtension> extensionClazz) {
        super((Class<? extends GenerateCodeCommonExtension>)extensionClazz);
    }

    @TaskAction
    public void execute() throws IOException {
        logger.debug("Executing " + ((Object)((Object)this)).getClass().getName());
        GenerateServerCodeSpringConfiguration.generateServerCodeConf = this;
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{GenerateServerCodeSpringConfiguration.class});
        GenerateServerCodeConfiguration pluginConfiguration = (GenerateServerCodeConfiguration)ctx.getBean(GenerateServerCodeConfiguration.class);
        pluginConfiguration.logConfiguration();
        GenerateCodeDocumentParser documentParser = (GenerateCodeDocumentParser)ctx.getBean(GenerateCodeDocumentParser.class);
        documentParser.parseGraphQLSchemas();
        GenerateCodeGenerator codeGenerator = (GenerateCodeGenerator)ctx.getBean(GenerateCodeGenerator.class);
        codeGenerator.generateCode();
        ctx.close();
        this.registerGeneratedFolders();
        logger.debug("Finished generation of java classes from graphqls files (5)");
    }

    @Input
    public final String getJavaTypeForIDType() {
        return this.getValue(this.javaTypeForIDType, this.getExtension().getJavaTypeForIDType());
    }

    public final void setJavaTypeForIDType(String javaTypeForIDType) {
        this.javaTypeForIDType = javaTypeForIDType;
        this.setInitialized(true);
    }

    @Override
    @Input
    public PluginMode getMode() {
        return PluginMode.server;
    }

    @Internal
    public final Packaging getPackaging() {
        return this.getProject().getTasksByName("war", false).size() >= 1 ? Packaging.war : Packaging.jar;
    }

    @Internal
    public String getQuotedScanBasePackages() {
        return GraphqlUtils.graphqlUtils.getQuotedScanBasePackages(this.getScanBasePackages());
    }

    @Input
    public final String getScanBasePackages() {
        return this.getValue(this.scanBasePackages, this.getExtension().getScanBasePackages());
    }

    public final void setScanBasePackages(String scanBasePackages) {
        this.scanBasePackages = scanBasePackages;
        this.setInitialized(true);
    }

    @InputFile
    @Optional
    public final File getSchemaPersonalizationFile() {
        return this.getFileValue(this.schemaPersonalizationFile, this.getExtension().getSchemaPersonalizationFile());
    }

    public final void setSchemaPersonalizationFile(String schemaPersonalizationFile) {
        this.schemaPersonalizationFile = schemaPersonalizationFile;
        this.setInitialized(true);
    }

    @Input
    public final boolean isGenerateBatchLoaderEnvironment() {
        return this.getValue(this.generateBatchLoaderEnvironment, this.getExtension().isGenerateBatchLoaderEnvironment());
    }

    public final void setGenerateBatchLoaderEnvironment(boolean generateBatchLoaderEnvironment) {
        this.generateBatchLoaderEnvironment = generateBatchLoaderEnvironment;
        this.setInitialized(true);
    }

    @Override
    @Internal
    public boolean isGenerateJacksonAnnotations() {
        return false;
    }

    @Input
    public final boolean isGenerateJPAAnnotation() {
        return this.getValue(this.generateJPAAnnotation, this.getExtension().isGenerateJPAAnnotation());
    }

    public final void setGenerateJPAAnnotation(boolean generateJPAAnnotation) {
        this.generateJPAAnnotation = generateJPAAnnotation;
        this.setInitialized(true);
    }

    @Input
    public boolean isGenerateDataLoaderForLists() {
        return this.getValue(this.generateDataLoaderForLists, this.getExtension().isGenerateDataLoaderForLists());
    }

    public final void setGenerateDataLoaderForLists(boolean generateDataLoaderForLists) {
        this.generateDataLoaderForLists = generateDataLoaderForLists;
        this.setInitialized(true);
    }

    @Override
    protected GenerateServerCodeExtension getExtension() {
        return (GenerateServerCodeExtension)super.getExtension();
    }
}

