/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.gradleplugin;

import com.graphql_java_generator.gradleplugin.GeneratePojoExtension;
import com.graphql_java_generator.gradleplugin.GeneratePojoSpringConfiguration;
import com.graphql_java_generator.gradleplugin.GraphQLExtension;
import com.graphql_java_generator.gradleplugin.GraphQLGenerateCodeTask;
import com.graphql_java_generator.plugin.conf.GeneratePojoConfiguration;
import com.graphql_java_generator.plugin.conf.GraphQLConfiguration;
import com.graphql_java_generator.plugin.conf.PluginMode;
import com.graphql_java_generator.plugin.generate_code.GenerateCodeDocumentParser;
import com.graphql_java_generator.plugin.generate_code.GenerateCodeGenerator;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class GeneratePojoTask
extends GraphQLGenerateCodeTask
implements GeneratePojoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GeneratePojoTask.class);
    Boolean generateJacksonAnnotations = null;

    public GeneratePojoTask() {
        super((Class<? extends GraphQLExtension>)GeneratePojoExtension.class);
    }

    @Override
    @TaskAction
    public void execute() {
        try {
            logger.debug("Executing " + ((Object)((Object)this)).getClass().getName());
            GeneratePojoSpringConfiguration.graphqlPojoConf = this;
            AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{GeneratePojoSpringConfiguration.class});
            GraphQLConfiguration pluginConfiguration = (GraphQLConfiguration)ctx.getBean(GraphQLConfiguration.class);
            pluginConfiguration.logConfiguration();
            GenerateCodeDocumentParser documentParser = (GenerateCodeDocumentParser)ctx.getBean(GenerateCodeDocumentParser.class);
            documentParser.parseGraphQLSchemas();
            GenerateCodeGenerator codeGenerator = (GenerateCodeGenerator)ctx.getBean(GenerateCodeGenerator.class);
            codeGenerator.generateCode();
            ctx.close();
            this.registerGeneratedFolders();
            logger.debug("Finished generation of java classes from graphqls files (5)");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected GeneratePojoExtension getExtension() {
        return (GeneratePojoExtension)super.getExtension();
    }

    @Override
    @Input
    public boolean isGenerateJacksonAnnotations() {
        if (this.generateJacksonAnnotations == null && this.getExtension().isGenerateJacksonAnnotations_Raw() == null) {
            return this.getMode().equals((Object)PluginMode.client);
        }
        return this.getValue(this.generateJacksonAnnotations, this.getExtension().isGenerateJacksonAnnotations_Raw());
    }

    public void setGenerateJacksonAnnotations(boolean generateJacksonAnnotations) {
        this.generateJacksonAnnotations = generateJacksonAnnotations;
        this.setInitialized(true);
    }

    @Override
    public boolean isGenerateUtilityClasses() {
        return false;
    }

    @Override
    public boolean isSeparateUtilityClasses() {
        return true;
    }
}

