/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.gradleplugin;

import com.graphql_java_generator.gradleplugin.GenerateClientCodeExtension;
import com.graphql_java_generator.gradleplugin.GenerateClientCodeTask;
import com.graphql_java_generator.gradleplugin.GenerateGraphQLSchemaExtension;
import com.graphql_java_generator.gradleplugin.GenerateGraphQLSchemaTask;
import com.graphql_java_generator.gradleplugin.GeneratePojoExtension;
import com.graphql_java_generator.gradleplugin.GeneratePojoTask;
import com.graphql_java_generator.gradleplugin.GenerateServerCodeExtension;
import com.graphql_java_generator.gradleplugin.GenerateServerCodeTask;
import com.graphql_java_generator.gradleplugin.GraphQLExtension;
import com.graphql_java_generator.gradleplugin.GraphQLGenerateCodeTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLPlugin
implements Plugin<Project> {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLPlugin.class);
    public static final String GENERATE_CLIENT_CODE_EXTENSION = "generateClientCodeConf";
    public static final String GENERATE_CLIENT_CODE_TASK_NAME = "generateClientCode";
    public static final String GENERATE_POJO_EXTENSION = "generatePojoConf";
    public static final String GENERATE_POJO_TASK_NAME = "generatePojo";
    public static final String GENERATE_SERVER_CODE_EXTENSION = "generateServerCodeConf";
    public static final String GENERATE_SERVER_CODE_TASK_NAME = "generateServerCode";
    public static final String GRAPHQL_EXTENSION = "graphql";
    public static final String GRAPHQL_GENERATE_CODE_TASK_NAME = "graphqlGenerateCode";
    public static final String MERGE_EXTENSION = "generateGraphQLSchemaConf";
    public static final String MERGE_TASK_NAME = "generateGraphQLSchema";
    private Properties properties = null;

    public void apply(final Project project) {
        this.applyGenerateClientCode(project);
        this.applyGeneratePojo(project);
        final TaskProvider<GenerateServerCodeTask> taskProvider = this.applyGenerateServerCode(project);
        this.applyGraphQLGenerateCode(project);
        this.applyGenerateGraphQLSchema(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project p) {
                logger.info("[in project.afterEvaluate2] Before registering generated folders for project '" + p.getName() + "'");
                Set compileJavaTasks = project.getTasksByName("compileJava", false);
                Set processResourcesTasks = project.getTasksByName("processResources", false);
                HashSet<Task> allDependingTasks = new HashSet<Task>();
                allDependingTasks.addAll(compileJavaTasks);
                allDependingTasks.addAll(processResourcesTasks);
                for (Task t : project.getTasks()) {
                    if (t.hasProperty("initialized")) {
                        logger.debug("getTasks(): {}, taskProvider.present={}, initialized={}", new Object[]{t.getPath(), taskProvider.isPresent(), t.property("initialized")});
                        if (!((Boolean)t.property("initialized")).booleanValue()) continue;
                        this.addTaskAsADependencyToAnotherTask(p, t, allDependingTasks);
                        continue;
                    }
                    logger.debug("getTasks(): {}", (Object)t.getPath());
                }
                if (processResourcesTasks.size() == 0) {
                    throw new RuntimeException("Found no 'processResources' task, when executing project.afterEvaluate()");
                }
                for (Task t : processResourcesTasks) {
                    ((CopySpec)t).setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
                    logger.info(" Setting property: {}.duplicatesStrategy = {}", (Object)t.getName(), (Object)DuplicatesStrategy.INCLUDE);
                }
            }

            private void addTaskAsADependencyToAnotherTask(Project p, Task task, Set<Task> dependingTasks) {
                for (Task dependingTask : dependingTasks) {
                    logger.info("Adding dependency: {}.dependsOn({})", (Object)dependingTask.getPath(), (Object)task.getPath());
                    dependingTask.dependsOn(new Object[]{task.getPath()});
                }
            }
        });
    }

    public String getVersion() {
        return this.getProperties().get("plugin.version").toString();
    }

    public String getDependenciesVersion() {
        return this.getProperties().get("graphqlMavenPluginLogic.version").toString();
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try (InputStream is = this.getClass().getResourceAsStream("/application.properties");){
                this.properties.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.properties;
    }

    private void applyGenerateClientCode(Project project) {
        project.getExtensions().create(GENERATE_CLIENT_CODE_EXTENSION, GenerateClientCodeExtension.class, new Object[]{project});
        logger.debug("Applying generateClientCode task");
        project.getTasks().register(GENERATE_CLIENT_CODE_TASK_NAME, GenerateClientCodeTask.class);
        project.getPlugins().apply(JavaPlugin.class);
    }

    private void applyGenerateGraphQLSchema(Project project) {
        project.getExtensions().create(MERGE_EXTENSION, GenerateGraphQLSchemaExtension.class, new Object[]{project});
        logger.debug("Applying generateGraphQLSchema task");
        project.getTasks().register(MERGE_TASK_NAME, GenerateGraphQLSchemaTask.class);
    }

    private void applyGeneratePojo(Project project) {
        project.getExtensions().create(GENERATE_POJO_EXTENSION, GeneratePojoExtension.class, new Object[]{project});
        logger.debug("Applying generatePojo task");
        project.getTasks().register(GENERATE_POJO_TASK_NAME, GeneratePojoTask.class);
        project.getPlugins().apply(JavaPlugin.class);
    }

    private TaskProvider<GenerateServerCodeTask> applyGenerateServerCode(Project project) {
        project.getExtensions().create(GENERATE_SERVER_CODE_EXTENSION, GenerateServerCodeExtension.class, new Object[]{project});
        logger.info("Applying generateServerCode task");
        TaskProvider ret = project.getTasks().register(GENERATE_SERVER_CODE_TASK_NAME, GenerateServerCodeTask.class);
        project.getPlugins().apply(JavaPlugin.class);
        return ret;
    }

    private void applyGraphQLGenerateCode(Project project) {
        project.getExtensions().create(GRAPHQL_EXTENSION, GraphQLExtension.class, new Object[]{project});
        logger.debug("Applying GraphQL task");
        project.getTasks().register(GRAPHQL_GENERATE_CODE_TASK_NAME, GraphQLGenerateCodeTask.class);
        project.getPlugins().apply(JavaPlugin.class);
    }
}

