/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.gradleplugin;

import com.graphql_java_generator.gradleplugin.GenerateServerCodeExtension;
import com.graphql_java_generator.gradleplugin.GenerateServerCodeTask;
import com.graphql_java_generator.gradleplugin.GraphQLExtension;
import com.graphql_java_generator.gradleplugin.GraphQLGenerateCodeSpringConfiguration;
import com.graphql_java_generator.plugin.conf.GraphQLConfiguration;
import com.graphql_java_generator.plugin.conf.PluginMode;
import com.graphql_java_generator.plugin.generate_code.GenerateCodeDocumentParser;
import com.graphql_java_generator.plugin.generate_code.GenerateCodeGenerator;
import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class GraphQLGenerateCodeTask
extends GenerateServerCodeTask
implements GraphQLConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GraphQLGenerateCodeTask.class);
    private Boolean generateDeprecatedRequestResponse;
    private PluginMode mode;

    @Inject
    public GraphQLGenerateCodeTask() {
        super((Class<? extends GenerateServerCodeExtension>)GraphQLExtension.class);
    }

    public GraphQLGenerateCodeTask(Class<? extends GraphQLExtension> extensionClazz) {
        super((Class<? extends GenerateServerCodeExtension>)extensionClazz);
    }

    @Override
    @TaskAction
    public void execute() {
        try {
            logger.debug("Executing " + ((Object)((Object)this)).getClass().getName());
            GraphQLGenerateCodeSpringConfiguration.graphqlGenerateCodeConf = this;
            AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{GraphQLGenerateCodeSpringConfiguration.class});
            GraphQLConfiguration pluginConfiguration = (GraphQLConfiguration)ctx.getBean(GraphQLConfiguration.class);
            pluginConfiguration.logConfiguration();
            GenerateCodeDocumentParser documentParser = (GenerateCodeDocumentParser)ctx.getBean(GenerateCodeDocumentParser.class);
            documentParser.parseGraphQLSchemas();
            GenerateCodeGenerator codeGenerator = (GenerateCodeGenerator)ctx.getBean(GenerateCodeGenerator.class);
            codeGenerator.generateCode();
            ctx.close();
            this.registerGeneratedFolders();
            logger.debug("Finished generation of java classes from graphqls files (5)");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Input
    public PluginMode getMode() {
        return this.getValue(this.mode, this.getExtension().getMode());
    }

    public final void setMode(PluginMode mode) {
        this.mode = mode;
        this.setInitialized(true);
    }

    @Input
    public final boolean isGenerateDeprecatedRequestResponse() {
        return this.getValue(this.generateDeprecatedRequestResponse, this.getExtension().isGenerateDeprecatedRequestResponse());
    }

    public final void setGenerateDeprecatedRequestResponse(boolean generateDeprecatedRequestResponse) {
        this.generateDeprecatedRequestResponse = generateDeprecatedRequestResponse;
        this.setInitialized(true);
    }

    @Override
    @Internal
    public boolean isGenerateJacksonAnnotations() {
        return this.getMode().equals((Object)PluginMode.client);
    }

    @Override
    protected GraphQLExtension getExtension() {
        return (GraphQLExtension)super.getExtension();
    }
}

