/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.gradleplugin;

import com.graphql_java_generator.gradleplugin.CommonTask;
import com.graphql_java_generator.gradleplugin.GenerateGraphQLSchemaExtension;
import com.graphql_java_generator.gradleplugin.GenerateGraphQLSchemaSpringConfiguration;
import com.graphql_java_generator.plugin.conf.GenerateGraphQLSchemaConfiguration;
import com.graphql_java_generator.plugin.generate_schema.GenerateGraphQLSchema;
import com.graphql_java_generator.plugin.generate_schema.GenerateGraphQLSchemaDocumentParser;
import java.io.File;
import java.io.IOException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class GenerateGraphQLSchemaTask
extends CommonTask
implements GenerateGraphQLSchemaConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GenerateGraphQLSchemaTask.class);
    String resourceEncoding;
    private String targetFolder;
    private String targetSchemaFileName;

    public GenerateGraphQLSchemaTask() {
        super(GenerateGraphQLSchemaExtension.class);
    }

    @TaskAction
    public void execute() throws IOException {
        GenerateGraphQLSchemaSpringConfiguration.generateGraphQLSchemaConf = this;
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext(new Class[]{GenerateGraphQLSchemaSpringConfiguration.class});
        GenerateGraphQLSchemaConfiguration pluginConfiguration = (GenerateGraphQLSchemaConfiguration)ctx.getBean(GenerateGraphQLSchemaConfiguration.class);
        pluginConfiguration.logConfiguration();
        GenerateGraphQLSchemaDocumentParser documentParser = (GenerateGraphQLSchemaDocumentParser)ctx.getBean(GenerateGraphQLSchemaDocumentParser.class);
        documentParser.parseGraphQLSchemas();
        GenerateGraphQLSchema merge = (GenerateGraphQLSchema)ctx.getBean(GenerateGraphQLSchema.class);
        merge.generateGraphQLSchema();
        ctx.close();
        this.registerGeneratedFolders();
        logger.debug("Finished generation of the merged schema");
    }

    @Input
    public String getResourceEncoding() {
        return this.getValue(this.resourceEncoding, this.getExtension().getResourceEncoding());
    }

    public String setResourceEncoding(String resourceEncoding) {
        this.setInitialized(true);
        this.resourceEncoding = resourceEncoding;
        return this.resourceEncoding;
    }

    @InputDirectory
    public File getTargetFolder() {
        File file = this.getFileValue(this.targetFolder, this.getExtension().getTargetFolder());
        file.mkdirs();
        return file;
    }

    public void setTargetFolder(String targetFolder) {
        this.getProject().file((Object)targetFolder).mkdirs();
        this.targetFolder = targetFolder;
        this.setInitialized(true);
    }

    @Input
    public String getTargetSchemaFileName() {
        return this.getValue(this.targetSchemaFileName, this.getExtension().getTargetSchemaFileName());
    }

    public void setTargetSchemaFileName(String targetSchemaFileName) {
        this.targetSchemaFileName = targetSchemaFileName;
        this.setInitialized(true);
    }

    @Override
    protected GenerateGraphQLSchemaExtension getExtension() {
        return (GenerateGraphQLSchemaExtension)super.getExtension();
    }

    @Override
    @Internal
    public boolean isGenerateJacksonAnnotations() {
        return true;
    }

    @Override
    public void registerGeneratedFolders() {
        SourceSet main = (SourceSet)((SourceSetContainer)this.getProject().getProperties().get("sourceSets")).getByName("main");
        logger.debug("Adding '" + this.getTargetFolder() + "' folder to the resources folders list");
        main.getResources().srcDir((Object)this.getTargetFolder());
    }
}

