/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.gradleplugin;

import com.graphql_java_generator.gradleplugin.CommonTask;
import com.graphql_java_generator.gradleplugin.GenerateCodeCommonExtension;
import com.graphql_java_generator.plugin.conf.CustomScalarDefinition;
import com.graphql_java_generator.plugin.conf.GenerateCodeCommonConfiguration;
import com.graphql_java_generator.plugin.conf.PluginMode;
import com.graphql_java_generator.plugin.conf.QueryMutationExecutionProtocol;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateCodeCommonTask
extends CommonTask
implements GenerateCodeCommonConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GenerateCodeCommonTask.class);
    private Boolean copyRuntimeSources;
    private List<CustomScalarDefinition> customScalars;
    private String packageName;
    QueryMutationExecutionProtocol queryMutationExecutionProtocol;
    private String schemaPersonalizationFile;
    private Boolean separateUtilityClasses;
    private String sourceEncoding;
    private String springBeanSuffix;
    protected String targetResourceFolder;
    protected String targetSourceFolder;
    protected Boolean useJakartaEE9;

    @Inject
    public GenerateCodeCommonTask(Class<? extends GenerateCodeCommonExtension> extensionClazz) {
        super(extensionClazz);
    }

    @Input
    public final boolean isCopyRuntimeSources() {
        return this.getValue(this.copyRuntimeSources, this.getExtension().isCopyRuntimeSources());
    }

    @Internal
    public boolean isGenerateUtilityClasses() {
        return true;
    }

    public final void setCopyRuntimeSources(boolean copyRuntimeSources) {
        this.copyRuntimeSources = copyRuntimeSources;
        this.setInitialized(true);
    }

    @Input
    public final List<CustomScalarDefinition> getCustomScalars() {
        return this.getValue(this.customScalars, this.getExtension().getCustomScalars());
    }

    public final void setCustomScalars(CustomScalarDefinition[] customScalars) {
        this.customScalars = Arrays.asList(customScalars);
        this.setInitialized(true);
    }

    @Input
    @Optional
    public PluginMode getMode() {
        return null;
    }

    @Input
    public final String getPackageName() {
        return this.getValue(this.packageName, this.getExtension().getPackageName());
    }

    public final void setPackageName(String packageName) {
        this.packageName = packageName;
        this.setInitialized(true);
    }

    @Input
    public final QueryMutationExecutionProtocol getQueryMutationExecutionProtocol() {
        return this.getValue(this.queryMutationExecutionProtocol, this.getExtension().getQueryMutationExecutionProtocol());
    }

    public final void setQueryMutationExecutionProtocol(QueryMutationExecutionProtocol queryMutationExecutionProtocol) {
        this.queryMutationExecutionProtocol = queryMutationExecutionProtocol;
        this.setInitialized(true);
    }

    @InputFile
    @Optional
    public final File getSchemaPersonalizationFile() {
        return this.getFileValue(this.schemaPersonalizationFile, this.getExtension().getSchemaPersonalizationFile());
    }

    public final void setSchemaPersonalizationFile(String schemaPersonalizationFile) {
        this.schemaPersonalizationFile = schemaPersonalizationFile;
        this.setInitialized(true);
    }

    @Input
    public boolean isSeparateUtilityClasses() {
        return this.getValue(this.separateUtilityClasses, this.getExtension().isSeparateUtilityClasses());
    }

    public final void setSeparateUtilityClasses(boolean separateUtilityClasses) {
        this.separateUtilityClasses = separateUtilityClasses;
        this.setInitialized(true);
    }

    @Input
    public final String getSourceEncoding() {
        return this.getValue(this.sourceEncoding, this.getExtension().getSourceEncoding());
    }

    public final void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
        this.setInitialized(true);
    }

    @Internal
    public String getSpringAutoConfigurationPackage() {
        return super.getSpringAutoConfigurationPackage();
    }

    @Input
    public final String getSpringBeanSuffix() {
        return this.getValue(this.springBeanSuffix, this.getExtension().getSpringBeanSuffix());
    }

    public final void setSpringBeanSuffix(String springBeanSuffix) {
        this.springBeanSuffix = springBeanSuffix;
        this.setInitialized(true);
    }

    @OutputDirectory
    public final File getTargetClassFolder() {
        return this.getProject().file((Object)"build/classes/java/main");
    }

    @OutputDirectory
    public final File getTargetResourceFolder() {
        File file = this.getFileValue(this.targetResourceFolder, this.getExtension().getTargetResourceFolder());
        file.mkdirs();
        return file;
    }

    public final void setTargetResourceFolder(String targetResourceFolder) {
        this.targetResourceFolder = targetResourceFolder;
        this.setInitialized(true);
    }

    @OutputDirectory
    public final File getTargetSourceFolder() {
        File file = this.getFileValue(this.targetSourceFolder, this.getExtension().getTargetSourceFolder());
        file.mkdirs();
        return file;
    }

    public final void setTargetSourceFolder(String targetSourceFolder) {
        this.targetSourceFolder = targetSourceFolder;
        this.setInitialized(true);
    }

    @Input
    public boolean isUseJakartaEE9() {
        return this.getValue(this.useJakartaEE9, this.getExtension().isUseJakartaEE9());
    }

    public final void setUseJakartaEE9(boolean useJakartaEE9) {
        this.useJakartaEE9 = useJakartaEE9;
        this.setInitialized(true);
    }

    @Override
    protected GenerateCodeCommonExtension getExtension() {
        return (GenerateCodeCommonExtension)super.getExtension();
    }

    @Override
    @Internal
    public boolean isGenerateJacksonAnnotations() {
        return true;
    }

    @Override
    public void registerGeneratedFolders() {
        SourceSet main = (SourceSet)((SourceSetContainer)this.getProject().getProperties().get("sourceSets")).getByName("main");
        main.getJava().srcDir((Object)this.getTargetSourceFolder());
        logger.info("Adding '" + this.getTargetResourceFolder() + "' folder to the resources folders list for task '" + this.getName() + "'");
        main.getResources().srcDir((Object)this.getTargetResourceFolder());
        if (logger.isInfoEnabled()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (File f : main.getResources().getSrcDirs()) {
                paths.add(f.getAbsolutePath());
            }
            logger.info("Resources folders are: [" + String.join((CharSequence)",", paths) + "]");
        }
    }
}

