/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.gradleplugin;

import com.graphql_java_generator.gradleplugin.CommonExtension;
import com.graphql_java_generator.plugin.conf.CommonConfiguration;
import groovy.lang.Closure;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTask
extends DefaultTask
implements CommonConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CommonTask.class);
    private boolean initialized = false;
    private Integer maxTokens = null;
    private Boolean addRelayConnections;
    private String enumPrefix;
    private String enumSuffix;
    private String inputPrefix;
    private String inputSuffix;
    private String interfacePrefix;
    private String interfaceSuffix;
    private String schemaFileFolder;
    private String schemaFilePattern;
    public Boolean skipGenerationIfSchemaHasNotChanged;
    private Map<String, String> templates;
    private String typePrefix;
    private String typeSuffix;
    private String unionPrefix;
    private String unionSuffix;
    protected Class<? extends CommonExtension> extensionClass;
    protected CommonExtension extension = null;

    @Inject
    public CommonTask(Class<? extends CommonExtension> extensionClazz) {
        this.extensionClass = extensionClazz;
    }

    protected <T> T getValue(T taskValue, T extensionValue) {
        return taskValue == null ? extensionValue : taskValue;
    }

    protected File getFileValue(String taskValue, File extensionValue) {
        return taskValue == null ? extensionValue : this.getProject().file((Object)taskValue);
    }

    @Input
    public final boolean isAddRelayConnections() {
        return this.getValue(this.addRelayConnections, this.getExtension().isAddRelayConnections());
    }

    public final void setAddRelayConnections(Boolean addRelayConnections) {
        this.addRelayConnections = addRelayConnections;
        this.setInitialized(true);
    }

    @Internal
    public final String getDefaultTargetSchemaFileName() {
        return "generated_schema.graphqls";
    }

    @Input
    public String getEnumPrefix() {
        return this.getValue(this.enumPrefix, this.getExtension().getEnumPrefix());
    }

    public void setEnumPrefix(String enumPrefix) {
        this.enumPrefix = enumPrefix;
    }

    @Input
    public String getEnumSuffix() {
        return this.getValue(this.enumSuffix, this.getExtension().getEnumSuffix());
    }

    public void setEnumSuffix(String enumSuffix) {
        this.enumSuffix = enumSuffix;
    }

    @Input
    public String getInputPrefix() {
        return this.getValue(this.inputPrefix, this.getExtension().getInputPrefix());
    }

    public void setInputPrefix(String inputPrefix) {
        this.inputPrefix = inputPrefix;
    }

    @Input
    public String getInputSuffix() {
        return this.getValue(this.inputSuffix, this.getExtension().getInputSuffix());
    }

    public void setInputSuffix(String inputSuffix) {
        this.inputSuffix = inputSuffix;
    }

    @Input
    public boolean isInitialized() {
        return this.initialized || this.getExtension().isInitialized();
    }

    @Input
    public String getInterfacePrefix() {
        return this.getValue(this.interfacePrefix, this.getExtension().getInterfacePrefix());
    }

    public void setInterfacePrefix(String interfacePrefix) {
        this.interfacePrefix = interfacePrefix;
    }

    @Input
    public String getInterfaceSuffix() {
        return this.getValue(this.interfaceSuffix, this.getExtension().getInterfaceSuffix());
    }

    public void setInterfaceSuffix(String interfaceSuffix) {
        this.interfaceSuffix = interfaceSuffix;
    }

    @Input
    public Integer getMaxTokens() {
        return this.getValue(this.maxTokens, this.getExtension().getMaxTokens());
    }

    public void setParserOptions(Integer maxTokens) {
        this.maxTokens = maxTokens;
        this.setInitialized(true);
    }

    @Internal
    public final File getProjectDir() {
        return this.getProject().getProjectDir();
    }

    @Input
    public String getTypePrefix() {
        return this.getValue(this.typePrefix, this.getExtension().getTypePrefix());
    }

    public void setTypePrefix(String typePrefix) {
        this.typePrefix = typePrefix;
    }

    @Input
    public String getTypeSuffix() {
        return this.getValue(this.typeSuffix, this.getExtension().getTypeSuffix());
    }

    public void setTypeSuffix(String typeSuffix) {
        this.typeSuffix = typeSuffix;
    }

    @Input
    public String getUnionPrefix() {
        return this.getValue(this.unionPrefix, this.getExtension().getUnionPrefix());
    }

    public void setUnionPrefix(String unionPrefix) {
        this.unionPrefix = unionPrefix;
    }

    @Input
    public String getUnionSuffix() {
        return this.getValue(this.unionSuffix, this.getExtension().getUnionSuffix());
    }

    public void setUnionSuffix(String unionSuffix) {
        this.unionSuffix = unionSuffix;
    }

    @Internal
    public boolean isGenerateJacksonAnnotations() {
        return true;
    }

    @Input
    @Deprecated
    public final boolean isSkipGenerationIfSchemaHasNotChanged() {
        return this.getValue(this.skipGenerationIfSchemaHasNotChanged, this.getExtension().isSkipGenerationIfSchemaHasNotChanged());
    }

    public final void setSkipGenerationIfSchemaHasNotChanged(boolean skipGenerationIfSchemaHasNotChanged) {
        this.skipGenerationIfSchemaHasNotChanged = skipGenerationIfSchemaHasNotChanged;
        this.setInitialized(true);
    }

    @InputDirectory
    @Optional
    public final File getSchemaFileFolder() {
        return this.getFileValue(this.schemaFileFolder, this.getExtension().getSchemaFileFolder());
    }

    public final void setSchemaFileFolder(String schemaFileFolder) {
        this.schemaFileFolder = schemaFileFolder;
        this.setInitialized(true);
    }

    @Input
    public final String getSchemaFilePattern() {
        return this.getValue(this.schemaFilePattern, this.getExtension().getSchemaFilePattern());
    }

    public final void setSchemaFilePattern(String schemaFilePattern) {
        this.schemaFilePattern = schemaFilePattern;
        this.setInitialized(true);
    }

    @Internal
    public String getTargetSchemaSubFolder() {
        return "graphql";
    }

    @Input
    public final Map<String, String> getTemplates() {
        return this.getValue(this.templates, this.getExtension().getTemplates());
    }

    public final void setTemplates(Map<String, String> templates) {
        this.templates = templates;
        this.setInitialized(true);
    }

    public void logConfiguration() {
        this.logCommonConfiguration();
    }

    @Internal
    protected CommonExtension getExtension() {
        if (this.extension == null) {
            this.extension = (CommonExtension)this.getProject().getExtensions().getByType(this.extensionClass);
        }
        return this.extension;
    }

    public void registerGeneratedFolders() {
    }

    protected void addThisTaskAsADependencyToAnotherTask(String taskName) {
        for (Task t : this.getTasks(taskName)) {
            logger.info("Adding dependency: {}.dependsOn({})", (Object)t.getPath(), (Object)this.getPath());
            t.dependsOn(new Object[]{this.getPath()});
        }
    }

    private Set<Task> getTasks(String taskName) {
        Set tasks = this.getProject().getTasksByName(taskName, false);
        if (tasks.size() == 0) {
            throw new RuntimeException("Found no 'processResources' task, when executing project.afterEvaluate()");
        }
        return tasks;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public Task configure(Closure closure) {
        Task t = super.configure(closure);
        logger.info("[In configure] Before calling registerGeneratedFolders, for task '" + this.getPath() + "'");
        this.registerGeneratedFolders();
        this.addThisTaskAsADependencyToAnotherTask("compileJava");
        this.addThisTaskAsADependencyToAnotherTask("processResources");
        return t;
    }
}

