/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.CHStorage;
import java.util.function.IntUnaryOperator;

public class CHStorageBuilder {
    private final CHStorage storage;

    public CHStorageBuilder(CHStorage chStorage) {
        this.storage = chStorage;
    }

    public void setLevel(int node, int level) {
        this.storage.setLevel(this.storage.toNodePointer(node), level);
    }

    public void setLevelForAllNodes(int level) {
        for (int node = 0; node < this.storage.getNodes(); ++node) {
            this.setLevel(node, level);
        }
    }

    public void setIdentityLevels() {
        for (int node = 0; node < this.storage.getNodes(); ++node) {
            this.setLevel(node, node);
        }
    }

    public int addShortcutNodeBased(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2) {
        this.checkNewShortcut(a, b);
        int shortcut = this.storage.shortcutNodeBased(a, b, accessFlags, weight, skippedEdge1, skippedEdge2);
        this.setLastShortcut(a, shortcut);
        return shortcut;
    }

    public int addShortcutEdgeBased(int a, int b, int accessFlags, double weight, int skippedEdge1, int skippedEdge2, int origFirst, int origLast) {
        this.checkNewShortcut(a, b);
        int shortcut = this.storage.shortcutEdgeBased(a, b, accessFlags, weight, skippedEdge1, skippedEdge2, origFirst, origLast);
        this.setLastShortcut(a, shortcut);
        return shortcut;
    }

    public void replaceSkippedEdges(IntUnaryOperator mapping) {
        for (int i = 0; i < this.storage.getShortcuts(); ++i) {
            long shortcutPointer = this.storage.toShortcutPointer(i);
            int skip1 = this.storage.getSkippedEdge1(shortcutPointer);
            int skip2 = this.storage.getSkippedEdge2(shortcutPointer);
            this.storage.setSkippedEdges(shortcutPointer, mapping.applyAsInt(skip1), mapping.applyAsInt(skip2));
        }
    }

    private void checkNewShortcut(int a, int b) {
        this.checkNodeId(a);
        this.checkNodeId(b);
        if (this.getLevel(a) >= this.storage.getNodes() || this.getLevel(a) < 0) {
            throw new IllegalArgumentException("Invalid level for node " + a + ": " + this.getLevel(a) + ". Node a must be assigned a valid level before we add shortcuts a->b or a<-b");
        }
        if (a != b && this.getLevel(a) == this.getLevel(b)) {
            throw new IllegalArgumentException("Different nodes must not have the same level, got levels " + this.getLevel(a) + " and " + this.getLevel(b) + " for nodes " + a + " and " + b);
        }
        if (a != b && this.getLevel(a) > this.getLevel(b)) {
            throw new IllegalArgumentException("The level of nodeA must be smaller than the level of nodeB, but got: " + this.getLevel(a) + " and " + this.getLevel(b) + ". When inserting shortcut: " + a + "-" + b);
        }
        if (this.storage.getShortcuts() > 0) {
            int prevNodeA = this.storage.getNodeA(this.storage.toShortcutPointer(this.storage.getShortcuts() - 1));
            int prevLevelA = this.getLevel(prevNodeA);
            if (this.getLevel(a) < prevLevelA) {
                throw new IllegalArgumentException("Invalid level for node " + a + ": " + this.getLevel(a) + ". The level must be equal to or larger than the lower level node of the previous shortcut (node: " + prevNodeA + ", level: " + prevLevelA + ")");
            }
        }
    }

    private void setLastShortcut(int node, int shortcut) {
        this.storage.setLastShortcut(this.storage.toNodePointer(node), shortcut);
    }

    private int getLevel(int node) {
        this.checkNodeId(node);
        return this.storage.getLevel(this.storage.toNodePointer(node));
    }

    private void checkNodeId(int node) {
        if (node >= this.storage.getNodes() || node < 0) {
            throw new IllegalArgumentException("node " + node + " is invalid. Not in [0," + this.storage.getNodes() + ")");
        }
    }
}

