/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ch.NodeOrderingProvider;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.Helper;
import java.util.Locale;
import java.util.function.Consumer;

public class CHStorage {
    private static final double WEIGHT_FACTOR = 1000.0;
    private static final long MAX_STORED_INTEGER_WEIGHT = 0xFFFFFFFEL;
    private static final double MAX_WEIGHT = 4294967.294;
    private static final double MIN_WEIGHT = 0.001;
    private final DataAccess shortcuts;
    private final int S_NODEA;
    private final int S_NODEB;
    private final int S_WEIGHT;
    private final int S_SKIP_EDGE1;
    private final int S_SKIP_EDGE2;
    private final int S_ORIG_FIRST;
    private final int S_ORIG_LAST;
    private int shortcutEntryBytes;
    private int shortcutCount = 0;
    private final DataAccess nodesCH;
    private final int N_LEVEL;
    private final int N_LAST_SC;
    private int nodeCHEntryBytes;
    private int nodeCount = -1;
    private boolean edgeBased;
    private int numShortcutsExceedingWeight;
    private Consumer<LowWeightShortcut> lowShortcutWeightConsumer;

    public CHStorage(Directory dir, String name, int segmentSize, boolean edgeBased) {
        this.edgeBased = edgeBased;
        this.nodesCH = dir.find("nodes_ch_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        this.shortcuts = dir.find("shortcuts_" + name, DAType.getPreferredInt(dir.getDefaultType()));
        if (segmentSize >= 0) {
            this.nodesCH.setSegmentSize(segmentSize);
            this.shortcuts.setSegmentSize(segmentSize);
        }
        this.S_NODEA = 0;
        this.S_NODEB = this.S_NODEA + 4;
        this.S_WEIGHT = this.S_NODEB + 4;
        this.S_SKIP_EDGE1 = this.S_WEIGHT + 4;
        this.S_SKIP_EDGE2 = this.S_SKIP_EDGE1 + 4;
        this.S_ORIG_FIRST = this.S_SKIP_EDGE2 + (edgeBased ? 4 : 0);
        this.S_ORIG_LAST = this.S_ORIG_FIRST + (edgeBased ? 4 : 0);
        this.shortcutEntryBytes = this.S_ORIG_LAST + 4;
        this.N_LEVEL = 0;
        this.N_LAST_SC = this.N_LEVEL + 4;
        this.nodeCHEntryBytes = this.N_LAST_SC + 4;
    }

    public void setLowShortcutWeightConsumer(Consumer<LowWeightShortcut> lowWeightShortcutConsumer) {
        this.lowShortcutWeightConsumer = lowWeightShortcutConsumer;
    }

    public void create() {
        this.nodesCH.create(0L);
        this.shortcuts.create(0L);
    }

    public void init(int nodes, int expectedShortcuts) {
        if (this.nodeCount >= 0) {
            throw new IllegalStateException("CHStorage can only be initialized once");
        }
        if (nodes < 0) {
            throw new IllegalStateException("CHStorage must be initialized with a positive number of nodes");
        }
        this.nodesCH.ensureCapacity((long)nodes * (long)this.nodeCHEntryBytes);
        this.nodeCount = nodes;
        this.shortcuts.ensureCapacity((long)expectedShortcuts * (long)this.shortcutEntryBytes);
        for (int node = 0; node < nodes; ++node) {
            this.setLastShortcut(this.toNodePointer(node), -1);
        }
    }

    public void flush() {
        this.nodesCH.setHeader(0, this.nodeCount);
        this.nodesCH.setHeader(4, this.nodeCHEntryBytes);
        this.nodesCH.flush();
        this.shortcuts.setHeader(0, this.shortcutCount);
        this.shortcuts.setHeader(4, this.shortcutEntryBytes);
        this.shortcuts.setHeader(8, this.numShortcutsExceedingWeight);
        this.shortcuts.setHeader(12, this.edgeBased ? 1 : 0);
        this.shortcuts.flush();
    }

    public boolean loadExisting() {
        if (!this.nodesCH.loadExisting() || !this.shortcuts.loadExisting()) {
            return false;
        }
        this.nodeCount = this.nodesCH.getHeader(0);
        this.nodeCHEntryBytes = this.nodesCH.getHeader(4);
        this.shortcutCount = this.shortcuts.getHeader(0);
        this.shortcutEntryBytes = this.shortcuts.getHeader(4);
        this.numShortcutsExceedingWeight = this.shortcuts.getHeader(8);
        this.edgeBased = this.shortcuts.getHeader(12) == 1;
        return true;
    }

    public void close() {
        this.nodesCH.close();
        this.shortcuts.close();
    }

    public int shortcutNodeBased(int nodeA, int nodeB, int accessFlags, double weight, int skip1, int skip2) {
        if (this.edgeBased) {
            throw new IllegalArgumentException("Cannot add node-based shortcuts to edge-based CH");
        }
        return this.shortcut(nodeA, nodeB, accessFlags, weight, skip1, skip2);
    }

    public int shortcutEdgeBased(int nodeA, int nodeB, int accessFlags, double weight, int skip1, int skip2, int origFirst, int origLast) {
        if (!this.edgeBased) {
            throw new IllegalArgumentException("Cannot add edge-based shortcuts to node-based CH");
        }
        int shortcut = this.shortcut(nodeA, nodeB, accessFlags, weight, skip1, skip2);
        this.setOrigEdges(this.toShortcutPointer(shortcut), origFirst, origLast);
        return shortcut;
    }

    private int shortcut(int nodeA, int nodeB, int accessFlags, double weight, int skip1, int skip2) {
        if (this.shortcutCount == Integer.MAX_VALUE) {
            throw new IllegalStateException("Maximum shortcut count exceeded: " + this.shortcutCount);
        }
        if (this.lowShortcutWeightConsumer != null && weight < 0.001) {
            this.lowShortcutWeightConsumer.accept(new LowWeightShortcut(nodeA, nodeB, this.shortcutCount, weight, 0.001));
        }
        long shortcutPointer = (long)this.shortcutCount * (long)this.shortcutEntryBytes;
        ++this.shortcutCount;
        this.shortcuts.ensureCapacity((long)this.shortcutCount * (long)this.shortcutEntryBytes);
        int weightInt = this.weightFromDouble(weight);
        this.setNodesAB(shortcutPointer, nodeA, nodeB, accessFlags);
        this.setWeightInt(shortcutPointer, weightInt);
        this.setSkippedEdges(shortcutPointer, skip1, skip2);
        return this.shortcutCount - 1;
    }

    public int getNodes() {
        return this.nodeCount;
    }

    public int getShortcuts() {
        return this.shortcutCount;
    }

    public long toNodePointer(int node) {
        assert (node >= 0 && node < this.nodeCount) : "node not in bounds: [0, " + this.nodeCount + "[";
        return (long)node * (long)this.nodeCHEntryBytes;
    }

    public long toShortcutPointer(int shortcut) {
        assert (shortcut < this.shortcutCount) : "shortcut " + shortcut + " not in bounds [0, " + this.shortcutCount + "[";
        return (long)shortcut * (long)this.shortcutEntryBytes;
    }

    public boolean isEdgeBased() {
        return this.edgeBased;
    }

    public int getLastShortcut(long nodePointer) {
        return this.nodesCH.getInt(nodePointer + (long)this.N_LAST_SC);
    }

    public void setLastShortcut(long nodePointer, int shortcut) {
        this.nodesCH.setInt(nodePointer + (long)this.N_LAST_SC, shortcut);
    }

    public int getLevel(long nodePointer) {
        return this.nodesCH.getInt(nodePointer + (long)this.N_LEVEL);
    }

    public void setLevel(long nodePointer, int level) {
        this.nodesCH.setInt(nodePointer + (long)this.N_LEVEL, level);
    }

    private void setNodesAB(long shortcutPointer, int nodeA, int nodeB, int accessFlags) {
        this.shortcuts.setInt(shortcutPointer + (long)this.S_NODEA, nodeA << 1 | accessFlags & PrepareEncoder.getScFwdDir());
        this.shortcuts.setInt(shortcutPointer + (long)this.S_NODEB, nodeB << 1 | (accessFlags & PrepareEncoder.getScBwdDir()) >> 1);
    }

    public void setWeight(long shortcutPointer, double weight) {
        this.setWeightInt(shortcutPointer, this.weightFromDouble(weight));
    }

    private void setWeightInt(long shortcutPointer, int weightInt) {
        this.shortcuts.setInt(shortcutPointer + (long)this.S_WEIGHT, weightInt);
    }

    public void setSkippedEdges(long shortcutPointer, int edge1, int edge2) {
        this.shortcuts.setInt(shortcutPointer + (long)this.S_SKIP_EDGE1, edge1);
        this.shortcuts.setInt(shortcutPointer + (long)this.S_SKIP_EDGE2, edge2);
    }

    public void setOrigEdges(long shortcutPointer, int origFirst, int origLast) {
        if (!this.edgeBased) {
            throw new IllegalArgumentException("Setting orig edges is only possible for edge-based CH");
        }
        this.shortcuts.setInt(shortcutPointer + (long)this.S_ORIG_FIRST, origFirst);
        this.shortcuts.setInt(shortcutPointer + (long)this.S_ORIG_LAST, origLast);
    }

    public int getNodeA(long shortcutPointer) {
        return this.shortcuts.getInt(shortcutPointer + (long)this.S_NODEA) >>> 1;
    }

    public int getNodeB(long shortcutPointer) {
        return this.shortcuts.getInt(shortcutPointer + (long)this.S_NODEB) >>> 1;
    }

    public boolean getFwdAccess(long shortcutPointer) {
        return (this.shortcuts.getInt(shortcutPointer + (long)this.S_NODEA) & 1) != 0;
    }

    public boolean getBwdAccess(long shortcutPointer) {
        return (this.shortcuts.getInt(shortcutPointer + (long)this.S_NODEB) & 1) != 0;
    }

    public double getWeight(long shortcutPointer) {
        return this.weightToDouble(this.shortcuts.getInt(shortcutPointer + (long)this.S_WEIGHT));
    }

    public int getSkippedEdge1(long shortcutPointer) {
        return this.shortcuts.getInt(shortcutPointer + (long)this.S_SKIP_EDGE1);
    }

    public int getSkippedEdge2(long shortcutPointer) {
        return this.shortcuts.getInt(shortcutPointer + (long)this.S_SKIP_EDGE2);
    }

    public int getOrigEdgeFirst(long shortcutPointer) {
        assert (this.edgeBased) : "orig edges are only available for edge-based CH";
        return this.shortcuts.getInt(shortcutPointer + (long)this.S_ORIG_FIRST);
    }

    public int getOrigEdgeLast(long shortcutPointer) {
        assert (this.edgeBased) : "orig edges are only available for edge-based CH";
        return this.shortcuts.getInt(shortcutPointer + (long)this.S_ORIG_LAST);
    }

    public NodeOrderingProvider getNodeOrderingProvider() {
        int numNodes = this.getNodes();
        int[] nodeOrdering = new int[numNodes];
        int i = 0;
        while (i < numNodes) {
            int level = this.getLevel(this.toNodePointer(i));
            nodeOrdering[level] = i++;
        }
        return NodeOrderingProvider.fromArray(nodeOrdering);
    }

    public void debugPrint() {
        int printMax = 100;
        System.out.println("nodesCH:");
        String formatNodes = "%12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatNodes, "#", "N_LAST_SC", "N_LEVEL");
        for (int i = 0; i < Math.min(this.nodeCount, 100); ++i) {
            long ptr = this.toNodePointer(i);
            System.out.format(Locale.ROOT, formatNodes, i, this.getLastShortcut(ptr), this.getLevel(ptr));
        }
        if (this.nodeCount > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes", this.nodeCount - 100);
        }
        System.out.println("shortcuts:");
        String formatShortcutsBase = "%12s | %12s | %12s | %12s | %12s | %12s";
        String formatShortcutExt = " | %12s | %12s";
        String header = String.format(Locale.ROOT, formatShortcutsBase, "#", "E_NODEA", "E_NODEB", "S_WEIGHT", "S_SKIP_EDGE1", "S_SKIP_EDGE2");
        if (this.isEdgeBased()) {
            header = header + String.format(Locale.ROOT, formatShortcutExt, "S_ORIG_FIRST", "S_ORIG_LAST");
        }
        System.out.println(header);
        for (int i = 0; i < Math.min(this.shortcutCount, 100); ++i) {
            long ptr = this.toShortcutPointer(i);
            String edgeString = String.format(Locale.ROOT, formatShortcutsBase, i, this.getNodeA(ptr), this.getNodeB(ptr), this.getWeight(ptr), this.getSkippedEdge1(ptr), this.getSkippedEdge2(ptr));
            if (this.edgeBased) {
                edgeString = edgeString + String.format(Locale.ROOT, formatShortcutExt, this.getOrigEdgeFirst(ptr), this.getOrigEdgeLast(ptr));
            }
            System.out.println(edgeString);
        }
        if (this.shortcutCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more shortcut edges\n", this.shortcutCount - 100);
        }
    }

    public long getCapacity() {
        return this.nodesCH.getCapacity() + this.shortcuts.getCapacity();
    }

    public int getNumShortcutsExceedingWeight() {
        return this.numShortcutsExceedingWeight;
    }

    public String toDetailsString() {
        return "shortcuts:" + Helper.nf(this.shortcutCount) + " (" + Helper.nf(this.shortcuts.getCapacity() / 0x100000L) + "MB), nodesCH:" + Helper.nf(this.nodeCount) + " (" + Helper.nf(this.nodesCH.getCapacity() / 0x100000L) + "MB)";
    }

    public boolean isClosed() {
        assert (this.nodesCH.isClosed() == this.shortcuts.isClosed());
        return this.nodesCH.isClosed();
    }

    private int weightFromDouble(double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException("weight cannot be negative but was " + weight);
        }
        if (weight < 0.001) {
            weight = 0.001;
        }
        if (weight >= 4294967.294) {
            ++this.numShortcutsExceedingWeight;
            return -2;
        }
        return (int)Math.round(weight * 1000.0);
    }

    private double weightToDouble(int intWeight) {
        long weightLong = (long)intWeight & 0xFFFFFFFFL;
        if (weightLong == 0xFFFFFFFEL) {
            return Double.POSITIVE_INFINITY;
        }
        double weight = (double)weightLong / 1000.0;
        if (weight >= 4294967.294) {
            throw new IllegalArgumentException("too large shortcut weight " + weight + " should get infinity marker bits " + 0xFFFFFFFEL);
        }
        return weight;
    }

    public static class LowWeightShortcut {
        int nodeA;
        int nodeB;
        int shortcut;
        double weight;
        double minWeight;

        public LowWeightShortcut(int nodeA, int nodeB, int shortcut, double weight, double minWeight) {
            this.nodeA = nodeA;
            this.nodeB = nodeB;
            this.shortcut = shortcut;
            this.weight = weight;
            this.minWeight = minWeight;
        }
    }
}

