/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.InstructionsHelper;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.List;

class InstructionsOutgoingEdges {
    private final EdgeIteratorState prevEdge;
    private final EdgeIteratorState currentEdge;
    private final List<EdgeIteratorState> allowedAlternativeTurns;
    private final List<EdgeIteratorState> visibleAlternativeTurns;
    private final DecimalEncodedValue maxSpeedEnc;
    private final DecimalEncodedValue avgSpeedEnc;
    private final EnumEncodedValue<RoadClass> roadClassEnc;
    private final BooleanEncodedValue roadClassLinkEnc;
    private final NodeAccess nodeAccess;

    public InstructionsOutgoingEdges(EdgeIteratorState prevEdge, EdgeIteratorState currentEdge, FlagEncoder encoder, DecimalEncodedValue maxSpeedEnc, EnumEncodedValue<RoadClass> roadClassEnc, BooleanEncodedValue roadClassLinkEnc, EdgeExplorer crossingExplorer, NodeAccess nodeAccess, int prevNode, int baseNode, int adjNode) {
        this.prevEdge = prevEdge;
        this.currentEdge = currentEdge;
        BooleanEncodedValue accessEnc = encoder.getAccessEnc();
        this.maxSpeedEnc = maxSpeedEnc;
        this.avgSpeedEnc = encoder.getAverageSpeedEnc();
        this.roadClassEnc = roadClassEnc;
        this.roadClassLinkEnc = roadClassLinkEnc;
        this.nodeAccess = nodeAccess;
        this.visibleAlternativeTurns = new ArrayList<EdgeIteratorState>();
        this.allowedAlternativeTurns = new ArrayList<EdgeIteratorState>();
        EdgeIterator edgeIter = crossingExplorer.setBaseNode(baseNode);
        while (edgeIter.next()) {
            if (edgeIter.getAdjNode() == prevNode || edgeIter.getAdjNode() == adjNode) continue;
            EdgeIteratorState tmpEdge = edgeIter.detach(false);
            this.visibleAlternativeTurns.add(tmpEdge);
            if (!tmpEdge.get(accessEnc)) continue;
            this.allowedAlternativeTurns.add(tmpEdge);
        }
    }

    public int getAllowedTurns() {
        return 1 + this.allowedAlternativeTurns.size();
    }

    public int getVisibleTurns() {
        return 1 + this.visibleAlternativeTurns.size();
    }

    public boolean outgoingEdgesAreSlowerByFactor(double factor) {
        double tmpSpeed = this.getSpeed(this.currentEdge);
        double pathSpeed = this.getSpeed(this.prevEdge);
        if (pathSpeed != tmpSpeed || pathSpeed < 1.0) {
            return false;
        }
        double maxSurroundingSpeed = -1.0;
        for (EdgeIteratorState edge : this.visibleAlternativeTurns) {
            tmpSpeed = this.getSpeed(edge);
            if (!(tmpSpeed > maxSurroundingSpeed)) continue;
            maxSurroundingSpeed = tmpSpeed;
        }
        return maxSurroundingSpeed * factor < pathSpeed;
    }

    private double getSpeed(EdgeIteratorState edge) {
        double maxSpeed = edge.get(this.maxSpeedEnc);
        if (Double.isInfinite(maxSpeed)) {
            return edge.get(this.avgSpeedEnc);
        }
        return maxSpeed;
    }

    public EdgeIteratorState getOtherContinue(double prevLat, double prevLon, double prevOrientation) {
        for (EdgeIteratorState edge : this.allowedAlternativeTurns) {
            GHPoint point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess);
            int tmpSign = InstructionsHelper.calculateSign(prevLat, prevLon, point.getLat(), point.getLon(), prevOrientation);
            if (Math.abs(tmpSign) > 1) continue;
            return edge;
        }
        return null;
    }

    public boolean isLeavingCurrentStreet(String prevName, String name) {
        if (InstructionsHelper.isNameSimilar(name, prevName)) {
            return false;
        }
        boolean roadClassOrLinkChange = !this.isTheSameRoadClassAndLink(this.prevEdge, this.currentEdge);
        for (EdgeIteratorState edge : this.allowedAlternativeTurns) {
            String edgeName = edge.getName();
            if (InstructionsHelper.isNameSimilar(prevName, edgeName) || roadClassOrLinkChange && this.isTheSameRoadClassAndLink(this.prevEdge, edge)) {
                return true;
            }
            if (!InstructionsHelper.isNameSimilar(name, edgeName) && (!roadClassOrLinkChange || !this.isTheSameRoadClassAndLink(this.currentEdge, edge))) continue;
            return true;
        }
        return false;
    }

    private boolean isTheSameRoadClassAndLink(EdgeIteratorState edge1, EdgeIteratorState edge2) {
        return edge1.get(this.roadClassEnc) == edge2.get(this.roadClassEnc) && edge1.get(this.roadClassLinkEnc) == edge2.get(this.roadClassLinkEnc);
    }
}

