/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.config.Profile;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.CurvatureWeighting;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.routing.weighting.ShortFastestWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomProfile;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class DefaultWeightingFactory
implements WeightingFactory {
    private final GraphHopperStorage ghStorage;
    private final EncodingManager encodingManager;

    public DefaultWeightingFactory(GraphHopperStorage ghStorage, EncodingManager encodingManager) {
        this.ghStorage = ghStorage;
        this.encodingManager = encodingManager;
    }

    @Override
    public Weighting createWeighting(Profile profile, PMap requestHints, boolean disableTurnCosts) {
        TurnCostProvider turnCostProvider;
        PMap hints = new PMap();
        hints.putAll(profile.getHints());
        hints.putAll(requestHints);
        FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
        if (profile.isTurnCosts() && !disableTurnCosts) {
            if (!encoder.supportsTurnCosts()) {
                throw new IllegalArgumentException("Encoder " + encoder + " does not support turn costs");
            }
            int uTurnCosts = hints.getInt("u_turn_costs", -1);
            turnCostProvider = new DefaultTurnCostProvider(encoder, this.ghStorage.getTurnCostStorage(), uTurnCosts);
        } else {
            turnCostProvider = TurnCostProvider.NO_TURN_COST_PROVIDER;
        }
        String weightingStr = Helper.toLowerCase(profile.getWeighting());
        if (weightingStr.isEmpty()) {
            throw new IllegalArgumentException("You have to specify a weighting");
        }
        AbstractWeighting weighting = null;
        if ("custom".equalsIgnoreCase(weightingStr)) {
            if (!(profile instanceof CustomProfile)) {
                throw new IllegalArgumentException("custom weighting requires a CustomProfile but was profile=" + profile.getName());
            }
            CustomModel queryCustomModel = requestHints.getObject("custom_model", null);
            CustomProfile customProfile = (CustomProfile)profile;
            if (queryCustomModel != null) {
                queryCustomModel.checkLMConstraints(customProfile.getCustomModel());
            }
            queryCustomModel = CustomModel.merge(customProfile.getCustomModel(), queryCustomModel);
            weighting = CustomModelParser.createWeighting(encoder, this.encodingManager, turnCostProvider, queryCustomModel);
        } else if ("shortest".equalsIgnoreCase(weightingStr)) {
            weighting = new ShortestWeighting(encoder, turnCostProvider);
        } else if ("fastest".equalsIgnoreCase(weightingStr)) {
            weighting = encoder.supports(PriorityWeighting.class) ? new PriorityWeighting(encoder, hints, turnCostProvider) : new FastestWeighting(encoder, hints, turnCostProvider);
        } else if ("curvature".equalsIgnoreCase(weightingStr)) {
            if (encoder.supports(CurvatureWeighting.class)) {
                weighting = new CurvatureWeighting(encoder, hints, turnCostProvider);
            }
        } else if ("short_fastest".equalsIgnoreCase(weightingStr)) {
            weighting = new ShortFastestWeighting(encoder, hints, turnCostProvider);
        }
        if (weighting == null) {
            throw new IllegalArgumentException("Weighting '" + weightingStr + "' not supported");
        }
        return weighting;
    }
}

