/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.pbf;

import com.graphhopper.reader.osm.pbf.PbfDecoder;
import com.graphhopper.reader.osm.pbf.PbfStreamSplitter;
import com.graphhopper.reader.osm.pbf.Sink;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PbfReader
implements Runnable {
    private Throwable throwable;
    private InputStream inputStream;
    private Sink sink;
    private int workers;

    public PbfReader(InputStream in, Sink sink, int workers) {
        this.inputStream = in;
        this.sink = sink;
        this.workers = workers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.workers);
        PbfStreamSplitter streamSplitter = new PbfStreamSplitter(new DataInputStream(this.inputStream));
        try {
            PbfDecoder pbfDecoder = new PbfDecoder(streamSplitter, executorService, this.workers + 1, this.sink);
            pbfDecoder.run();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        finally {
            this.sink.complete();
            executorService.shutdownNow();
            streamSplitter.release();
        }
    }

    public void close() {
        if (this.throwable != null) {
            throw new RuntimeException("Unable to read PBF file.", this.throwable);
        }
    }
}

