/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Transfer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Transfers {
    private final Map<String, List<Transfer>> transfersFromStop;
    private final Map<String, List<Transfer>> transfersToStop;
    private final Map<String, Set<String>> routesByStop;

    public Transfers(GTFSFeed feed) {
        this.transfersToStop = feed.transfers.values().stream().collect(Collectors.groupingBy(t -> t.to_stop_id));
        this.transfersFromStop = feed.transfers.values().stream().collect(Collectors.groupingBy(t -> t.from_stop_id));
        this.routesByStop = feed.stop_times.values().stream().collect(Collectors.groupingBy(stopTime -> stopTime.stop_id, Collectors.mapping(stopTime -> feed.trips.get((Object)stopTime.trip_id).route_id, Collectors.toSet())));
    }

    List<Transfer> getTransfersToStop(String toStopId, String toRouteId) {
        List allInboundTransfers = this.transfersToStop.getOrDefault(toStopId, Collections.emptyList());
        Map<String, List<Transfer>> byFromStop = allInboundTransfers.stream().filter(t -> t.transfer_type == 0 || t.transfer_type == 2).filter(t -> t.to_route_id == null || toRouteId.equals(t.to_route_id)).collect(Collectors.groupingBy(t -> t.from_stop_id));
        ArrayList<Transfer> result = new ArrayList<Transfer>();
        byFromStop.forEach((fromStop, transfers) -> {
            if (this.hasNoRouteSpecificArrivalTransferRules((String)fromStop)) {
                Transfer myRule = new Transfer();
                myRule.from_stop_id = fromStop;
                myRule.to_stop_id = toStopId;
                if (transfers.size() == 1) {
                    myRule.min_transfer_time = ((Transfer)transfers.get((int)0)).min_transfer_time;
                }
                result.add(myRule);
            } else {
                this.routesByStop.getOrDefault(fromStop, Collections.emptySet()).forEach(fromRoute -> {
                    Transfer mostSpecificRule = this.findMostSpecificRule((List<Transfer>)transfers, (String)fromRoute, toRouteId);
                    Transfer myRule = new Transfer();
                    myRule.to_route_id = toRouteId;
                    myRule.from_route_id = fromRoute;
                    myRule.to_stop_id = mostSpecificRule.to_stop_id;
                    myRule.from_stop_id = mostSpecificRule.from_stop_id;
                    myRule.transfer_type = mostSpecificRule.transfer_type;
                    myRule.min_transfer_time = mostSpecificRule.min_transfer_time;
                    myRule.from_trip_id = mostSpecificRule.from_trip_id;
                    myRule.to_trip_id = mostSpecificRule.to_trip_id;
                    result.add(myRule);
                });
            }
        });
        if (result.stream().noneMatch(t -> t.from_stop_id.equals(toStopId))) {
            Transfer withinStationTransfer = new Transfer();
            withinStationTransfer.from_stop_id = toStopId;
            withinStationTransfer.to_stop_id = toStopId;
            result.add(withinStationTransfer);
        }
        return result;
    }

    List<Transfer> getTransfersFromStop(String fromStopId, String fromRouteId) {
        List allOutboundTransfers = this.transfersFromStop.getOrDefault(fromStopId, Collections.emptyList());
        Map<String, List<Transfer>> byToStop = allOutboundTransfers.stream().filter(t -> t.transfer_type == 0 || t.transfer_type == 2).filter(t -> t.from_route_id == null || fromRouteId.equals(t.from_route_id)).collect(Collectors.groupingBy(t -> t.to_stop_id));
        ArrayList<Transfer> result = new ArrayList<Transfer>();
        byToStop.forEach((toStop, transfers) -> this.routesByStop.getOrDefault(toStop, Collections.emptySet()).forEach(toRouteId -> {
            Transfer mostSpecificRule = this.findMostSpecificRule((List<Transfer>)transfers, fromRouteId, (String)toRouteId);
            Transfer myRule = new Transfer();
            myRule.to_route_id = toRouteId;
            myRule.from_route_id = fromRouteId;
            myRule.to_stop_id = mostSpecificRule.to_stop_id;
            myRule.from_stop_id = mostSpecificRule.from_stop_id;
            myRule.transfer_type = mostSpecificRule.transfer_type;
            myRule.min_transfer_time = mostSpecificRule.min_transfer_time;
            myRule.from_trip_id = mostSpecificRule.from_trip_id;
            myRule.to_trip_id = mostSpecificRule.to_trip_id;
            result.add(myRule);
        }));
        return result;
    }

    private Transfer findMostSpecificRule(List<Transfer> transfers, String fromRouteId, String toRouteId) {
        ArrayList<Transfer> transfersBySpecificity = new ArrayList<Transfer>(transfers);
        transfersBySpecificity.sort(Comparator.comparingInt(t -> {
            int score = 0;
            if (Objects.equals(fromRouteId, t.from_route_id)) {
                ++score;
            }
            if (Objects.equals(toRouteId, t.to_route_id)) {
                ++score;
            }
            return -score;
        }));
        if (transfersBySpecificity.isEmpty()) {
            throw new RuntimeException();
        }
        return transfersBySpecificity.get(0);
    }

    public boolean hasNoRouteSpecificDepartureTransferRules(String stop_id) {
        return this.transfersToStop.getOrDefault(stop_id, Collections.emptyList()).stream().allMatch(transfer -> transfer.to_route_id == null);
    }

    public boolean hasNoRouteSpecificArrivalTransferRules(String stop_id) {
        return this.transfersFromStop.getOrDefault(stop_id, Collections.emptyList()).stream().allMatch(transfer -> transfer.from_route_id == null);
    }
}

