/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class Profile {
    private String name = "car";
    private String vehicle = "car";
    private String weighting = "fastest";
    private boolean turnCosts = false;
    private PMap hints = new PMap();

    public static void validateProfileName(String profileName) {
        if (!profileName.matches("^[a-z0-9_\\-]+$")) {
            throw new IllegalArgumentException("Profile names may only contain lower case letters, numbers and underscores, given: " + profileName);
        }
    }

    private Profile() {
    }

    public Profile(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public Profile setName(String name) {
        Profile.validateProfileName(name);
        this.name = name;
        return this;
    }

    public String getVehicle() {
        return this.vehicle;
    }

    public Profile setVehicle(String vehicle) {
        this.vehicle = vehicle;
        return this;
    }

    public String getWeighting() {
        return this.weighting;
    }

    public Profile setWeighting(String weighting) {
        this.weighting = weighting;
        return this;
    }

    public boolean isTurnCosts() {
        return this.turnCosts;
    }

    public Profile setTurnCosts(boolean turnCosts) {
        this.turnCosts = turnCosts;
        return this;
    }

    @JsonIgnore
    public PMap getHints() {
        return this.hints;
    }

    @JsonAnySetter
    public Profile putHint(String key, Object value) {
        this.hints.putObject(key, value);
        return this;
    }

    public String toString() {
        return this.createContentString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return this.name.equals(profile.name);
    }

    private String createContentString() {
        return "name=" + this.name + "|vehicle=" + this.vehicle + "|weighting=" + this.weighting + "|turnCosts=" + this.turnCosts + "|hints=" + this.hints;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getVersion() {
        return Helper.staticHashCode(this.createContentString());
    }
}

