/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.params;

import io.dropwizard.jersey.DefaultValueUtils;
import io.dropwizard.jersey.params.AbstractParam;
import io.dropwizard.jersey.params.AbstractParamConverter;
import io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class AbstractParamConverterProvider
implements ParamConverterProvider {
    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (AbstractParam.class.isAssignableFrom(rawType)) {
            Constructor<T> constructor;
            String parameterName = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse("Parameter");
            try {
                constructor = rawType.getConstructor(String.class, String.class);
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
            String defaultValue = DefaultValueUtils.getDefaultValue(annotations);
            return new AbstractParamConverter<T>(constructor, parameterName, defaultValue);
        }
        return null;
    }
}

