/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.MMapDataAccess;
import com.graphhopper.storage.RAMDataAccess;
import com.graphhopper.storage.RAMIntDataAccess;
import com.graphhopper.util.Helper;
import java.io.File;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GHDirectory
implements Directory {
    protected final String location;
    private final DAType defaultType;
    private final ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    protected Map<String, DataAccess> map = new HashMap<String, DataAccess>();
    protected Map<String, DAType> types = new HashMap<String, DAType>();

    public GHDirectory(String _location, DAType defaultType) {
        this.defaultType = defaultType;
        if (Helper.isEmpty(_location)) {
            _location = new File("").getAbsolutePath();
        }
        if (!_location.endsWith("/")) {
            _location = _location + "/";
        }
        this.location = _location;
        File dir = new File(this.location);
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeException("file '" + dir + "' exists but is not a directory");
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public Directory put(String name, DAType type) {
        if (!name.equals(Helper.toLowerCase(name))) {
            throw new IllegalArgumentException("Since 0.7 DataAccess objects does no longer accept upper case names");
        }
        this.types.put(name, type);
        return this;
    }

    @Override
    public DataAccess find(String name) {
        DAType type = this.types.get(name);
        if (type == null) {
            type = this.defaultType;
        }
        return this.find(name, type);
    }

    @Override
    public DataAccess find(String name, DAType type) {
        if (!name.equals(Helper.toLowerCase(name))) {
            throw new IllegalArgumentException("Since 0.7 DataAccess objects does no longer accept upper case names");
        }
        DataAccess da = this.map.get(name);
        if (da != null) {
            if (!type.equals(da.getType())) {
                throw new IllegalStateException("Found existing DataAccess object '" + name + "' but types did not match. Requested:" + type + ", was:" + da.getType());
            }
            return da;
        }
        if (type.isInMemory()) {
            da = type.isInteg() ? (type.isStoring() ? new RAMIntDataAccess(name, this.location, true, this.byteOrder) : new RAMIntDataAccess(name, this.location, false, this.byteOrder)) : (type.isStoring() ? new RAMDataAccess(name, this.location, true, this.byteOrder) : new RAMDataAccess(name, this.location, false, this.byteOrder));
        } else if (type.isMMap()) {
            da = new MMapDataAccess(name, this.location, this.byteOrder, type.isAllowWrites());
        } else {
            throw new IllegalArgumentException("DAType not supported " + type);
        }
        this.map.put(name, da);
        return da;
    }

    @Override
    public void close() {
        for (DataAccess da : this.map.values()) {
            da.close();
        }
        this.map.clear();
    }

    @Override
    public void clear() {
        for (DataAccess da : this.map.values()) {
            da.close();
            this.removeBackingFile(da, da.getName());
        }
        this.map.clear();
    }

    @Override
    public void remove(DataAccess da) {
        DataAccess old = this.map.remove(da.getName());
        if (old == null) {
            throw new IllegalStateException("Couldn't remove DataAccess: " + da.getName());
        }
        da.close();
        this.removeBackingFile(da, da.getName());
    }

    private void removeBackingFile(DataAccess da, String name) {
        if (da.getType().isStoring()) {
            Helper.removeDir(new File(this.location + name));
        }
    }

    @Override
    public DAType getDefaultType() {
        return this.defaultType;
    }

    public boolean isStoring() {
        return this.defaultType.isStoring();
    }

    @Override
    public Directory create() {
        if (this.isStoring()) {
            new File(this.location).mkdirs();
        }
        return this;
    }

    @Override
    public Collection<DataAccess> getAll() {
        return this.map.values();
    }

    public String toString() {
        return this.getLocation();
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

