/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.util.EdgeIteratorState;

public final class CustomWeighting
extends AbstractWeighting {
    public static final String NAME = "custom";
    private static final double SPEED_CONV = 3.6;
    private final BooleanEncodedValue baseVehicleAccessEnc;
    private final double maxSpeed;
    private final double maxPriority;
    private final double distanceInfluence;
    private final double headingPenaltySeconds;
    private final EdgeToDoubleMapping edgeToSpeedMapping;
    private final EdgeToDoubleMapping edgeToPriorityMapping;

    public CustomWeighting(FlagEncoder baseFlagEncoder, TurnCostProvider turnCostProvider, Parameters parameters) {
        super(baseFlagEncoder, turnCostProvider);
        this.edgeToSpeedMapping = parameters.getEdgeToSpeedMapping();
        this.edgeToPriorityMapping = parameters.getEdgeToPriorityMapping();
        this.baseVehicleAccessEnc = baseFlagEncoder.getAccessEnc();
        this.headingPenaltySeconds = parameters.getHeadingPenaltySeconds();
        this.maxSpeed = parameters.getMaxSpeed() / 3.6;
        this.maxPriority = parameters.getMaxPriority();
        this.distanceInfluence = parameters.getDistanceInfluence() / 1000.0;
        if (this.distanceInfluence < 0.0) {
            throw new IllegalArgumentException("distance_influence cannot be negative " + this.distanceInfluence);
        }
    }

    @Override
    public double getMinWeight(double distance) {
        return distance / this.maxSpeed / this.maxPriority + distance * this.distanceInfluence;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double distance = edgeState.getDistance();
        double seconds = this.calcSeconds(distance, edgeState, reverse);
        if (Double.isInfinite(seconds)) {
            return Double.POSITIVE_INFINITY;
        }
        double distanceCosts = distance * this.distanceInfluence;
        if (Double.isInfinite(distanceCosts)) {
            return Double.POSITIVE_INFINITY;
        }
        double priority = this.edgeToPriorityMapping.get(edgeState, reverse);
        return seconds / priority + distanceCosts;
    }

    double calcSeconds(double distance, EdgeIteratorState edgeState, boolean reverse) {
        if (edgeState.getBaseNode() == edgeState.getAdjNode()) {
            reverse = false;
        }
        if (reverse ? !edgeState.getReverse(this.baseVehicleAccessEnc) : !edgeState.get(this.baseVehicleAccessEnc)) {
            return Double.POSITIVE_INFINITY;
        }
        double speed = this.edgeToSpeedMapping.get(edgeState, reverse);
        if (speed > this.maxSpeed * 3.6) {
            throw new IllegalStateException("for " + this.getName() + " speed <= maxSpeed is violated, " + speed + " <= " + this.maxSpeed * 3.6);
        }
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (speed < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        double seconds = distance / speed * 3.6;
        return edgeState.get(EdgeIteratorState.UNFAVORED_EDGE) ? seconds + this.headingPenaltySeconds : seconds;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        return Math.round(this.calcSeconds(edgeState.getDistance(), edgeState, reverse) * 1000.0);
    }

    @Override
    public String getName() {
        return NAME;
    }

    static class Parameters {
        private final EdgeToDoubleMapping edgeToSpeedMapping;
        private final EdgeToDoubleMapping edgeToPriorityMapping;
        private final double maxSpeed;
        private final double maxPriority;
        private final double distanceInfluence;
        private final double headingPenaltySeconds;

        Parameters(EdgeToDoubleMapping edgeToSpeedMapping, EdgeToDoubleMapping edgeToPriorityMapping, double maxSpeed, double maxPriority, double distanceInfluence, double headingPenaltySeconds) {
            this.edgeToSpeedMapping = edgeToSpeedMapping;
            this.edgeToPriorityMapping = edgeToPriorityMapping;
            this.maxSpeed = maxSpeed;
            this.maxPriority = maxPriority;
            this.distanceInfluence = distanceInfluence;
            this.headingPenaltySeconds = headingPenaltySeconds;
        }

        public EdgeToDoubleMapping getEdgeToSpeedMapping() {
            return this.edgeToSpeedMapping;
        }

        public EdgeToDoubleMapping getEdgeToPriorityMapping() {
            return this.edgeToPriorityMapping;
        }

        public double getMaxSpeed() {
            return this.maxSpeed;
        }

        public double getDistanceInfluence() {
            return this.distanceInfluence;
        }

        public double getHeadingPenaltySeconds() {
            return this.headingPenaltySeconds;
        }

        public double getMaxPriority() {
            return this.maxPriority;
        }
    }

    @FunctionalInterface
    public static interface EdgeToDoubleMapping {
        public double get(EdgeIteratorState var1, boolean var2);
    }
}

