/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.routing.weighting.custom.CustomWeightingHelper;
import com.graphhopper.routing.weighting.custom.ExpressionVisitor;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Polygon;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.io.Readers;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.SimpleCompiler;
import org.codehaus.janino.Unparser;
import org.codehaus.janino.util.DeepCopier;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.slf4j.LoggerFactory;

public class CustomModelParser {
    private static final AtomicLong longVal = new AtomicLong(1L);
    static final String IN_AREA_PREFIX = "in_";
    private static final Set<String> allowedNames = new HashSet<String>(Arrays.asList("edge", "Math"));
    private static final boolean JANINO_DEBUG = Boolean.getBoolean("org.codehaus.janino.source_debugging.enable");
    private static final String SCRIPT_FILE_DIR = System.getProperty("org.codehaus.janino.source_debugging.dir", "./src/main/java/com/graphhopper/routing/weighting/custom");
    private static final int CACHE_SIZE = Integer.getInteger("graphhopper.custom_weighting.cache_size", 1000);
    private static final Map<String, Class<?>> CACHE = Collections.synchronizedMap(new LinkedHashMap<String, Class<?>>(CACHE_SIZE, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > CACHE_SIZE;
        }
    });
    private static final Map<String, Class<?>> INTERNAL_CACHE = Collections.synchronizedMap(new HashMap());

    private CustomModelParser() {
    }

    public static CustomWeighting createWeighting(FlagEncoder baseFlagEncoder, EncodedValueLookup lookup, TurnCostProvider turnCostProvider, CustomModel customModel) {
        if (customModel == null) {
            throw new IllegalStateException("CustomModel cannot be null");
        }
        DecimalEncodedValue avgSpeedEnc = lookup.getDecimalEncodedValue(EncodingManager.getKey(baseFlagEncoder.toString(), "average_speed"));
        String pKey = EncodingManager.getKey(baseFlagEncoder.toString(), "priority");
        DecimalEncodedValue priorityEnc = lookup.hasEncodedValue(pKey) ? lookup.getDecimalEncodedValue(pKey) : null;
        CustomWeighting.Parameters parameters = CustomModelParser.createWeightingParameters(customModel, lookup, avgSpeedEnc, baseFlagEncoder.getMaxSpeed(), priorityEnc);
        return new CustomWeighting(baseFlagEncoder, turnCostProvider, parameters);
    }

    static CustomWeighting.Parameters createWeightingParameters(CustomModel customModel, EncodedValueLookup lookup, DecimalEncodedValue avgSpeedEnc, double globalMaxSpeed, DecimalEncodedValue priorityEnc) {
        Class<?> clazz;
        double maxSpeed = customModel.findMaxSpeed(globalMaxSpeed);
        double maxPriority = customModel.findMaxPriority(priorityEnc == null ? 1.0 : priorityEnc.getMaxDecimal());
        String key = customModel.toString() + ",maxSpeed:" + maxSpeed + ",maxPriority:" + maxPriority;
        if (key.length() > 100000) {
            throw new IllegalArgumentException("Custom Model too big: " + key.length());
        }
        Class<?> clazz2 = clazz = customModel.isInternal() ? INTERNAL_CACHE.get(key) : null;
        if (CACHE_SIZE > 0 && clazz == null) {
            clazz = CACHE.get(key);
        }
        if (clazz == null) {
            clazz = CustomModelParser.createClazz(customModel, lookup, maxSpeed);
            if (customModel.isInternal()) {
                INTERNAL_CACHE.put(key, clazz);
                if (INTERNAL_CACHE.size() > 100) {
                    CACHE.putAll(INTERNAL_CACHE);
                    INTERNAL_CACHE.clear();
                    LoggerFactory.getLogger(CustomModelParser.class).warn("Internal cache must stay small but was " + INTERNAL_CACHE.size() + ". Cleared it. Misuse of CustomModel::__internal_cache?");
                }
            } else if (CACHE_SIZE > 0) {
                CACHE.put(key, clazz);
            }
        }
        try {
            CustomWeightingHelper prio = (CustomWeightingHelper)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            prio.init(lookup, avgSpeedEnc, priorityEnc, customModel.getAreas());
            return new CustomWeighting.Parameters(prio::getSpeed, prio::getPriority, maxSpeed, maxPriority, customModel.getDistanceInfluence(), customModel.getHeadingPenalty());
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("Cannot compile expression " + ex.getMessage(), ex);
        }
    }

    private static Class<?> createClazz(CustomModel customModel, EncodedValueLookup lookup, double globalMaxSpeed) {
        try {
            LinkedHashSet<String> priorityVariables = new LinkedHashSet<String>();
            List<Java.BlockStatement> priorityStatements = CustomModelParser.createGetPriorityStatements(priorityVariables, customModel, lookup);
            LinkedHashSet<String> speedVariables = new LinkedHashSet<String>();
            List<Java.BlockStatement> speedStatements = CustomModelParser.createGetSpeedStatements(speedVariables, customModel, lookup, globalMaxSpeed);
            long counter = longVal.incrementAndGet();
            String classTemplate = CustomModelParser.createClassTemplate(counter, priorityVariables, speedVariables, lookup, customModel);
            Java.CompilationUnit cu = (Java.CompilationUnit)new Parser(new Scanner("source", new StringReader(classTemplate))).parseAbstractCompilationUnit();
            cu = CustomModelParser.injectStatements(priorityStatements, speedStatements, cu);
            SimpleCompiler sc = CustomModelParser.createCompiler(counter, cu);
            return sc.getClassLoader().loadClass("com.graphhopper.routing.weighting.custom.JaninoCustomWeightingHelperSubclass" + counter);
        }
        catch (Exception ex) {
            String errString = "Cannot compile expression";
            if (ex instanceof CompileException) {
                errString = errString + ", in " + ((CompileException)ex).getLocation().getFileName();
            }
            throw new IllegalArgumentException(errString + ": " + ex.getMessage(), ex);
        }
    }

    private static List<Java.BlockStatement> createGetSpeedStatements(Set<String> speedVariables, CustomModel customModel, EncodedValueLookup lookup, double globalMaxSpeed) throws Exception {
        ArrayList<Java.BlockStatement> speedStatements = new ArrayList<Java.BlockStatement>();
        speedStatements.addAll(CustomModelParser.verifyExpressions(new StringBuilder(), "in 'speed' entry, ", speedVariables, customModel.getSpeed(), lookup, "return Math.min(value, " + globalMaxSpeed + ");\n"));
        String speedMethodStartBlock = "double value = super.getRawSpeed(edge, reverse);\n";
        for (String arg : speedVariables) {
            speedMethodStartBlock = speedMethodStartBlock + CustomModelParser.getVariableDeclaration(lookup, arg);
        }
        speedStatements.addAll(0, new Parser(new Scanner("getSpeed", new StringReader(speedMethodStartBlock))).parseBlockStatements());
        return speedStatements;
    }

    private static List<Java.BlockStatement> createGetPriorityStatements(Set<String> priorityVariables, CustomModel customModel, EncodedValueLookup lookup) throws Exception {
        ArrayList<Java.BlockStatement> priorityStatements = new ArrayList<Java.BlockStatement>();
        priorityStatements.addAll(CustomModelParser.verifyExpressions(new StringBuilder(), "in 'priority' entry, ", priorityVariables, customModel.getPriority(), lookup, "return value;"));
        String priorityMethodStartBlock = "double value = super.getRawPriority(edge, reverse);\n";
        for (String arg : priorityVariables) {
            priorityMethodStartBlock = priorityMethodStartBlock + CustomModelParser.getVariableDeclaration(lookup, arg);
        }
        priorityStatements.addAll(0, new Parser(new Scanner("getPriority", new StringReader(priorityMethodStartBlock))).parseBlockStatements());
        return priorityStatements;
    }

    static boolean isValidVariableName(String name) {
        return name.startsWith(IN_AREA_PREFIX) || allowedNames.contains(name);
    }

    private static String getVariableDeclaration(EncodedValueLookup lookup, String arg) {
        if (lookup.hasEncodedValue(arg)) {
            EncodedValue enc = lookup.getEncodedValue(arg, EncodedValue.class);
            return CustomModelParser.getReturnType(enc) + " " + arg + " = reverse ? edge.getReverse((" + CustomModelParser.getInterface(enc) + ") this." + arg + "_enc) : edge.get((" + CustomModelParser.getInterface(enc) + ") this." + arg + "_enc);\n";
        }
        if (CustomModelParser.isValidVariableName(arg)) {
            return "";
        }
        throw new IllegalArgumentException("Not supported " + arg);
    }

    private static String getInterface(EncodedValue enc) {
        if (enc instanceof StringEncodedValue) {
            return IntEncodedValue.class.getSimpleName();
        }
        if (enc.getClass().getInterfaces().length == 0) {
            return enc.getClass().getSimpleName();
        }
        return enc.getClass().getInterfaces()[0].getSimpleName();
    }

    private static String getReturnType(EncodedValue encodedValue) {
        String name = encodedValue.getClass().getSimpleName();
        if (name.contains("Enum")) {
            return "Enum";
        }
        if (name.contains("String")) {
            return "int";
        }
        if (name.contains("Decimal")) {
            return "double";
        }
        if (name.contains("Int")) {
            return "int";
        }
        if (name.contains("Boolean")) {
            return "boolean";
        }
        throw new IllegalArgumentException("Unsupported EncodedValue: " + encodedValue.getClass());
    }

    private static String createClassTemplate(long counter, Set<String> priorityVariables, Set<String> speedVariables, EncodedValueLookup lookup, CustomModel customModel) {
        StringBuilder importSourceCode = new StringBuilder("import com.graphhopper.routing.ev.*;\n");
        importSourceCode.append("import java.util.Map;\n");
        StringBuilder classSourceCode = new StringBuilder(100);
        boolean includedAreaImports = false;
        StringBuilder initSourceCode = new StringBuilder("this.avg_speed_enc = avgSpeedEnc;\n");
        initSourceCode.append("this.priority_enc = priorityEnc;\n");
        HashSet<String> set = new HashSet<String>(priorityVariables);
        set.addAll(speedVariables);
        for (String arg : set) {
            if (lookup.hasEncodedValue(arg)) {
                EncodedValue enc = lookup.getEncodedValue(arg, EncodedValue.class);
                classSourceCode.append("protected " + CustomModelParser.getInterface(enc) + " " + arg + "_enc;\n");
                initSourceCode.append("if (lookup.hasEncodedValue(\"" + arg + "\")) ");
                initSourceCode.append("this." + arg + "_enc = (" + CustomModelParser.getInterface(enc) + ") lookup.getEncodedValue(\"" + arg + "\", EncodedValue.class);\n");
                continue;
            }
            if (arg.startsWith(IN_AREA_PREFIX)) {
                String id;
                if (!includedAreaImports) {
                    importSourceCode.append("import " + BBox.class.getName() + ";\n");
                    importSourceCode.append("import " + GHUtility.class.getName() + ";\n");
                    importSourceCode.append("import " + PreparedPolygon.class.getName() + ";\n");
                    importSourceCode.append("import " + Polygonal.class.getName() + ";\n");
                    importSourceCode.append("import " + JsonFeature.class.getName() + ";\n");
                    importSourceCode.append("import " + Polygon.class.getName() + ";\n");
                    includedAreaImports = true;
                }
                if (!EncodingManager.isValidEncodedValue(id = arg.substring(IN_AREA_PREFIX.length()))) {
                    throw new IllegalArgumentException("Area has invalid name: " + arg);
                }
                JsonFeature feature = customModel.getAreas().get(id);
                if (feature == null) {
                    throw new IllegalArgumentException("Area '" + id + "' wasn't found");
                }
                if (feature.getGeometry() == null) {
                    throw new IllegalArgumentException("Area '" + id + "' does not contain a geometry");
                }
                if (!(feature.getGeometry() instanceof Polygonal)) {
                    throw new IllegalArgumentException("Currently only type=Polygon is supported for areas but was " + feature.getGeometry().getGeometryType());
                }
                if (feature.getProperties() != null && !feature.getProperties().isEmpty() || feature.getBBox() != null) {
                    throw new IllegalArgumentException("Bounding box and properties of area " + id + " must be empty");
                }
                classSourceCode.append("protected " + Polygon.class.getSimpleName() + " " + arg + ";\n");
                initSourceCode.append("JsonFeature feature_" + id + " = (JsonFeature) areas.get(\"" + id + "\");\n");
                initSourceCode.append("this." + arg + " = new Polygon(new PreparedPolygon((Polygonal) feature_" + id + ".getGeometry()));\n");
                continue;
            }
            if (CustomModelParser.isValidVariableName(arg)) continue;
            throw new IllegalArgumentException("Variable not supported: " + arg);
        }
        return "package com.graphhopper.routing.weighting.custom;import " + CustomWeightingHelper.class.getName() + ";\nimport " + EncodedValueLookup.class.getName() + ";\nimport " + EdgeIteratorState.class.getName() + ";\n" + importSourceCode + "\npublic class JaninoCustomWeightingHelperSubclass" + counter + " extends " + CustomWeightingHelper.class.getSimpleName() + " {\n" + classSourceCode + "   @Override\n   public void init(EncodedValueLookup lookup, " + DecimalEncodedValue.class.getName() + " avgSpeedEnc, " + DecimalEncodedValue.class.getName() + " priorityEnc, Map<String, " + JsonFeature.class.getName() + "> areas) {\n" + initSourceCode + "   }\n\n   @Override\n   public double getPriority(EdgeIteratorState edge, boolean reverse) {\n      return 1; //will be overwritten by code injected in DeepCopier\n   }\n   @Override\n   public double getSpeed(EdgeIteratorState edge, boolean reverse) {\n      return getRawSpeed(edge, reverse); //will be overwritten by code injected in DeepCopier\n   }\n}";
    }

    private static List<Java.BlockStatement> verifyExpressions(StringBuilder expressions, String info, Set<String> createObjects, List<Statement> list, EncodedValueLookup lookup, String lastStmt) throws Exception {
        ExpressionVisitor.NameValidator nameInConditionValidator = name -> lookup.hasEncodedValue(name) || name.toUpperCase(Locale.ROOT).equals(name) || CustomModelParser.isValidVariableName(name);
        ExpressionVisitor.parseExpressions(expressions, nameInConditionValidator, info, createObjects, list, lookup, lastStmt);
        return new Parser(new Scanner(info, new StringReader(expressions.toString()))).parseBlockStatements();
    }

    private static Java.CompilationUnit injectStatements(final List<Java.BlockStatement> priorityStatements, final List<Java.BlockStatement> speedStatements, Java.CompilationUnit cu) throws CompileException {
        cu = new DeepCopier(){
            boolean speedInjected = false;
            boolean priorityInjected = false;

            @Override
            public Java.FieldDeclaration copyFieldDeclaration(Java.FieldDeclaration subject) throws CompileException {
                Java.FieldDeclaration fd = super.copyFieldDeclaration(subject);
                fd.setEnclosingScope(subject.getEnclosingScope());
                return fd;
            }

            @Override
            public Java.MethodDeclarator copyMethodDeclarator(Java.MethodDeclarator subject) throws CompileException {
                if (subject.name.equals("getSpeed") && !speedStatements.isEmpty() && !this.speedInjected) {
                    this.speedInjected = true;
                    return CustomModelParser.injectStatements(subject, this, speedStatements);
                }
                if (subject.name.equals("getPriority") && !priorityStatements.isEmpty() && !this.priorityInjected) {
                    this.priorityInjected = true;
                    return CustomModelParser.injectStatements(subject, this, priorityStatements);
                }
                return super.copyMethodDeclarator(subject);
            }
        }.copyCompilationUnit(cu);
        return cu;
    }

    private static Java.MethodDeclarator injectStatements(Java.MethodDeclarator subject, DeepCopier deepCopier, List<Java.BlockStatement> statements) {
        try {
            if (statements.isEmpty()) {
                throw new IllegalArgumentException("Statements cannot be empty when copying method");
            }
            Java.MethodDeclarator methodDecl = new Java.MethodDeclarator(new Location("m1", 1, 1), subject.getDocComment(), deepCopier.copyModifiers(subject.getModifiers()), deepCopier.copyOptionalTypeParameters(subject.typeParameters), deepCopier.copyType(subject.type), subject.name, deepCopier.copyFormalParameters(subject.formalParameters), deepCopier.copyTypes(subject.thrownExceptions), deepCopier.copyOptionalElementValue(subject.defaultValue), deepCopier.copyOptionalStatements(statements));
            statements.forEach(st -> st.setEnclosingScope(methodDecl));
            return methodDecl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static SimpleCompiler createCompiler(long counter, Java.AbstractCompilationUnit cu) throws CompileException {
        if (JANINO_DEBUG) {
            try {
                StringWriter sw = new StringWriter();
                Unparser.unparse(cu, sw);
                File dir = new File(SCRIPT_FILE_DIR);
                File temporaryFile = new File(dir, "JaninoCustomWeightingHelperSubclass" + counter + ".java");
                Reader reader = Readers.teeReader(new StringReader(sw.toString()), new FileWriter(temporaryFile), true);
                return new SimpleCompiler(temporaryFile.getAbsolutePath(), reader);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        SimpleCompiler compiler = new SimpleCompiler();
        compiler.cook(cu);
        return compiler;
    }
}

