/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.GetOffBike;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class OSMGetOffBikeParser
implements TagParser {
    private final HashSet<String> pushBikeHighwayTags = new HashSet();
    private final List<String> accepted = Arrays.asList("designated", "yes");
    private final BooleanEncodedValue offBikeEnc;

    public OSMGetOffBikeParser() {
        this(GetOffBike.create(), Arrays.asList("path", "footway", "pedestrian", "platform"));
    }

    public OSMGetOffBikeParser(BooleanEncodedValue enc, List<String> pushBikeTags) {
        this.offBikeEnc = enc;
        this.pushBikeHighwayTags.addAll(pushBikeTags);
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> registerNewEncodedValue) {
        registerNewEncodedValue.add(this.offBikeEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, boolean ferry, IntsRef relationFlags) {
        String highway = way.getTag("highway");
        if (!way.hasTag("bicycle", this.accepted) && (this.pushBikeHighwayTags.contains(highway) || way.hasTag("railway", (Object)"platform")) || "steps".equals(highway) || way.hasTag("bicycle", (Object)"dismount")) {
            this.offBikeEnc.setBool(false, edgeFlags, true);
        }
        return edgeFlags;
    }
}

