/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class WheelchairFlagEncoder
extends FootFlagEncoder {
    private final Set<String> excludeSurfaces = new HashSet<String>();
    private final Set<String> excludeSmoothness = new HashSet<String>();
    private final Set<String> excludeHighwayTags = new HashSet<String>();
    private final int maxInclinePercent = 6;

    public WheelchairFlagEncoder() {
        this(4, 1.0);
    }

    public WheelchairFlagEncoder(PMap properties) {
        this(properties.getInt("speed_bits", 4), properties.getDouble("speed_factor", 1.0));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
        this.blockBarriersByDefault(properties.getBool("block_barriers", false));
    }

    protected WheelchairFlagEncoder(int speedBits, double speedFactor) {
        super(speedBits, speedFactor);
        this.restrictions.add("wheelchair");
        this.absoluteBarriers.add("handrail");
        this.absoluteBarriers.add("wall");
        this.absoluteBarriers.add("turnstile");
        this.potentialBarriers.add("kerb");
        this.potentialBarriers.add("cattle_grid");
        this.potentialBarriers.add("motorcycle_barrier");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.excludeHighwayTags.add("trunk");
        this.excludeHighwayTags.add("trunk_link");
        this.excludeHighwayTags.add("primary");
        this.excludeHighwayTags.add("primary_link");
        this.excludeHighwayTags.add("secondary");
        this.excludeHighwayTags.add("secondary_link");
        this.excludeHighwayTags.add("tertiary");
        this.excludeHighwayTags.add("tertiary_link");
        this.excludeHighwayTags.add("steps");
        this.excludeHighwayTags.add("track");
        this.excludeSurfaces.add("cobblestone");
        this.excludeSurfaces.add("gravel");
        this.excludeSurfaces.add("sand");
        this.excludeSmoothness.add("bad");
        this.excludeSmoothness.add("very_bad");
        this.excludeSmoothness.add("horrible");
        this.excludeSmoothness.add("very_horrible");
        this.excludeSmoothness.add("impassable");
        this.allowedHighwayTags.addAll(this.safeHighwayTags);
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
        this.maxPossibleSpeed = 15;
        this.speedTwoDirections = true;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String tagValue;
        String sidewalk;
        if (way.hasTag("wheelchair", (Collection<String>)this.intendedValues)) {
            return EncodingManager.Access.WAY;
        }
        if (way.getTag("sac_scale") != null) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("highway", this.excludeHighwayTags) && !way.hasTag("sidewalk", (Collection<String>)this.sidewalkValues)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("surface", this.excludeSurfaces)) {
            if (!way.hasTag("sidewalk", (Collection<String>)this.sidewalkValues)) {
                return EncodingManager.Access.CAN_SKIP;
            }
            sidewalk = way.getTag("sidewalk");
            if (way.hasTag("sidewalk:" + sidewalk + ":surface", this.excludeSurfaces)) {
                return EncodingManager.Access.CAN_SKIP;
            }
        }
        if (way.hasTag("smoothness", this.excludeSmoothness)) {
            if (!way.hasTag("sidewalk", (Collection<String>)this.sidewalkValues)) {
                return EncodingManager.Access.CAN_SKIP;
            }
            sidewalk = way.getTag("sidewalk");
            if (way.hasTag("sidewalk:" + sidewalk + ":smoothness", this.excludeSmoothness)) {
                return EncodingManager.Access.CAN_SKIP;
            }
        }
        if (way.hasTag("incline", new String[0]) && ((tagValue = way.getTag("incline")).endsWith("%") || tagValue.endsWith("\u00b0"))) {
            try {
                double incline = Double.parseDouble(tagValue.substring(0, tagValue.length() - 1));
                if (tagValue.endsWith("\u00b0")) {
                    incline = Math.tan(incline * Math.PI / 180.0) * 100.0;
                }
                if (-6.0 > incline || incline > 6.0) {
                    return EncodingManager.Access.CAN_SKIP;
                }
            }
            catch (NumberFormatException incline) {
                // empty catch block
            }
        }
        if (way.hasTag("kerb", (Object)"raised")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("kerb", new String[0]) && ((tagValue = way.getTag("kerb")).endsWith("cm") || tagValue.endsWith("mm"))) {
            try {
                int maxKerbHeightCm;
                float kerbHeight = Float.parseFloat(tagValue.substring(0, tagValue.length() - 2));
                if (tagValue.endsWith("mm")) {
                    kerbHeight /= 100.0f;
                }
                if (kerbHeight > (float)(maxKerbHeightCm = 3)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.getAccess(way);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access) {
        if (access.canSkip()) {
            return edgeFlags;
        }
        this.accessEnc.setBool(false, edgeFlags, true);
        this.accessEnc.setBool(true, edgeFlags, true);
        if (!access.isFerry()) {
            this.setSpeed(edgeFlags, true, true, 5.0);
        } else {
            double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
            this.setSpeed(edgeFlags, true, true, ferrySpeed);
        }
        return edgeFlags;
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        int smallInclinePercent;
        PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
        double prevEle = pl.getEle(0);
        double fullDist2D = edge.getDistance();
        if (Double.isInfinite(fullDist2D)) {
            throw new IllegalStateException("Infinite distance should not happen due to #435. way ID=" + way.getId());
        }
        if (fullDist2D < 1.0) {
            return;
        }
        double eleDelta = pl.getEle(pl.size() - 1) - prevEle;
        double elePercent = eleDelta / fullDist2D * 100.0;
        if (elePercent > (double)(smallInclinePercent = 3) && elePercent < 6.0) {
            this.setFwdBwdSpeed(edge, 2, 5);
        } else if (elePercent < (double)(-smallInclinePercent) && elePercent > -6.0) {
            this.setFwdBwdSpeed(edge, 5, 2);
        } else if (elePercent > 6.0 || elePercent < -6.0) {
            edge.set(this.accessEnc, false);
            edge.setReverse(this.accessEnc, false);
        }
    }

    private void setFwdBwdSpeed(EdgeIteratorState edge, int fwdSpeed, int bwdSpeed) {
        if (edge.get(this.accessEnc)) {
            edge.set(this.avgSpeedEnc, (double)fwdSpeed);
        }
        if (edge.getReverse(this.accessEnc)) {
            edge.setReverse(this.avgSpeedEnc, (double)bwdSpeed);
        }
    }

    @Override
    protected int handlePriority(ReaderWay way, Integer priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        weightToPrioMap.put(100.0, super.handlePriority(way, priorityFromRelation));
        if (way.hasTag("wheelchair", (Object)"designated")) {
            weightToPrioMap.put(102.0, PriorityCode.VERY_NICE.getValue());
        } else if (way.hasTag("wheelchair", (Object)"limited")) {
            weightToPrioMap.put(102.0, PriorityCode.AVOID.getValue());
        }
        return (Integer)weightToPrioMap.lastEntry().getValue();
    }

    @Override
    public String toString() {
        return "wheelchair";
    }
}

