/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.ch.NodeBasedNodeContractor;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.util.AllCHEdgesIterator;
import com.graphhopper.storage.CHGraph;
import java.util.ArrayList;
import java.util.List;

class NodeBasedShortcutInserter
implements NodeBasedNodeContractor.ShortcutHandler {
    private final CHGraph chGraph;
    private final int origEdges;
    private final List<Shortcut> shortcuts;
    private final IntArrayList shortcutsByPrepareEdges;

    NodeBasedShortcutInserter(CHGraph chGraph) {
        this.chGraph = chGraph;
        this.shortcuts = new ArrayList<Shortcut>();
        this.origEdges = chGraph.getOriginalEdges();
        this.shortcutsByPrepareEdges = new IntArrayList();
    }

    @Override
    public void startContractingNode() {
        this.shortcuts.clear();
    }

    @Override
    public void addOutShortcut(int prepareEdge, int node, int adjNode, int skipped1, int skipped2, double weight) {
        this.shortcuts.add(new Shortcut(prepareEdge, -1, node, adjNode, skipped1, skipped2, PrepareEncoder.getScFwdDir(), weight));
    }

    @Override
    public void addInShortcut(int prepareEdge, int node, int adjNode, int skipped1, int skipped2, double weight) {
        boolean bidir = false;
        for (Shortcut sc : this.shortcuts) {
            if (sc.to != adjNode || Double.doubleToLongBits(sc.weight) != Double.doubleToLongBits(weight) || this.getShortcutForPrepareEdge(sc.skippedEdge1) != this.getShortcutForPrepareEdge(skipped1) || this.getShortcutForPrepareEdge(sc.skippedEdge2) != this.getShortcutForPrepareEdge(skipped2) || sc.flags != PrepareEncoder.getScFwdDir()) continue;
            sc.flags = PrepareEncoder.getScDirMask();
            sc.prepareEdgeBwd = prepareEdge;
            bidir = true;
            break;
        }
        if (!bidir) {
            this.shortcuts.add(new Shortcut(-1, prepareEdge, node, adjNode, skipped1, skipped2, PrepareEncoder.getScBwdDir(), weight));
        }
    }

    @Override
    public int finishContractingNode() {
        int shortcutCount = 0;
        for (Shortcut sc : this.shortcuts) {
            int scId = this.chGraph.shortcut(sc.from, sc.to, sc.flags, sc.weight, sc.skippedEdge1, sc.skippedEdge2);
            if (sc.flags == PrepareEncoder.getScFwdDir()) {
                this.setShortcutForPrepareEdge(sc.prepareEdgeFwd, scId);
            } else if (sc.flags == PrepareEncoder.getScBwdDir()) {
                this.setShortcutForPrepareEdge(sc.prepareEdgeBwd, scId);
            } else {
                this.setShortcutForPrepareEdge(sc.prepareEdgeFwd, scId);
                this.setShortcutForPrepareEdge(sc.prepareEdgeBwd, scId);
            }
            ++shortcutCount;
        }
        return shortcutCount;
    }

    @Override
    public void finishContraction() {
        AllCHEdgesIterator iter = this.chGraph.getAllEdges();
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            int skip1 = this.getShortcutForPrepareEdge(iter.getSkippedEdge1());
            int skip2 = this.getShortcutForPrepareEdge(iter.getSkippedEdge2());
            iter.setSkippedEdges(skip1, skip2);
        }
    }

    private void setShortcutForPrepareEdge(int prepareEdge, int shortcut) {
        int index = prepareEdge - this.origEdges;
        if (index >= this.shortcutsByPrepareEdges.size()) {
            this.shortcutsByPrepareEdges.resize(index + 1);
        }
        this.shortcutsByPrepareEdges.set(index, shortcut);
    }

    private int getShortcutForPrepareEdge(int prepareEdge) {
        if (prepareEdge < this.origEdges) {
            return prepareEdge;
        }
        int index = prepareEdge - this.origEdges;
        return this.shortcutsByPrepareEdges.get(index);
    }

    private static class Shortcut {
        int prepareEdgeFwd;
        int prepareEdgeBwd;
        int from;
        int to;
        int skippedEdge1;
        int skippedEdge2;
        double weight;
        int flags;

        public Shortcut(int prepareEdgeFwd, int prepareEdgeBwd, int from, int to, int skippedEdge1, int skippedEdge2, int flags, double weight) {
            this.prepareEdgeFwd = prepareEdgeFwd;
            this.prepareEdgeBwd = prepareEdgeBwd;
            this.from = from;
            this.to = to;
            this.skippedEdge1 = skippedEdge1;
            this.skippedEdge2 = skippedEdge2;
            this.flags = flags;
            this.weight = weight;
        }

        public String toString() {
            String str = this.flags == PrepareEncoder.getScDirMask() ? this.from + "<->" : this.from + "->";
            return str + this.to + ", weight:" + this.weight + " (" + this.skippedEdge1 + "," + this.skippedEdge2 + ")";
        }
    }
}

