/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.DefaultBidirPathExtractor;
import com.graphhopper.routing.ch.ShortcutUnpacker;
import com.graphhopper.storage.RoutingCHGraph;

public class NodeBasedCHBidirPathExtractor
extends DefaultBidirPathExtractor {
    private final ShortcutUnpacker shortcutUnpacker;
    private final RoutingCHGraph routingGraph;

    public NodeBasedCHBidirPathExtractor(RoutingCHGraph routingGraph) {
        super(routingGraph.getBaseGraph(), routingGraph.getWeighting());
        this.routingGraph = routingGraph;
        this.shortcutUnpacker = this.createShortcutUnpacker();
    }

    @Override
    public void onEdge(int edge, int adjNode, boolean reverse, int prevOrNextEdge) {
        if (reverse) {
            this.shortcutUnpacker.visitOriginalEdgesBwd(edge, adjNode, true, prevOrNextEdge);
        } else {
            this.shortcutUnpacker.visitOriginalEdgesFwd(edge, adjNode, true, prevOrNextEdge);
        }
    }

    private ShortcutUnpacker createShortcutUnpacker() {
        return new ShortcutUnpacker(this.routingGraph, (edge, reverse, prevOrNextEdgeId) -> {
            this.path.addDistance(edge.getDistance());
            this.path.addTime(this.routingGraph.getWeighting().calcEdgeMillis(edge, reverse));
            this.path.addEdge(edge.getEdge());
        }, false);
    }
}

