/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHPreparationHandler {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final List<PrepareContractionHierarchies> preparations = new ArrayList<PrepareContractionHierarchies>();
    private final List<CHProfile> chProfiles = new ArrayList<CHProfile>();
    private final List<CHConfig> chConfigs = new ArrayList<CHConfig>();
    private int preparationThreads;
    private ExecutorService threadPool;
    private PMap pMap = new PMap();

    public CHPreparationHandler() {
        this.setPreparationThreads(1);
    }

    public void init(GraphHopperConfig ghConfig) {
        if (ghConfig.has("prepare.threads")) {
            throw new IllegalStateException("Use prepare.ch.threads instead of prepare.threads");
        }
        if (ghConfig.has("prepare.chWeighting") || ghConfig.has("prepare.chWeightings") || ghConfig.has("prepare.ch.weightings")) {
            throw new IllegalStateException("Use profiles_ch instead of prepare.chWeighting, prepare.chWeightings or prepare.ch.weightings, see #1922 and docs/core/profiles.md");
        }
        if (ghConfig.has("prepare.ch.edge_based")) {
            throw new IllegalStateException("Use profiles_ch instead of prepare.ch.edge_based, see #1922 and docs/core/profiles.md");
        }
        this.setPreparationThreads(ghConfig.getInt("prepare.ch.threads", this.getPreparationThreads()));
        this.setCHProfiles(ghConfig.getCHProfiles());
        this.pMap = ghConfig.asPMap();
    }

    public final boolean isEnabled() {
        return !this.chProfiles.isEmpty() || !this.chConfigs.isEmpty() || !this.preparations.isEmpty();
    }

    public CHPreparationHandler addCHConfig(CHConfig chConfig) {
        this.chConfigs.add(chConfig);
        return this;
    }

    public CHPreparationHandler addPreparation(PrepareContractionHierarchies pch) {
        if (this.preparations.size() >= this.chConfigs.size()) {
            throw new IllegalStateException("You need to add the corresponding CH configs before adding preparations.");
        }
        CHConfig expectedConfig = this.chConfigs.get(this.preparations.size());
        if (!pch.getCHConfig().equals(expectedConfig)) {
            throw new IllegalArgumentException("CH config of preparation: " + pch + " needs to be identical to previously added CH config: " + expectedConfig);
        }
        this.preparations.add(pch);
        return this;
    }

    public final boolean hasCHConfigs() {
        return !this.chConfigs.isEmpty();
    }

    public List<CHConfig> getCHConfigs() {
        return this.chConfigs;
    }

    public List<CHConfig> getNodeBasedCHConfigs() {
        ArrayList<CHConfig> result = new ArrayList<CHConfig>();
        for (CHConfig chConfig : this.chConfigs) {
            if (chConfig.getTraversalMode().isEdgeBased()) continue;
            result.add(chConfig);
        }
        return result;
    }

    public List<CHConfig> getEdgeBasedCHConfigs() {
        ArrayList<CHConfig> result = new ArrayList<CHConfig>();
        for (CHConfig chConfig : this.chConfigs) {
            if (!chConfig.getTraversalMode().isEdgeBased()) continue;
            result.add(chConfig);
        }
        return result;
    }

    public CHPreparationHandler setCHProfiles(CHProfile ... chProfiles) {
        this.setCHProfiles(Arrays.asList(chProfiles));
        return this;
    }

    public CHPreparationHandler setCHProfiles(Collection<CHProfile> chProfiles) {
        this.chProfiles.clear();
        this.chProfiles.addAll(chProfiles);
        return this;
    }

    public List<CHProfile> getCHProfiles() {
        return this.chProfiles;
    }

    public List<PrepareContractionHierarchies> getPreparations() {
        return this.preparations;
    }

    public PrepareContractionHierarchies getPreparation(String profile) {
        if (this.preparations.isEmpty()) {
            throw new IllegalStateException("No CH preparations added yet");
        }
        ArrayList<String> profileNames = new ArrayList<String>(this.preparations.size());
        for (PrepareContractionHierarchies preparation : this.preparations) {
            profileNames.add(preparation.getCHConfig().getName());
            if (!preparation.getCHConfig().getName().equalsIgnoreCase(profile)) continue;
            return preparation;
        }
        throw new IllegalArgumentException("Cannot find CH preparation for the requested profile: '" + profile + "'\nYou can try disabling CH using " + "ch.disable" + "=true\navailable CH profiles: " + profileNames);
    }

    public PrepareContractionHierarchies getPreparation(CHConfig chConfig) {
        return this.getPreparation(chConfig.getName());
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
        this.threadPool = Executors.newFixedThreadPool(preparationThreads);
    }

    public void prepare(StorableProperties properties, boolean closeEarly) {
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(this.threadPool);
        int counter = 0;
        for (PrepareContractionHierarchies prepare : this.preparations) {
            this.LOGGER.info(++counter + "/" + this.preparations.size() + " calling CH prepare.doWork for profile '" + prepare.getCHConfig().getName() + "' " + (Object)((Object)prepare.getCHConfig().getTraversalMode()) + " ... (" + Helper.getMemInfo() + ")");
            String name = prepare.getCHConfig().getName();
            completionService.submit(() -> {
                Thread.currentThread().setName(name);
                prepare.doWork();
                if (closeEarly) {
                    prepare.close();
                }
                properties.put("prepare.ch.date." + name, Helper.createFormatter().format(new Date()));
            }, name);
        }
        this.threadPool.shutdown();
        try {
            for (int i = 0; i < this.preparations.size(); ++i) {
                completionService.take().get();
            }
        }
        catch (Exception e) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(e);
        }
        this.LOGGER.info("Finished CH preparation, {}", (Object)Helper.getMemInfo());
    }

    public void createPreparations(GraphHopperStorage ghStorage) {
        if (!this.isEnabled() || !this.preparations.isEmpty()) {
            return;
        }
        if (!this.hasCHConfigs()) {
            throw new IllegalStateException("No CH profiles found");
        }
        this.LOGGER.info("Creating CH preparations, {}", (Object)Helper.getMemInfo());
        for (CHConfig chConfig : this.chConfigs) {
            this.addPreparation(this.createCHPreparation(ghStorage, chConfig));
        }
    }

    private PrepareContractionHierarchies createCHPreparation(GraphHopperStorage ghStorage, CHConfig chConfig) {
        PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraphHopperStorage(ghStorage, chConfig);
        pch.setParams(this.pMap);
        return pch;
    }
}

